/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import oruxmapsdesktop.OruxMapsDesktopApp;
import oruxmapsdesktop.ParamManager;
import oruxmapsdesktop.calculadora.CalibradorMapa;
import oruxmapsdesktop.calculadora.DatumAdmin;
import oruxmapsdesktop.calculadora.DatumData;
import oruxmapsdesktop.calculadora.MapaOruxMaps;
import oruxmapsdesktop.geoloc.ProjectionAdmin;
import oruxmapsdesktop.utilidades.FileUtils;
import oruxmapsdesktop.utilidades.GeoTiffReader;
import oruxmapsdesktop.utilidades.ImageUtils;
import oruxmapsdesktop.utilidades.KapReader;
import oruxmapsdesktop.utilidades.OkmReader;
import oruxmapsdesktop.utilidades.OruxMapsWriter;
import oruxmapsdesktop.utilidades.OziReader;
import oruxmapsdesktop.utilidades.SqliteManager;
import oruxmapsdesktop.utilidades.TfwReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPanelBatchConvertor
extends JPanel {
    private ResourceMap resourceMap;
    private String[] datumsStrings = null;
    private String[] projectionsStrings = null;
    private DatumData[] datums = null;
    private String lambertParams;
    private int ch1903 = DatumAdmin.busca("CH-1903Swiss");
    private int rd = DatumAdmin.busca("RijksdriehoeksmetingNederland");
    private static final DecimalFormat formatter00 = new DecimalFormat("00");
    private final int MAX_W = 8192;
    private StringBuilder mensajeTextArea = new StringBuilder();
    private Task batchTask;
    private File dirActualFinal = new File("");
    private File dirOrigenCal;
    private File dirDestMapas;
    private ButtonGroup buttonGroup1;
    private JButton jButtonParar;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBoxSqlite;
    private JComboBox jComboBoxDatum;
    private JComboBox jComboBoxProjection;
    private JComboBox jComboBoxQuality;
    private JLabel jLabel1;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel3;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton3;
    private JRadioButton jRadioButton4;
    private JRadioButton jRadioButton5;
    private JRadioButton jRadioButton6;
    private JRadioButton jRadioButtonJpg;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JTextField jTextFieldDestMapas;
    private JTextField jTextFieldDestOrigenCal;
    private JToggleButton jToggleButtonBatchConv;
    private JToggleButton jToggleButtonBuscaDirCal;
    private JToggleButton jToggleButtonBuscaDirDest;

    public JPanelBatchConvertor() {
        this.initComponents();
        this.initComponents2();
    }

    private void initComponents2() {
        int i;
        this.resourceMap = Application.getInstance(OruxMapsDesktopApp.class).getContext().getResourceMap(JPanelBatchConvertor.class);
        this.datums = DatumAdmin.dameDatums();
        if (this.datums != null) {
            this.datumsStrings = new String[this.datums.length];
            try {
                for (i = 0; i < this.datums.length; ++i) {
                    this.datumsStrings[i] = this.datums[i].datum + ": " + this.datums[i].region;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.datumsStrings = new String[1];
            this.datumsStrings[0] = "";
        }
        this.projectionsStrings = new String[ProjectionAdmin.PROJECTIONS_TITLE.length];
        for (i = 0; i < this.projectionsStrings.length; ++i) {
            this.projectionsStrings[i] = ProjectionAdmin.PROJECTIONS_TITLE[i];
        }
        this.projectionsStrings[0] = this.resourceMap.getString("proyeccion", new Object[0]);
        this.datumsStrings[0] = this.resourceMap.getString("datum", new Object[0]);
        this.jComboBoxDatum.setModel(new DefaultComboBoxModel<String>(this.datumsStrings));
        this.jComboBoxProjection.setModel(new DefaultComboBoxModel<String>(this.projectionsStrings));
    }

    public void actualizaMsg(String mensaje) {
        this.mensajeTextArea.append(mensaje);
        this.jTextArea1.setText(this.mensajeTextArea.toString());
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel3 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jToggleButtonBuscaDirCal = new JToggleButton();
        this.jTextFieldDestOrigenCal = new JTextField();
        this.jTextFieldDestMapas = new JTextField();
        this.jToggleButtonBuscaDirDest = new JToggleButton();
        this.jLabel8 = new JLabel();
        this.jToggleButtonBatchConv = new JToggleButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jLabel9 = new JLabel();
        this.jButtonParar = new JButton();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButtonJpg = new JRadioButton();
        this.jComboBoxQuality = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jComboBoxDatum = new JComboBox();
        this.jComboBoxProjection = new JComboBox();
        this.jRadioButton2 = new JRadioButton();
        this.jCheckBoxSqlite = new JCheckBox();
        this.jCheckBox1 = new JCheckBox();
        this.jRadioButton3 = new JRadioButton();
        this.jRadioButton4 = new JRadioButton();
        this.jRadioButton5 = new JRadioButton();
        this.jRadioButton6 = new JRadioButton();
        this.setName("Form");
        this.setPreferredSize(new Dimension(930, 550));
        this.jPanel3.setName("jPanel3");
        ResourceMap resourceMap = Application.getInstance(OruxMapsDesktopApp.class).getContext().getResourceMap(JPanelBatchConvertor.class);
        this.jLabel7.setText(resourceMap.getString("jLabel7.text", new Object[0]));
        this.jLabel7.setName("jLabel7");
        this.jToggleButtonBuscaDirCal.setText(resourceMap.getString("jToggleButtonBuscaDirCal.text", new Object[0]));
        this.jToggleButtonBuscaDirCal.setName("jToggleButtonBuscaDirCal");
        this.jToggleButtonBuscaDirCal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelBatchConvertor.this.jToggleButtonBuscaDirCalActionPerformed(evt);
            }
        });
        this.jTextFieldDestOrigenCal.setName("jTextFieldDestOrigenCal");
        this.jTextFieldDestMapas.setName("jTextFieldDestMapas");
        this.jToggleButtonBuscaDirDest.setText(resourceMap.getString("jToggleButtonBuscaDirDest.text", new Object[0]));
        this.jToggleButtonBuscaDirDest.setName("jToggleButtonBuscaDirDest");
        this.jToggleButtonBuscaDirDest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelBatchConvertor.this.jToggleButtonBuscaDirDestActionPerformed(evt);
            }
        });
        this.jLabel8.setText(resourceMap.getString("jLabel8.text", new Object[0]));
        this.jLabel8.setName("jLabel8");
        ApplicationActionMap actionMap = Application.getInstance(OruxMapsDesktopApp.class).getContext().getActionMap(JPanelBatchConvertor.class, this);
        this.jToggleButtonBatchConv.setAction(actionMap.get("creaOruxMapsBatch"));
        this.jToggleButtonBatchConv.setText(resourceMap.getString("jToggleButtonBatchConv.text", new Object[0]));
        this.jToggleButtonBatchConv.setName("jToggleButtonBatchConv");
        this.jScrollPane1.setName("jScrollPane1");
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setName("jTextArea1");
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jLabel9.setIcon(resourceMap.getIcon("jLabel9.icon"));
        this.jLabel9.setText(resourceMap.getString("jLabel9.text", new Object[0]));
        this.jLabel9.setName("jLabel9");
        this.jButtonParar.setText(resourceMap.getString("jButtonParar.text", new Object[0]));
        this.jButtonParar.setName("jButtonParar");
        this.jButtonParar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelBatchConvertor.this.jButtonPararActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText(resourceMap.getString("jRadioButton1.text", new Object[0]));
        this.jRadioButton1.setName("jRadioButton1");
        this.buttonGroup1.add(this.jRadioButtonJpg);
        this.jRadioButtonJpg.setText(resourceMap.getString("jRadioButtonJpg.text", new Object[0]));
        this.jRadioButtonJpg.setName("jRadioButtonJpg");
        this.jComboBoxQuality.setModel(new DefaultComboBoxModel<String>(new String[]{"100%", "95%", "90%", "85%", "80%", "75%", "70%", "65%", "60%", "55%", "50%"}));
        this.jComboBoxQuality.setSelectedIndex(3);
        this.jComboBoxQuality.setName("jComboBoxQuality");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jComboBoxDatum.setToolTipText(resourceMap.getString("jComboBoxDatum.toolTipText", new Object[0]));
        this.jComboBoxDatum.setAutoscrolls(true);
        this.jComboBoxDatum.setEnabled(false);
        this.jComboBoxDatum.setName("jComboBoxDatum");
        this.jComboBoxProjection.setToolTipText(resourceMap.getString("jComboBoxProjection.toolTipText", new Object[0]));
        this.jComboBoxProjection.setEnabled(false);
        this.jComboBoxProjection.setName("jComboBoxProjection");
        this.jComboBoxProjection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelBatchConvertor.this.jComboBoxProjectionActionPerformed(evt);
            }
        });
        this.jRadioButton2.setAction(actionMap.get("forzarDatum"));
        this.jRadioButton2.setText(resourceMap.getString("jRadioButton2.text", new Object[0]));
        this.jRadioButton2.setName("jRadioButton2");
        this.jCheckBoxSqlite.setSelected(true);
        this.jCheckBoxSqlite.setText(resourceMap.getString("jCheckBoxSqlite.text", new Object[0]));
        this.jCheckBoxSqlite.setName("jCheckBoxSqlite");
        this.jCheckBox1.setText(resourceMap.getString("jCheckBox1.text", new Object[0]));
        this.jCheckBox1.setName("jCheckBox1");
        this.jCheckBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelBatchConvertor.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jRadioButton3.setText(resourceMap.getString("jRadioButton3.text", new Object[0]));
        this.jRadioButton3.setEnabled(false);
        this.jRadioButton3.setName("jRadioButton3");
        this.jRadioButton4.setText(resourceMap.getString("jRadioButton4.text", new Object[0]));
        this.jRadioButton4.setEnabled(false);
        this.jRadioButton4.setName("jRadioButton4");
        this.jRadioButton5.setText(resourceMap.getString("jRadioButton5.text", new Object[0]));
        this.jRadioButton5.setEnabled(false);
        this.jRadioButton5.setName("jRadioButton5");
        this.jRadioButton6.setText(resourceMap.getString("jRadioButton6.text", new Object[0]));
        this.jRadioButton6.setEnabled(false);
        this.jRadioButton6.setName("jRadioButton6");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel9).addContainerGap(502, Short.MAX_VALUE)).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel8).addComponent(this.jLabel7)).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToggleButtonBuscaDirCal).addComponent(this.jToggleButtonBuscaDirDest))).addComponent(this.jRadioButton2)).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jComboBoxDatum, 0, 419, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.jComboBoxProjection, 0, 201, Short.MAX_VALUE)).addComponent(this.jTextFieldDestMapas, -1, 638, Short.MAX_VALUE).addComponent(this.jTextFieldDestOrigenCal, GroupLayout.Alignment.TRAILING, -1, 638, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonJpg).addComponent(this.jRadioButton1).addGroup(jPanel3Layout.createSequentialGroup().addGap(116, 116, 116).addComponent(this.jComboBoxQuality, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxSqlite))).addContainerGap()).addGroup(jPanel3Layout.createSequentialGroup().addGap(338, 338, 338).addComponent(this.jToggleButtonBatchConv, -2, 149, -2).addGap(136, 136, 136).addComponent(this.jButtonParar, -2, 149, -2).addContainerGap(158, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 930, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBox1).addGap(53, 53, 53).addComponent(this.jRadioButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton6).addContainerGap(522, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel9).addGap(5, 5, 5).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxDatum, -2, -1, -2).addComponent(this.jComboBoxProjection, -2, -1, -2).addComponent(this.jRadioButton2)).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jToggleButtonBuscaDirCal).addComponent(this.jTextFieldDestOrigenCal, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.jToggleButtonBuscaDirDest).addComponent(this.jTextFieldDestMapas, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jRadioButton1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonJpg)).addGroup(jPanel3Layout.createSequentialGroup().addGap(11, 11, 11).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxQuality, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jCheckBoxSqlite)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton3).addComponent(this.jRadioButton4).addComponent(this.jRadioButton5).addComponent(this.jRadioButton6).addComponent(this.jCheckBox1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jToggleButtonBatchConv).addComponent(this.jButtonParar)).addGap(18, 18, 18).addComponent(this.jScrollPane1, -1, 209, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE));
    }

    private void jToggleButtonBuscaDirCalActionPerformed(ActionEvent evt) {
        File f = FileUtils.seleccionaDirectorio(this, this.dirActualFinal.getAbsolutePath());
        if (f != null) {
            this.dirOrigenCal = f;
            this.dirActualFinal = f;
            this.jTextFieldDestOrigenCal.setText(f.toString());
        }
    }

    private void jToggleButtonBuscaDirDestActionPerformed(ActionEvent evt) {
        File f = FileUtils.seleccionaDirectorio(this, this.dirActualFinal.getAbsolutePath());
        if (f != null) {
            this.dirDestMapas = f;
            this.dirActualFinal = f;
            this.jTextFieldDestMapas.setText(f.toString());
        }
    }

    private void jButtonPararActionPerformed(ActionEvent evt) {
        if (this.batchTask != null) {
            try {
                ((CreaOruxMapTaskBatch)this.batchTask).para = true;
            }
            catch (Exception e) {
                ((CreaOruxMapSqliteTaskBatch)this.batchTask).para = true;
            }
        }
    }

    private void jComboBoxProjectionActionPerformed(ActionEvent evt) {
        String pro = (String)this.jComboBoxProjection.getSelectedItem();
        this.jComboBoxProjection.hidePopup();
        try {
            this.lambertParams = ParamManager.getParams(this, pro);
        }
        catch (Exception e) {
            this.displayMsg(this.resourceMap.getString("wrong_val", new Object[0]));
        }
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        boolean b = this.jCheckBox1.isSelected();
        this.jRadioButton3.setEnabled(b);
        this.jRadioButton4.setEnabled(b);
        this.jRadioButton5.setEnabled(b);
        this.jRadioButton6.setEnabled(b);
    }

    private void displayMsg(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Warning", 2);
    }

    @Action
    public Task creaOruxMapsBatch() {
        String ori = this.jTextFieldDestOrigenCal.getText();
        if (ori == null || !new File(ori).isDirectory()) {
            this.displayMsg(this.resourceMap.getString("dir_origen_vacio", new Object[0]));
            return null;
        }
        this.dirOrigenCal = new File(ori);
        String dest = this.jTextFieldDestMapas.getText();
        if (dest == null || !new File(dest).isDirectory() || new File(dest).list().length != 0) {
            this.displayMsg(this.resourceMap.getString("dir_no_vacio", new Object[0]));
            return null;
        }
        this.dirDestMapas = new File(dest);
        File[] files = new File[]{};
        files = this.buscaFicherosRecursivo(new ArrayList<File>(), this.dirOrigenCal).toArray(files);
        this.mensajeTextArea = new StringBuilder();
        this.mensajeTextArea.append(this.resourceMap.getString("fich_enc", new Object[0]) + files.length);
        this.jTextArea1.setText(this.mensajeTextArea.toString());
        this.jToggleButtonBatchConv.setEnabled(false);
        this.batchTask = this.jCheckBoxSqlite.isSelected() ? new CreaOruxMapSqliteTaskBatch(Application.getInstance(OruxMapsDesktopApp.class), files, this.dirDestMapas) : new CreaOruxMapTaskBatch(Application.getInstance(OruxMapsDesktopApp.class), files, this.dirDestMapas);
        return this.batchTask;
    }

    private ArrayList<File> buscaFicherosRecursivo(ArrayList<File> files, File dirOrigenCal) {
        if (dirOrigenCal.isDirectory()) {
            File[] res = dirOrigenCal.listFiles(new FileUtils.MyFilterMap2());
            if (res != null) {
                for (File f : res) {
                    files.add(f);
                }
            }
            if ((res = dirOrigenCal.listFiles(new FileUtils.MyFilterDir())) != null) {
                for (File f : res) {
                    this.buscaFicherosRecursivo(files, f);
                }
            }
        }
        return files;
    }

    private MapaOruxMaps extraeMapCalibration2(File ficheroCal) throws Exception {
        MapaOruxMaps mc2 = null;
        if (ficheroCal.toString().toLowerCase().endsWith(".map")) {
            int[] imagem;
            mc2 = OziReader.lee(ficheroCal);
            if (!new File(mc2.dirImg).exists()) {
                int i = ficheroCal.getName().lastIndexOf(".");
                String mapa = FileUtils.buscaImagen(ficheroCal.getParentFile(), ficheroCal.getName().substring(0, i), FileUtils.imageType);
                if (mapa != null) {
                    mc2.dirImg = ficheroCal.getParent() + File.separator + mapa;
                } else {
                    String path2 = ficheroCal.getParent() + File.separator + mc2.dirImg;
                    if (new File(path2).exists()) {
                        mc2.dirImg = path2;
                    } else {
                        File f = new File(mc2.dirImg);
                        String path3 = ficheroCal.getParent() + File.separator + f.getName();
                        if (new File(path3).exists()) {
                            mc2.dirImg = path3;
                        } else {
                            throw new Exception(this.resourceMap.getString("img_fail", new Object[0]));
                        }
                    }
                }
            }
            if ((imagem = ImageUtils.leeImagenDim(new File(mc2.dirImg)))[0] < 1) {
                throw new Exception(this.resourceMap.getString("img_fail", new Object[0]));
            }
            mc2.anchoImagen = imagem[0];
            mc2.altoImagen = imagem[1];
            OziReader.recolocaPuntos(mc2.puntosCalibracionA);
            OziReader.recolocaPuntos(mc2.puntosCalibracionB);
        } else if (ficheroCal.toString().toLowerCase().endsWith(".okm")) {
            int[] imagem;
            mc2 = OkmReader.lee(ficheroCal);
            if (!new File(mc2.dirImg).exists()) {
                int i = ficheroCal.getName().lastIndexOf(".");
                String mapa = FileUtils.buscaImagen(ficheroCal.getParentFile(), ficheroCal.getName().substring(0, i), FileUtils.imageType);
                if (mapa != null) {
                    mc2.dirImg = ficheroCal.getParent() + File.separator + mapa;
                } else {
                    String path2 = ficheroCal.getParent() + File.separator + mc2.dirImg;
                    if (new File(path2).exists()) {
                        mc2.dirImg = path2;
                    } else {
                        File f = new File(mc2.dirImg);
                        String path3 = ficheroCal.getParent() + File.separator + f.getName();
                        if (new File(path3).exists()) {
                            mc2.dirImg = path3;
                        } else {
                            throw new Exception(this.resourceMap.getString("img_fail", new Object[0]));
                        }
                    }
                }
            }
            if ((imagem = ImageUtils.leeImagenDim(new File(mc2.dirImg)))[0] < 1) {
                throw new Exception(this.resourceMap.getString("img_fail", new Object[0]));
            }
            mc2.anchoImagen = imagem[0];
            mc2.altoImagen = imagem[1];
            OziReader.recolocaPuntos(mc2.puntosCalibracionA);
        } else if (ficheroCal.toString().toLowerCase().endsWith("tfw") || ficheroCal.toString().toLowerCase().endsWith("pgw") || ficheroCal.toString().toLowerCase().endsWith("tfwx") || ficheroCal.toString().toLowerCase().endsWith("jpw") || ficheroCal.toString().toLowerCase().endsWith("kap")) {
            int[] dim;
            int i = ficheroCal.toString().toLowerCase().endsWith("tfwx") ? 5 : 4;
            String mapa = FileUtils.buscaImagen(ficheroCal.getParentFile(), ficheroCal.getName().substring(0, ficheroCal.getName().length() - i), FileUtils.imageType);
            if (mapa != null) {
                mapa = ficheroCal.getParentFile().getAbsolutePath() + File.separator + mapa;
            }
            if ((dim = ImageUtils.leeImagenDim(new File(mapa)))[0] == -1) {
                throw new Exception(this.resourceMap.getString("img_fail", new Object[0]));
            }
            mc2 = ficheroCal.toString().toLowerCase().endsWith("tfw") || ficheroCal.toString().toLowerCase().endsWith("pgw") || ficheroCal.toString().toLowerCase().endsWith("tfwx") || ficheroCal.toString().toLowerCase().endsWith("jpw") ? TfwReader.lee(ficheroCal, dim[0], dim[1]) : KapReader.lee(ficheroCal, dim[0], dim[1]);
            mc2.dirImg = mapa;
        } else if (ficheroCal.getName().toLowerCase().endsWith("tif") || ficheroCal.getName().toLowerCase().endsWith("tiff")) {
            mc2 = GeoTiffReader.lee(ficheroCal);
        } else {
            throw new Exception(this.resourceMap.getString("ext_fail", new Object[0]));
        }
        if (this.jRadioButton2.isSelected()) {
            mc2.datum = this.jComboBoxDatum.getSelectedIndex();
            mc2.proyeccion = this.jComboBoxProjection.getSelectedIndex();
            mc2.proyeccionData = this.lambertParams;
        }
        if (mc2.datum == this.ch1903 || mc2.datum == this.rd && mc2.proyeccion == 7) {
            if (Double.isNaN(mc2.puntosCalibracionA.get((int)0).xLon)) {
                mc2.puntosCalUser = mc2.puntosCalibracionA;
                CalibradorMapa.calibraWGS84Grid(mc2);
            } else {
                mc2.puntosCalUser = mc2.puntosCalibracionA;
                CalibradorMapa.calibraWGS84Geo(mc2);
            }
        } else if (mc2.datum > 0) {
            if (CalibradorMapa.coodenadasEsquinasOk(mc2, mc2.puntosCalibracionB)) {
                mc2.puntosCalUser = mc2.puntosCalibracionB;
                CalibradorMapa.calibraWGS84Geo(mc2);
            } else if (Double.isNaN(mc2.puntosCalibracionA.get((int)0).xLon)) {
                mc2.puntosCalUser = mc2.puntosCalibracionA;
                CalibradorMapa.calibraWGS84Grid(mc2);
            } else {
                mc2.puntosCalUser = mc2.puntosCalibracionA;
                CalibradorMapa.calibraWGS84Geo(mc2);
            }
        } else {
            throw new Exception(this.resourceMap.getString("dt_nosoportado", new Object[0]));
        }
        if (mc2.proyeccion == 0) {
            throw new Exception(this.resourceMap.getString("pj_nosoportado", new Object[0]));
        }
        return mc2;
    }

    @Action
    public void forzarDatum() {
        boolean bol = this.jRadioButton2.isSelected();
        this.jComboBoxDatum.setEnabled(bol);
        this.jComboBoxProjection.setEnabled(bol);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CreaOruxMapSqliteTaskBatch
    extends Task<Object, Void> {
        private final int size = 512;
        private File[] fichCalibracion;
        private File dirDestinoMapas;
        public boolean para;

        CreaOruxMapSqliteTaskBatch(Application app, File[] fichCalibracion, File destinoMapas) {
            super(app);
            this.size = 512;
            this.para = false;
            this.fichCalibracion = fichCalibracion;
            this.dirDestinoMapas = destinoMapas;
        }

        @Override
        protected Object doInBackground() {
            ImageInputStream imageStream = null;
            try {
                SqliteManager.loadDriver();
            }
            catch (Exception e) {
                return new Integer(99);
            }
            for (int iii = 0; iii < this.fichCalibracion.length; ++iii) {
                MapaOruxMaps mc2;
                try {
                    mc2 = JPanelBatchConvertor.this.extraeMapCalibration2(this.fichCalibracion[iii]);
                }
                catch (Exception e) {
                    this.setMessage(JPanelBatchConvertor.this.resourceMap.getString("fich_fallo", new Object[0]) + this.fichCalibracion[iii] + " " + e.getMessage() + "!!!");
                    continue;
                }
                if (JPanelBatchConvertor.this.jCheckBox1.isSelected()) {
                    mc2.capas[1] = JPanelBatchConvertor.this.jRadioButton3.isSelected();
                    mc2.capas[2] = JPanelBatchConvertor.this.jRadioButton4.isSelected();
                    mc2.capas[3] = JPanelBatchConvertor.this.jRadioButton5.isSelected();
                    mc2.capas[4] = JPanelBatchConvertor.this.jRadioButton6.isSelected();
                }
                for (int k = 1; k <= 4; ++k) {
                    int n = k;
                    mc2.capas[n] = mc2.capas[n] & mc2.nivelZoom - k >= 0;
                }
                File destFinal = new File(this.dirDestinoMapas + File.separator + mc2.nombreMapa);
                mc2.dirDest = destFinal.getParent();
                boolean success = destFinal.mkdir();
                if (!success) {
                    this.setMessage(JPanelBatchConvertor.this.resourceMap.getString("fich_fallo", new Object[0]) + this.fichCalibracion[iii] + "!!!");
                    continue;
                }
                SqliteManager sqlite = new SqliteManager(mc2);
                String tipo = !JPanelBatchConvertor.this.jRadioButtonJpg.isSelected() ? "JPEG" : "PNG";
                float calidad = (float)(100 - JPanelBatchConvertor.this.jComboBoxQuality.getSelectedIndex() * 5) / 100.0f;
                ImageWriter writer = ImageIO.getImageWritersByFormatName(tipo).next();
                ImageWriteParam iwparam = writer.getDefaultWriteParam();
                try {
                    iwparam.setCompressionMode(2);
                    iwparam.setCompressionQuality(calidad);
                }
                catch (Exception e) {
                    iwparam = writer.getDefaultWriteParam();
                }
                try {
                    int[] imgDim = ImageUtils.leeImagenDim(new File(mc2.dirImg));
                    int img_h = imgDim[1];
                    int img_w = imgDim[0];
                    int x = (img_w - 1) / 512;
                    int y = (img_h - 1) / 512;
                    mc2.numXimg = x + 1;
                    mc2.numYimg = y + 1;
                    int tiles = 0;
                    SqliteManager.loadDriver();
                    int factor = 1;
                    for (int k = 0; k < mc2.capas.length; ++k) {
                        if (mc2.capas[k]) {
                            tiles += ((mc2.anchoImagen / factor - 1) / 512 + 1) * ((mc2.altoImagen / factor - 1) / 512 + 1);
                        }
                        factor *= 2;
                    }
                    sqlite.initMapCreation(tiles);
                    ByteArrayOutputStream bao = new ByteArrayOutputStream(32768);
                    ImageReader reader = null;
                    ImageReadParam param = null;
                    BufferedImage bi = null;
                    factor = 1;
                    for (int k = 0; k < mc2.capas.length; ++k) {
                        if (mc2.capas[k]) {
                            for (int j = 0; j <= y; ++j) {
                                int kk = (img_w - 1) / 8192;
                                for (int kkk = 0; kkk <= kk; ++kkk) {
                                    imageStream = ImageIO.createImageInputStream(new File(mc2.dirImg));
                                    Iterator<ImageReader> it = ImageIO.getImageReaders(imageStream);
                                    while (it.hasNext()) {
                                        try {
                                            reader = it.next();
                                            param = reader.getDefaultReadParam();
                                            reader.setInput(imageStream);
                                            param.setSourceRegion(new Rectangle(kkk * 8192, j * 512 * factor, 8192 * (kkk + 1) < img_w ? 8192 : img_w - 8192 * kkk, 512 * factor));
                                            bi = reader.read(0, param);
                                            break;
                                        }
                                        catch (Exception e) {
                                            imageStream = ImageIO.createImageInputStream(new File(mc2.dirImg));
                                            bi = null;
                                        }
                                    }
                                    if (bi == null) {
                                        throw new Exception("error reading image");
                                    }
                                    x = img_w - kkk * 8192 > 8192 ? 8191 / (512 * factor) : (img_w - kkk * 8192) / (512 * factor);
                                    for (int i = 0; i <= x; ++i) {
                                        BufferedImage bi2 = new BufferedImage(512, 512, 5);
                                        Graphics2D g2 = bi2.createGraphics();
                                        g2.setBackground(new Color(203, 211, 243));
                                        g2.clearRect(0, 0, 512, 512);
                                        int size_w = img_w > (i + 1) * 512 * factor + kkk * 8192 ? 512 * factor : img_w - (i * 512 * factor + kkk * 8192);
                                        int size_h = img_h > (j + 1) * 512 * factor ? 512 * factor : img_h - j * 512 * factor;
                                        g2.drawImage(bi, 0, 0, size_w / factor, size_h / factor, i * 512 * factor, 0, i * 512 * factor + size_w, size_h, null);
                                        MemoryCacheImageOutputStream imgOut = new MemoryCacheImageOutputStream(bao);
                                        writer.setOutput(imgOut);
                                        writer.write(null, new IIOImage(bi2, null, null), iwparam);
                                        imgOut.close();
                                        sqlite.createTile(i + kkk * 8192 / (512 * factor), j, mc2.nivelZoom - k, bao.toByteArray());
                                        bao.reset();
                                    }
                                    sqlite.flush();
                                    reader.dispose();
                                    imageStream.close();
                                    System.gc();
                                }
                            }
                        }
                        y = (img_h - 1) / (512 * (factor *= 2));
                    }
                    sqlite.finishMapCreation();
                    OruxMapsWriter.creaOtrk3(mc2, destFinal.getParent());
                }
                catch (Throwable e) {
                    String msg = JPanelBatchConvertor.this.resourceMap.getString("fich_fallo", new Object[0]) + this.fichCalibracion[iii] + "!!!" + e.getMessage();
                    if (e instanceof OutOfMemoryError) {
                        msg = msg + JPanelBatchConvertor.this.resourceMap.getString("outofmemory", new Object[0]);
                    }
                    this.setMessage(msg);
                    continue;
                }
                this.setMessage("\nOK---->" + this.fichCalibracion[iii] + "!!!");
                if (writer != null) {
                    writer.dispose();
                }
                if (!this.para) continue;
                this.setMessage(JPanelBatchConvertor.this.resourceMap.getString("aborted", new Object[0]));
                return new Integer(0);
            }
            return new Integer(0);
        }

        @Override
        protected void succeeded(Object result) {
            switch ((Integer)result) {
                case 99: {
                    JOptionPane.showMessageDialog(JPanelBatchConvertor.this, JPanelBatchConvertor.this.resourceMap.getString("msg_error_sqlite", new Object[0]), "Warning", 2);
                    break;
                }
            }
            JPanelBatchConvertor.this.jToggleButtonBatchConv.setEnabled(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CreaOruxMapTaskBatch
    extends Task<Object, Void> {
        private final int size = 512;
        private File[] fichCalibracion;
        private File dirDestinoMapas;
        public boolean para;

        CreaOruxMapTaskBatch(Application app, File[] fichCalibracion, File destinoMapas) {
            super(app);
            this.size = 512;
            this.para = false;
            this.fichCalibracion = fichCalibracion;
            this.dirDestinoMapas = destinoMapas;
        }

        @Override
        protected Object doInBackground() {
            for (int iii = 0; iii < this.fichCalibracion.length; ++iii) {
                MapaOruxMaps mc2;
                try {
                    mc2 = JPanelBatchConvertor.this.extraeMapCalibration2(this.fichCalibracion[iii]);
                }
                catch (Exception e) {
                    this.setMessage(JPanelBatchConvertor.this.resourceMap.getString("fich_fallo", new Object[0]) + this.fichCalibracion[iii] + " " + e.getMessage() + "!!!");
                    continue;
                }
                if (JPanelBatchConvertor.this.jCheckBox1.isSelected()) {
                    mc2.capas[1] = JPanelBatchConvertor.this.jRadioButton3.isSelected();
                    mc2.capas[2] = JPanelBatchConvertor.this.jRadioButton4.isSelected();
                    mc2.capas[3] = JPanelBatchConvertor.this.jRadioButton5.isSelected();
                    mc2.capas[4] = JPanelBatchConvertor.this.jRadioButton6.isSelected();
                }
                for (int k = 1; k <= 4; ++k) {
                    int n = k;
                    mc2.capas[n] = mc2.capas[n] & mc2.nivelZoom - k >= 0;
                }
                boolean res = true;
                File destFinal = new File(this.dirDestinoMapas + File.separator + mc2.nombreMapa);
                res = destFinal.mkdir();
                mc2.dirDest = this.dirDestinoMapas.getAbsolutePath();
                for (int k = 0; k < mc2.capas.length; ++k) {
                    if (!mc2.capas[k]) continue;
                    String destFinalImg = mc2.dirDest + File.separator + mc2.nombreMapa + File.separator + mc2.nombreMapa + " " + formatter00.format(mc2.nivelZoom - k);
                    res &= new File(destFinalImg).mkdir();
                    res &= new File(destFinalImg + File.separator + "set").mkdir();
                }
                if (!res) {
                    this.setMessage(JPanelBatchConvertor.this.resourceMap.getString("fich_fallo", new Object[0]) + this.fichCalibracion[iii] + "!!!");
                    continue;
                }
                String tipo = !JPanelBatchConvertor.this.jRadioButtonJpg.isSelected() ? "JPEG" : "PNG";
                float calidad = (float)(100 - JPanelBatchConvertor.this.jComboBoxQuality.getSelectedIndex() * 5) / 100.0f;
                ImageWriter writer = ImageIO.getImageWritersByFormatName(tipo).next();
                ImageWriteParam iwparam = writer.getDefaultWriteParam();
                try {
                    iwparam.setCompressionMode(2);
                    iwparam.setCompressionQuality(calidad);
                }
                catch (Exception e) {
                    iwparam = writer.getDefaultWriteParam();
                }
                try {
                    ImageInputStream imageStream = ImageIO.createImageInputStream(new File(mc2.dirImg));
                    ImageReader reader = ImageIO.getImageReaders(imageStream).next();
                    ImageReadParam param = reader.getDefaultReadParam();
                    reader.setInput(imageStream);
                    int img_h = reader.getHeight(0);
                    int img_w = reader.getWidth(0);
                    int x = (img_w - 1) / 512;
                    int y = (img_h - 1) / 512;
                    mc2.numXimg = x + 1;
                    mc2.numYimg = y + 1;
                    BufferedImage bi = null;
                    int factor = 1;
                    for (int k = 0; k < mc2.capas.length; ++k) {
                        if (mc2.capas[k]) {
                            for (int j = 0; j <= y; ++j) {
                                int kk = (img_w - 1) / 8192;
                                for (int kkk = 0; kkk <= kk; ++kkk) {
                                    imageStream = ImageIO.createImageInputStream(new File(mc2.dirImg));
                                    Iterator<ImageReader> it = ImageIO.getImageReaders(imageStream);
                                    while (it.hasNext()) {
                                        try {
                                            reader = it.next();
                                            param = reader.getDefaultReadParam();
                                            reader.setInput(imageStream);
                                            param.setSourceRegion(new Rectangle(kkk * 8192, j * 512 * factor, 8192 * (kkk + 1) < img_w ? 8192 : img_w - 8192 * kkk, 512 * factor));
                                            bi = reader.read(0, param);
                                            break;
                                        }
                                        catch (Exception e) {
                                            imageStream = ImageIO.createImageInputStream(new File(mc2.dirImg));
                                            bi = null;
                                        }
                                    }
                                    if (bi == null) {
                                        throw new Exception("error reading image");
                                    }
                                    x = img_w - kkk * 8192 > 8192 ? 8191 / (512 * factor) : (img_w - kkk * 8192) / (512 * factor);
                                    for (int i = 0; i <= x; ++i) {
                                        BufferedImage bi2 = new BufferedImage(512, 512, 5);
                                        Graphics2D g2 = bi2.createGraphics();
                                        g2.setBackground(new Color(203, 211, 243));
                                        g2.clearRect(0, 0, 512, 512);
                                        int size_w = img_w > (i + 1) * 512 * factor + kkk * 8192 ? 512 * factor : img_w - (i * 512 * factor + kkk * 8192);
                                        int size_h = img_h > (j + 1) * 512 * factor ? 512 * factor : img_h - j * 512 * factor;
                                        g2.drawImage(bi, 0, 0, size_w / factor, size_h / factor, i * 512 * factor, 0, i * 512 * factor + size_w, size_h, null);
                                        File outputfile = new File(mc2.dirDest + File.separator + mc2.nombreMapa + File.separator + mc2.nombreMapa + " " + formatter00.format(mc2.nivelZoom - k) + File.separator + "set" + File.separator + mc2.nombreMapa + " " + formatter00.format(mc2.nivelZoom - k) + "_" + String.valueOf(i + kkk * 8192 / (512 * factor)) + "_" + j + mc2.file_ext);
                                        writer.setOutput(ImageIO.createImageOutputStream(outputfile));
                                        writer.write(null, new IIOImage(bi2, null, null), iwparam);
                                    }
                                    reader.dispose();
                                    imageStream.close();
                                    System.gc();
                                }
                            }
                        }
                        y = (img_h - 1) / (512 * (factor *= 2));
                    }
                    writer.dispose();
                    OruxMapsWriter.creaOtrk2(mc2, destFinal.getParent());
                }
                catch (Throwable e) {
                    String msg = JPanelBatchConvertor.this.resourceMap.getString("fich_fallo", new Object[0]) + this.fichCalibracion[iii] + "!!!" + e.getMessage();
                    if (e instanceof OutOfMemoryError) {
                        msg = msg + JPanelBatchConvertor.this.resourceMap.getString("outofmemory", new Object[0]);
                    }
                    this.setMessage(msg);
                    continue;
                }
                this.setMessage("\nOK---->" + this.fichCalibracion[iii] + "!!!");
                if (!this.para) continue;
                this.setMessage(JPanelBatchConvertor.this.resourceMap.getString("aborted", new Object[0]));
                return new Integer(0);
            }
            return new Integer(0);
        }

        @Override
        protected void succeeded(Object result) {
            JPanelBatchConvertor.this.jToggleButtonBatchConv.setEnabled(true);
        }
    }
}

