/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import oruxmapsdesktop.OruxMapsDesktopApp;
import oruxmapsdesktop.calculadora.DatumAdmin;
import oruxmapsdesktop.calculadora.DatumData;
import oruxmapsdesktop.calculadora.DatumtoWGS84;
import oruxmapsdesktop.calculadora.Ellipsoid;
import oruxmapsdesktop.geoloc.LatLonPoint;
import oruxmapsdesktop.geoloc.LatLonPointImpl;
import oruxmapsdesktop.geoloc.ParametrosProyeccion;
import oruxmapsdesktop.geoloc.ProjectionAdmin;
import oruxmapsdesktop.geoloc.ProjectionImpl;
import oruxmapsdesktop.geoloc.ProjectionPoint;
import oruxmapsdesktop.geoloc.projection.SwissGrid;
import oruxmapsdesktop.geoloc.projection.UtmProjection;
import oruxmapsdesktop.utilidades.CoordUtil;

public class JPanelCalculator
extends JPanel {
    private String[] datumsStrings = null;
    private DatumData[] datums = null;
    private ResourceMap resourceMap;
    private JButton jButtonDATtoDAT;
    private JButton jButtonLLtoUTM;
    private JButton jButtonSwissGridtoLL;
    private JButton jButtonSwissLLtoGrid;
    private JButton jButtonUTMtoLL;
    private JComboBox jComboBoxDATUMup;
    private JComboBox jComboBoxDest;
    private JComboBox jComboBoxGrid;
    private JComboBox jComboBoxNorth;
    private JComboBox jComboBoxORI;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTextField jTextFieldMolDesLon;
    private JTextField jTextFieldMolOrLat;
    private JTextField jTextFieldMolOrLon;
    private JTextField jTextFieldMorDesLat;
    private JTextField jTextFieldSwissEst;
    private JTextField jTextFieldSwissLat;
    private JTextField jTextFieldSwissLon;
    private JTextField jTextFieldSwissNorth;
    private JTextField jTextFieldUTME;
    private JTextField jTextFieldUTMLat;
    private JTextField jTextFieldUTMLon;
    private JTextField jTextFieldUTMN;

    public JPanelCalculator() {
        this.initComponents();
        this.initComponents2();
    }

    private void initComponents2() {
        this.resourceMap = Application.getInstance(OruxMapsDesktopApp.class).getContext().getResourceMap(JPanelCalculator.class);
        String filename = this.resourceMap.getResourcesDir() + "logoorux48.png";
        URL url = this.resourceMap.getClassLoader().getResource(filename);
        this.jLabel1.setIcon(new ImageIcon(url));
        this.datums = DatumAdmin.dameDatums();
        if (this.datums != null) {
            this.datumsStrings = new String[this.datums.length];
            for (int i = 0; i < this.datums.length; ++i) {
                this.datumsStrings[i] = this.datums[i].datum + ": " + this.datums[i].region;
            }
        } else {
            this.datumsStrings = new String[1];
        }
        this.jComboBoxDATUMup.setModel(new DefaultComboBoxModel<String>(this.datumsStrings));
        this.jComboBoxORI.setModel(new DefaultComboBoxModel<String>(this.datumsStrings));
        this.jComboBoxDest.setModel(new DefaultComboBoxModel<String>(this.datumsStrings));
        this.jComboBoxDest.setSelectedIndex(DatumAdmin.busca("WGS 1984Global Definition"));
        this.jComboBoxDest.setEnabled(false);
        String[] husos = new String[61];
        husos[0] = this.resourceMap.getString("husos", new Object[0]);
        for (int i = 1; i < 61; ++i) {
            husos[i] = new String("" + i);
        }
        this.jComboBoxGrid.setModel(new DefaultComboBoxModel<String>(husos));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldUTMN = new JTextField();
        this.jTextFieldUTME = new JTextField();
        this.jTextFieldUTMLat = new JTextField();
        this.jTextFieldUTMLon = new JTextField();
        this.jComboBoxDATUMup = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jButtonUTMtoLL = new JButton();
        this.jButtonLLtoUTM = new JButton();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jComboBoxGrid = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.jComboBoxNorth = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jComboBoxDest = new JComboBox();
        this.jComboBoxORI = new JComboBox();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jTextFieldMolOrLat = new JTextField();
        this.jTextFieldMolOrLon = new JTextField();
        this.jTextFieldMorDesLat = new JTextField();
        this.jTextFieldMolDesLon = new JTextField();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jButtonDATtoDAT = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jLabel13 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jTextFieldSwissLon = new JTextField();
        this.jTextFieldSwissLat = new JTextField();
        this.jTextFieldSwissNorth = new JTextField();
        this.jTextFieldSwissEst = new JTextField();
        this.jButtonSwissLLtoGrid = new JButton();
        this.jButtonSwissGridtoLL = new JButton();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.setName("Form");
        this.setPreferredSize(new Dimension(930, 550));
        ResourceMap resourceMap = Application.getInstance(OruxMapsDesktopApp.class).getContext().getResourceMap(JPanelCalculator.class);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jTextFieldUTMN.setText(resourceMap.getString("jTextFieldUTMN.text", new Object[0]));
        this.jTextFieldUTMN.setName("jTextFieldUTMN");
        this.jTextFieldUTME.setText(resourceMap.getString("jTextFieldUTME.text", new Object[0]));
        this.jTextFieldUTME.setName("jTextFieldUTME");
        this.jTextFieldUTMLat.setText(resourceMap.getString("jTextFieldUTMLat.text", new Object[0]));
        this.jTextFieldUTMLat.setToolTipText(resourceMap.getString("jTextFieldUTMLat.toolTipText", new Object[0]));
        this.jTextFieldUTMLat.setName("jTextFieldUTMLat");
        this.jTextFieldUTMLon.setText(resourceMap.getString("jTextFieldUTMLon.text", new Object[0]));
        this.jTextFieldUTMLon.setToolTipText(resourceMap.getString("jTextFieldUTMLat.toolTipText", new Object[0]));
        this.jTextFieldUTMLon.setName("jTextFieldUTMLon");
        this.jComboBoxDATUMup.setName("jComboBoxDATUMup");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.jButtonUTMtoLL.setText(resourceMap.getString("jButtonUTMtoLL.text", new Object[0]));
        this.jButtonUTMtoLL.setName("jButtonUTMtoLL");
        this.jButtonUTMtoLL.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelCalculator.this.jButtonUTMtoLLActionPerformed(evt);
            }
        });
        this.jButtonLLtoUTM.setText(resourceMap.getString("jButtonLLtoUTM.text", new Object[0]));
        this.jButtonLLtoUTM.setName("jButtonLLtoUTM");
        this.jButtonLLtoUTM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelCalculator.this.jButtonLLtoUTMActionPerformed(evt);
            }
        });
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.jComboBoxGrid.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxGrid.setName("jComboBoxGrid");
        this.jSeparator1.setName("jSeparator1");
        this.jComboBoxNorth.setModel(new DefaultComboBoxModel<String>(new String[]{"N", "S"}));
        this.jComboBoxNorth.setName("jComboBoxNorth");
        this.jLabel6.setText(resourceMap.getString("jLabel6.text", new Object[0]));
        this.jLabel6.setName("jLabel6");
        this.jComboBoxDest.setName("jComboBoxDest");
        this.jComboBoxORI.setName("jComboBoxORI");
        this.jLabel7.setText(resourceMap.getString("jLabel7.text", new Object[0]));
        this.jLabel7.setName("jLabel7");
        this.jLabel8.setText(resourceMap.getString("jLabel8.text", new Object[0]));
        this.jLabel8.setName("jLabel8");
        this.jTextFieldMolOrLat.setText(resourceMap.getString("jTextFieldMolOrLat.text", new Object[0]));
        this.jTextFieldMolOrLat.setToolTipText(resourceMap.getString("jTextFieldUTMLat.toolTipText", new Object[0]));
        this.jTextFieldMolOrLat.setName("jTextFieldMolOrLat");
        this.jTextFieldMolOrLon.setText(resourceMap.getString("jTextFieldMolOrLon.text", new Object[0]));
        this.jTextFieldMolOrLon.setToolTipText(resourceMap.getString("jTextFieldUTMLat.toolTipText", new Object[0]));
        this.jTextFieldMolOrLon.setName("jTextFieldMolOrLon");
        this.jTextFieldMorDesLat.setText(resourceMap.getString("jTextFieldMorDesLat.text", new Object[0]));
        this.jTextFieldMorDesLat.setName("jTextFieldMorDesLat");
        this.jTextFieldMolDesLon.setText(resourceMap.getString("jTextFieldMolDesLon.text", new Object[0]));
        this.jTextFieldMolDesLon.setName("jTextFieldMolDesLon");
        this.jLabel9.setText(resourceMap.getString("jLabel9.text", new Object[0]));
        this.jLabel9.setName("jLabel9");
        this.jLabel10.setText(resourceMap.getString("jLabel10.text", new Object[0]));
        this.jLabel10.setName("jLabel10");
        this.jLabel11.setText(resourceMap.getString("jLabel11.text", new Object[0]));
        this.jLabel11.setName("jLabel11");
        this.jLabel12.setText(resourceMap.getString("jLabel12.text", new Object[0]));
        this.jLabel12.setName("jLabel12");
        this.jButtonDATtoDAT.setText(resourceMap.getString("jButtonDATtoDAT.text", new Object[0]));
        this.jButtonDATtoDAT.setName("jButtonDATtoDAT");
        this.jButtonDATtoDAT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelCalculator.this.jButtonDATtoDATActionPerformed(evt);
            }
        });
        this.jSeparator2.setName("jSeparator2");
        this.jLabel13.setText(resourceMap.getString("jLabel13.text", new Object[0]));
        this.jLabel13.setName("jLabel13");
        this.jLabel14.setText(resourceMap.getString("jLabel14.text", new Object[0]));
        this.jLabel14.setName("jLabel14");
        this.jLabel15.setText(resourceMap.getString("jLabel15.text", new Object[0]));
        this.jLabel15.setName("jLabel15");
        this.jTextFieldSwissLon.setText(resourceMap.getString("jTextFieldSwissLon.text", new Object[0]));
        this.jTextFieldSwissLon.setToolTipText(resourceMap.getString("jTextFieldUTMLat.toolTipText", new Object[0]));
        this.jTextFieldSwissLon.setName("jTextFieldSwissLon");
        this.jTextFieldSwissLat.setText(resourceMap.getString("jTextFieldSwissLat.text", new Object[0]));
        this.jTextFieldSwissLat.setToolTipText(resourceMap.getString("jTextFieldUTMLat.toolTipText", new Object[0]));
        this.jTextFieldSwissLat.setName("jTextFieldSwissLat");
        this.jTextFieldSwissNorth.setText(resourceMap.getString("jTextFieldSwissNorth.text", new Object[0]));
        this.jTextFieldSwissNorth.setName("jTextFieldSwissNorth");
        this.jTextFieldSwissEst.setText(resourceMap.getString("jTextFieldSwissEst.text", new Object[0]));
        this.jTextFieldSwissEst.setName("jTextFieldSwissEst");
        this.jButtonSwissLLtoGrid.setText(resourceMap.getString("jButtonSwissLLtoGrid.text", new Object[0]));
        this.jButtonSwissLLtoGrid.setName("jButtonSwissLLtoGrid");
        this.jButtonSwissLLtoGrid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelCalculator.this.jButtonSwissLLtoGridActionPerformed(evt);
            }
        });
        this.jButtonSwissGridtoLL.setText(resourceMap.getString("jButtonSwissGridtoLL.text", new Object[0]));
        this.jButtonSwissGridtoLL.setName("jButtonSwissGridtoLL");
        this.jButtonSwissGridtoLL.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelCalculator.this.jButtonSwissGridtoLLActionPerformed(evt);
            }
        });
        this.jLabel16.setText(resourceMap.getString("jLabel16.text", new Object[0]));
        this.jLabel16.setName("jLabel16");
        this.jLabel17.setText(resourceMap.getString("jLabel17.text", new Object[0]));
        this.jLabel17.setName("jLabel17");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING, -1, 992, Short.MAX_VALUE).addComponent(this.jLabel6).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jComboBoxORI, 0, 491, Short.MAX_VALUE).addGap(18, 18, 18)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel7).addGap(388, 388, 388))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8).addComponent(this.jComboBoxDest, 0, 413, Short.MAX_VALUE)).addGap(70, 70, 70)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.jComboBoxDATUMup, 0, 712, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5).addComponent(this.jLabel4)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jComboBoxNorth, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jComboBoxGrid, -2, -1, -2)).addComponent(this.jTextFieldUTME).addComponent(this.jTextFieldUTMN, -1, 261, Short.MAX_VALUE)).addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonUTMtoLL).addGap(46, 46, 46).addComponent(this.jLabel2)).addGroup(layout.createSequentialGroup().addComponent(this.jButtonLLtoUTM).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel3))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldUTMLat, -1, 388, Short.MAX_VALUE).addComponent(this.jTextFieldUTMLon, -1, 388, Short.MAX_VALUE)))).addGap(64, 64, 64))).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(109, 109, 109).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldMolOrLon, -2, 219, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldMolOrLat, -2, 219, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 36, Short.MAX_VALUE).addComponent(this.jButtonDATtoDAT).addGap(54, 54, 54).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel10).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldMorDesLat, -2, 219, -2).addComponent(this.jTextFieldMolDesLon, -2, 219, -2)).addGap(185, 185, 185)).addGroup(layout.createSequentialGroup().addComponent(this.jSeparator2, -1, 940, Short.MAX_VALUE).addGap(76, 76, 76)).addGroup(layout.createSequentialGroup().addGap(108, 108, 108).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldSwissLon, -2, 219, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldSwissLat, -2, 219, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGap(57, 57, 57).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonSwissLLtoGrid).addComponent(this.jButtonSwissGridtoLL)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel16).addComponent(this.jLabel17)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldSwissNorth, -2, 219, -2).addComponent(this.jTextFieldSwissEst, -2, 219, -2)).addGap(184, 184, 184)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel13).addContainerGap(787, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBoxDATUMup, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldUTMN, -2, -1, -2).addComponent(this.jButtonUTMtoLL).addComponent(this.jLabel4).addComponent(this.jTextFieldUTMLat, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldUTME, -2, -1, -2).addComponent(this.jButtonLLtoUTM).addComponent(this.jLabel5).addComponent(this.jTextFieldUTMLon, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxNorth, -2, -1, -2).addComponent(this.jComboBoxGrid, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel6).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxORI, -2, -1, -2).addComponent(this.jComboBoxDest, -2, -1, -2)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldMolOrLat, -2, -1, -2).addComponent(this.jTextFieldMorDesLat, -2, -1, -2).addComponent(this.jLabel9).addComponent(this.jLabel10)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldMolOrLon, -2, -1, -2).addComponent(this.jTextFieldMolDesLon, -2, -1, -2).addComponent(this.jLabel11).addComponent(this.jLabel12))).addGroup(layout.createSequentialGroup().addGap(28, 28, 28).addComponent(this.jButtonDATtoDAT))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator2, -2, 10, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel15).addComponent(this.jTextFieldSwissLat, -2, -1, -2).addComponent(this.jTextFieldSwissNorth, -2, -1, -2).addComponent(this.jButtonSwissLLtoGrid)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldSwissLon, -2, -1, -2).addComponent(this.jLabel14).addComponent(this.jTextFieldSwissEst, -2, -1, -2).addComponent(this.jButtonSwissGridtoLL).addComponent(this.jLabel17))).addGroup(layout.createSequentialGroup().addGap(37, 37, 37).addComponent(this.jLabel16))).addContainerGap(82, Short.MAX_VALUE)));
    }

    private void jButtonUTMtoLLActionPerformed(ActionEvent evt) {
        boolean err = false;
        double xEst = 0.0;
        double yNort = 0.0;
        String mensaje = "";
        if (this.jComboBoxDATUMup.getSelectedIndex() == 0) {
            err = true;
            mensaje = mensaje + this.resourceMap.getString("err_no_datum2", new Object[0]);
        }
        if (this.jComboBoxGrid.getSelectedIndex() == 0) {
            err = true;
            mensaje = mensaje + this.resourceMap.getString("err_no_zona", new Object[0]);
        }
        try {
            xEst = Double.parseDouble(this.jTextFieldUTME.getText());
            yNort = Double.parseDouble(this.jTextFieldUTMN.getText());
        }
        catch (Exception e) {
            err = true;
            mensaje = mensaje + this.resourceMap.getString("err_coord_mal", new Object[0]);
        }
        if (err) {
            JOptionPane.showMessageDialog(this, mensaje, "Warning", 2);
        } else {
            boolean north = this.jComboBoxNorth.getSelectedIndex() == 0;
            Ellipsoid ellips = Ellipsoid.getEllipsoid(this.datums[this.jComboBoxDATUMup.getSelectedIndex()].ellipsoid);
            ParametrosProyeccion params = new ParametrosProyeccion();
            Object[] o = new Object[]{new Double(ellips.EquatorialRadius), new Double(1.0 / ellips.invFlatt), new Integer((String)this.jComboBoxGrid.getSelectedItem()), new Boolean(north)};
            params.param = o;
            ProjectionImpl p = ProjectionAdmin.dameProjectionImpl(2, params);
            LatLonPointImpl llp = p.projToLatLon(xEst, yNort);
            this.jTextFieldUTMLat.setText("" + llp.getLatitude());
            this.jTextFieldUTMLon.setText("" + llp.getLongitude());
        }
    }

    private void jButtonLLtoUTMActionPerformed(ActionEvent evt) {
        boolean err = false;
        double xLon = 0.0;
        double yLat = 0.0;
        String mensaje = "";
        try {
            xLon = CoordUtil.leeCoordenada(this.jTextFieldUTMLon.getText());
            yLat = CoordUtil.leeCoordenada(this.jTextFieldUTMLat.getText());
        }
        catch (Exception e) {
            err = true;
            mensaje = mensaje + this.resourceMap.getString("err_coord_mal", new Object[0]);
        }
        if (Math.abs(yLat) > 90.0 || Math.abs(xLon) > 180.0) {
            err = true;
            mensaje = mensaje + this.resourceMap.getString("msg_coord_incon_grad", new Object[0]);
        }
        if (this.jComboBoxDATUMup.getSelectedIndex() == 0) {
            err = true;
            mensaje = mensaje + this.resourceMap.getString("err_no_datum2", new Object[0]);
        }
        if (err) {
            JOptionPane.showMessageDialog(this, mensaje, "Warning", 2);
        } else {
            Ellipsoid ellips = Ellipsoid.getEllipsoid(this.datums[this.jComboBoxDATUMup.getSelectedIndex()].ellipsoid);
            ParametrosProyeccion params = new ParametrosProyeccion();
            int zona = 1;
            zona = this.jComboBoxGrid.getSelectedIndex() == 0 ? new Integer(UtmProjection.longitudeZone(xLon)).intValue() : this.jComboBoxGrid.getSelectedIndex();
            Object[] o = new Object[]{new Double(ellips.EquatorialRadius), new Double(1.0 / ellips.invFlatt), zona, new Boolean(yLat > 0.0)};
            params.param = o;
            ProjectionImpl p = ProjectionAdmin.dameProjectionImpl(2, params);
            ProjectionPoint llp = p.latLonToProj(new LatLonPointImpl(yLat, xLon));
            this.jTextFieldUTME.setText("" + llp.getX());
            this.jTextFieldUTMN.setText("" + llp.getY());
            if (yLat > 0.0) {
                this.jComboBoxNorth.setSelectedIndex(0);
            } else {
                this.jComboBoxNorth.setSelectedIndex(1);
            }
            this.jComboBoxGrid.setSelectedIndex(zona);
        }
    }

    private void jButtonDATtoDATActionPerformed(ActionEvent evt) {
        boolean err = false;
        double xLon = 0.0;
        double yLat = 0.0;
        String mensaje = "";
        try {
            xLon = CoordUtil.leeCoordenada(this.jTextFieldMolOrLon.getText());
            yLat = CoordUtil.leeCoordenada(this.jTextFieldMolOrLat.getText());
        }
        catch (Exception e) {
            err = true;
            mensaje = mensaje + this.resourceMap.getString("err_coord_mal", new Object[0]);
        }
        if (Math.abs(yLat) > 90.0 || Math.abs(xLon) > 180.0) {
            err = true;
            mensaje = mensaje + this.resourceMap.getString("msg_coord_incon_grad", new Object[0]);
        }
        if (this.jComboBoxORI.getSelectedIndex() == 0) {
            err = true;
            mensaje = mensaje + this.resourceMap.getString("err_no_datum_ori", new Object[0]);
        }
        if (this.jComboBoxDest.getSelectedIndex() == 0) {
            err = true;
            mensaje = mensaje + this.resourceMap.getString("err_no_datum_dest", new Object[0]);
        }
        if (err) {
            JOptionPane.showMessageDialog(this, mensaje, "Warning", 2);
        } else {
            int dat = this.jComboBoxORI.getSelectedIndex();
            LatLonPoint gp = DatumtoWGS84.transform(new LatLonPointImpl(yLat, xLon, 0.0), dat);
            this.jTextFieldMorDesLat.setText("" + gp.getLatitude());
            this.jTextFieldMolDesLon.setText("" + gp.getLongitude());
        }
    }

    private void jButtonSwissLLtoGridActionPerformed(ActionEvent evt) {
        boolean err = false;
        double xLon = 0.0;
        double yLat = 0.0;
        String mensaje = "";
        try {
            xLon = CoordUtil.leeCoordenada(this.jTextFieldSwissLon.getText());
            yLat = CoordUtil.leeCoordenada(this.jTextFieldSwissLat.getText());
        }
        catch (Exception e) {
            err = true;
            mensaje = mensaje + this.resourceMap.getString("err_coord_mal", new Object[0]);
        }
        if (Math.abs(yLat) > 90.0 || Math.abs(xLon) > 180.0) {
            err = true;
            mensaje = mensaje + this.resourceMap.getString("msg_coord_incon_grad", new Object[0]);
        }
        if (err) {
            JOptionPane.showMessageDialog(this, mensaje, "Warning", 2);
        } else {
            double[] res = SwissGrid.WGS84toLV03(yLat, xLon);
            this.jTextFieldSwissEst.setText("" + res[1]);
            this.jTextFieldSwissNorth.setText("" + res[0]);
        }
    }

    private void jButtonSwissGridtoLLActionPerformed(ActionEvent evt) {
        boolean err = false;
        double xEst = 0.0;
        double yNor = 0.0;
        String mensaje = "";
        try {
            xEst = Double.parseDouble(this.jTextFieldSwissEst.getText());
            yNor = Double.parseDouble(this.jTextFieldSwissNorth.getText());
        }
        catch (Exception e) {
            err = true;
            mensaje = mensaje + this.resourceMap.getString("err_coord_mal", new Object[0]);
        }
        if (err) {
            JOptionPane.showMessageDialog(this, mensaje, "Warning", 2);
        } else {
            double[] res = SwissGrid.LV03toWGS84(xEst, yNor);
            this.jTextFieldSwissLon.setText("" + res[1]);
            this.jTextFieldSwissLat.setText("" + res[0]);
        }
    }
}

