/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import oruxmapsdesktop.GeotiffInfo;
import oruxmapsdesktop.OruxMapsCreatorTask;
import oruxmapsdesktop.OruxMapsDesktopApp;
import oruxmapsdesktop.ParamManager;
import oruxmapsdesktop.calculadora.CalibradorMapa;
import oruxmapsdesktop.calculadora.DatumAdmin;
import oruxmapsdesktop.calculadora.DatumData;
import oruxmapsdesktop.calculadora.MapaOruxMaps;
import oruxmapsdesktop.calculadora.PuntoCalibracionMapa;
import oruxmapsdesktop.geoloc.ProjectionAdmin;
import oruxmapsdesktop.utilidades.CoordUtil;
import oruxmapsdesktop.utilidades.FileUtils;
import oruxmapsdesktop.utilidades.GeoTiffReader;
import oruxmapsdesktop.utilidades.ImageUtils;
import oruxmapsdesktop.utilidades.KapReader;
import oruxmapsdesktop.utilidades.OkmReader;
import oruxmapsdesktop.utilidades.OziReader;
import oruxmapsdesktop.utilidades.StringUtil;
import oruxmapsdesktop.utilidades.TfwReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPanelConvertor
extends JPanel {
    private ResourceMap resourceMap;
    private KeyAdapter intVer = new KeyAdapter(){

        public void keyTyped(KeyEvent e) {
            char caracter = e.getKeyChar();
            if ((caracter < '0' || caracter > '9') && caracter != '\b') {
                e.consume();
            }
        }
    };
    private boolean skipParametros = false;
    private String lambertParams = "";
    private String[] datumsStrings = null;
    private String[] projectionsStrings = null;
    private DatumData[] datums = null;
    private MapaOruxMaps mc;
    private File dirActual = null;
    private File dirActualFinal = null;
    private ButtonGroup buttonGroup2;
    private ButtonGroup buttonGroup3;
    private JButton jButton1;
    private JButton jButton4;
    private JButton jButtonFicheroCal;
    private JButton jButtonFicheroImg;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBoxSoloOtrk2;
    private JCheckBox jCheckBoxSqlite;
    private JComboBox jComboBoxDatum;
    private JComboBox jComboBoxNorth0;
    private JComboBox jComboBoxNorth1;
    private JComboBox jComboBoxNorth2;
    private JComboBox jComboBoxNorth3;
    private JComboBox jComboBoxProjection;
    private JComboBox jComboBoxQuality;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabelIcon;
    private JLabel jLabelLatitud;
    private JLabel jLabelLongitud;
    private JLabel jLabelX;
    private JLabel jLabelY;
    private JPanel jPanel1;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton3;
    private JRadioButton jRadioButton4;
    private JRadioButton jRadioButton5;
    private JRadioButton jRadioButtonGeo;
    private JRadioButton jRadioButtonGrid;
    private JRadioButton jRadioButtonJpg;
    private JTextField jTextFieldDirectorioDest;
    private JTextField jTextFieldFicheroCal;
    private JTextField jTextFieldFicheroImg;
    private JTextField jTextFieldLat0;
    private JTextField jTextFieldLat1;
    private JTextField jTextFieldLat2;
    private JTextField jTextFieldLat3;
    private JTextField jTextFieldLon0;
    private JTextField jTextFieldLon1;
    private JTextField jTextFieldLon2;
    private JTextField jTextFieldLon3;
    private JTextField jTextFieldNombreMapa;
    private JTextField jTextFieldPointX0;
    private JTextField jTextFieldPointX1;
    private JTextField jTextFieldPointX2;
    private JTextField jTextFieldPointX3;
    private JTextField jTextFieldPointY0;
    private JTextField jTextFieldPointY1;
    private JTextField jTextFieldPointY2;
    private JTextField jTextFieldPointY3;

    public JPanelConvertor() {
        this.initComponents();
        this.initComponents2();
    }

    private void displayMsg(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Warning", 2);
    }

    private void initComponents2() {
        int i;
        this.resourceMap = Application.getInstance(OruxMapsDesktopApp.class).getContext().getResourceMap(JPanelConvertor.class);
        String filename = this.resourceMap.getResourcesDir() + "logoorux48.png";
        URL url = this.resourceMap.getClassLoader().getResource(filename);
        this.jLabelIcon.setIcon(new ImageIcon(url));
        this.datums = DatumAdmin.dameDatums();
        if (this.datums != null) {
            this.datumsStrings = new String[this.datums.length];
            try {
                for (i = 0; i < this.datums.length; ++i) {
                    this.datumsStrings[i] = this.datums[i].datum + ": " + this.datums[i].region;
                }
            }
            catch (Exception e) {}
        } else {
            this.datumsStrings = new String[1];
            this.datumsStrings[0] = "";
        }
        this.projectionsStrings = new String[ProjectionAdmin.PROJECTIONS_TITLE.length];
        for (i = 0; i < this.projectionsStrings.length; ++i) {
            this.projectionsStrings[i] = ProjectionAdmin.PROJECTIONS_TITLE[i];
        }
        this.projectionsStrings[0] = this.resourceMap.getString("proyeccion", new Object[0]);
        this.datumsStrings[0] = this.resourceMap.getString("datum", new Object[0]);
        this.jComboBoxDatum.setModel(new DefaultComboBoxModel<String>(this.datumsStrings));
        this.jComboBoxProjection.setModel(new DefaultComboBoxModel<String>(this.projectionsStrings));
    }

    @Action
    public Task creaOruxMap() {
        if (this.checkComponentes()) {
            try {
                this.generaMapCalibrator();
            }
            catch (Exception e) {
                this.displayMsg(this.resourceMap.getString("msg_error_crea_otrk", new Object[0]));
                return null;
            }
            String tipo = !this.jRadioButtonJpg.isSelected() ? "JPEG" : "PNG";
            float calidad = (float)(100 - this.jComboBoxQuality.getSelectedIndex() * 5) / 100.0f;
            this.jButton1.setEnabled(false);
            if (this.jCheckBoxSqlite.isSelected()) {
                return new OruxMapsCreatorTask.OruxMapsCreatorSqliteTask(Application.getInstance(OruxMapsDesktopApp.class), this.mc, tipo, calidad, this.jCheckBoxSoloOtrk2.isSelected()){

                    protected void succeeded(Object result) {
                        JPanelConvertor.this.notifyEndConversion((Integer)result);
                    }
                };
            }
            return new OruxMapsCreatorTask(Application.getInstance(OruxMapsDesktopApp.class), this.mc, tipo, calidad, this.jCheckBoxSoloOtrk2.isSelected()){

                protected void succeeded(Object result) {
                    JPanelConvertor.this.notifyEndConversion((Integer)result);
                }
            };
        }
        return null;
    }

    private void notifyEndConversion(int result) {
        switch (result) {
            case 0: {
                this.displayMsg(this.resourceMap.getString("msg_ok_crear_files", new Object[0]));
                this.jTextFieldFicheroImg.setText("");
                this.jTextFieldFicheroCal.setText("");
                this.jTextFieldNombreMapa.setText("");
                this.resetCoordenadas();
                break;
            }
            case 1: {
                this.displayMsg(this.resourceMap.getString("msg_error_leer_img", new Object[0]));
                break;
            }
            case 2: {
                this.displayMsg(this.resourceMap.getString("msg_error_crear_dir", new Object[0]));
                break;
            }
            case 3: {
                this.displayMsg(this.resourceMap.getString("msg_error_crea_img", new Object[0]));
                break;
            }
            case 4: {
                this.displayMsg(this.resourceMap.getString("msg_error_crea_otrk", new Object[0]));
                break;
            }
            case 5: {
                this.displayMsg(this.resourceMap.getString("msg_error_dir_existe", new Object[0]));
                break;
            }
            case 44: {
                this.displayMsg(this.resourceMap.getString("msg_error_compresion", new Object[0]));
                break;
            }
            case 333: {
                this.displayMsg(this.resourceMap.getString("outofmemory", new Object[0]));
            }
        }
        this.mc = null;
        this.jButton1.setEnabled(true);
    }

    private void generaMapCalibrator() throws Exception {
        int i;
        if (this.mc == null) {
            this.mc = new MapaOruxMaps();
        }
        this.mc.datum = this.jComboBoxDatum.getSelectedIndex();
        this.mc.proyeccion = this.jComboBoxProjection.getSelectedIndex();
        this.mc.proyeccionData = this.lambertParams;
        this.mc.nombreMapa = this.jTextFieldNombreMapa.getText().trim();
        this.mc.nombreMapa = StringUtil.normalizaCadena(this.mc.nombreMapa);
        this.mc.dirImg = this.jTextFieldFicheroImg.getText().trim();
        this.mc.dirDest = this.jTextFieldDirectorioDest.getText().trim();
        this.mc.file_ext = ".omc2";
        ImageUtils.leeImagenDim(this.mc);
        if (this.mc.altoImagen + this.mc.anchoImagen <= 0) {
            this.displayMsg(this.resourceMap.getString("msg_no_file2", new Object[0]));
        }
        ArrayList<PuntoCalibracionMapa> p = this.leePuntosCalibracion(this.jRadioButtonGrid.isSelected());
        this.mc.puntosCalUser.clear();
        for (i = 0; i < p.size(); ++i) {
            this.mc.puntosCalUser.add(p.get(i));
        }
        OziReader.recolocaPuntos(this.mc.puntosCalUser);
        if (CalibradorMapa.estaCalibrado(this.mc, this.mc.puntosCalUser)) {
            for (i = 0; i < 4; ++i) {
                this.mc.puntosCalibracionFinales[i] = this.mc.puntosCalUser.get(i);
            }
            this.mc.nivelZoom = MapaOruxMaps.nivelMejor(this.mc, this.mc.puntosCalibracionFinales);
        } else if (this.jRadioButtonGrid.isSelected()) {
            CalibradorMapa.calibraWGS84Grid(this.mc);
        } else {
            CalibradorMapa.calibraWGS84Geo(this.mc);
        }
        if (this.jCheckBox1.isSelected()) {
            this.mc.capas[1] = this.jRadioButton2.isSelected();
            this.mc.capas[2] = this.jRadioButton3.isSelected();
            this.mc.capas[3] = this.jRadioButton4.isSelected();
            this.mc.capas[4] = this.jRadioButton5.isSelected();
        }
        for (int k = 1; k <= 4; ++k) {
            int n = k;
            this.mc.capas[n] = this.mc.capas[n] & this.mc.nivelZoom - k >= 0;
        }
    }

    private boolean checkComponentes() {
        File dir;
        boolean res = true;
        String mensaje = "";
        if (this.jComboBoxDatum.getSelectedIndex() == 0) {
            mensaje = mensaje + this.resourceMap.getString("err_no_datum", new Object[0]);
            res = false;
        }
        if (this.jComboBoxProjection.getSelectedIndex() == 0) {
            mensaje = mensaje + this.resourceMap.getString("err_no_projection", new Object[0]);
            res = false;
        }
        if (!new File(this.jTextFieldFicheroImg.getText()).exists() || new File(this.jTextFieldFicheroImg.getText()).isDirectory()) {
            mensaje = mensaje + this.resourceMap.getString("msg_no_file2", new Object[0]);
            res = false;
        }
        if (this.leePuntosCalibracion(this.jRadioButtonGrid.isSelected()).size() < 2) {
            mensaje = mensaje + this.resourceMap.getString("msg_faltan_coord", new Object[0]);
            res = false;
        }
        if (this.jTextFieldNombreMapa.getText().equals("")) {
            mensaje = mensaje + this.resourceMap.getString("msg_falta_nombre", new Object[0]);
            res = false;
        }
        if (!new File(this.jTextFieldDirectorioDest.getText()).isDirectory()) {
            mensaje = mensaje + this.resourceMap.getString("msg_falta_dir_dest", new Object[0]);
            res = false;
        }
        if ((dir = new File(this.jTextFieldDirectorioDest.getText() + File.separator + this.jTextFieldNombreMapa.getText())) != null && dir.isDirectory() && res) {
            Object[] options = new Object[]{this.resourceMap.getString("msg_si", new Object[0]), this.resourceMap.getString("msg_no", new Object[0])};
            int res2 = JOptionPane.showOptionDialog(this, this.resourceMap.getString("msg_dir_existe", new Object[0]), this.resourceMap.getString("msg_alerta", new Object[0]), -1, 2, null, options, options[0]);
            if (res2 == 1 || res2 == -1) {
                res = false;
                mensaje = mensaje + this.resourceMap.getString("msg_falta_dir_dest", new Object[0]);
            } else {
                FileUtils.deleteDir(dir);
            }
        }
        if (!res) {
            this.displayMsg(mensaje);
        }
        return res;
    }

    private PuntoCalibracionMapa leeCoord(int i, boolean geo, JTextField jtfx, JTextField jtfy, JTextField jtfLat, JTextField jtfLon, JComboBox jcb) {
        PuntoCalibracionMapa pt = null;
        try {
            if (jtfy.getText().length() + jtfx.getText().length() + jtfLat.getText().length() + jtfLon.getText().length() > 0) {
                pt = new PuntoCalibracionMapa();
                pt.y = Integer.parseInt(jtfy.getText());
                pt.x = Integer.parseInt(jtfx.getText());
                if (geo) {
                    pt.yLat = CoordUtil.leeCoordenada(jtfLat.getText());
                    pt.xLon = CoordUtil.leeCoordenada(jtfLon.getText());
                    if (Math.abs(pt.yLat) > 90.0 || Math.abs(pt.xLon) > 180.0) {
                        throw new Exception();
                    }
                } else {
                    pt.yNorth = Double.parseDouble(jtfLat.getText());
                    pt.xEast = Double.parseDouble(jtfLon.getText());
                    pt.northing = jcb.getSelectedIndex() == 0;
                }
            }
        }
        catch (Exception e) {
            pt = null;
            this.displayMsg(" P" + i + ": " + this.resourceMap.getString("err_pars", new Object[0]));
        }
        return pt;
    }

    private ArrayList<PuntoCalibracionMapa> leePuntosCalibracion(boolean grid) {
        ArrayList<PuntoCalibracionMapa> res = new ArrayList<PuntoCalibracionMapa>();
        PuntoCalibracionMapa pt = this.leeCoord(1, !grid, this.jTextFieldPointX0, this.jTextFieldPointY0, this.jTextFieldLat0, this.jTextFieldLon0, this.jComboBoxNorth0);
        if (pt != null) {
            res.add(pt);
        }
        if ((pt = this.leeCoord(2, !grid, this.jTextFieldPointX1, this.jTextFieldPointY1, this.jTextFieldLat1, this.jTextFieldLon1, this.jComboBoxNorth1)) != null) {
            res.add(pt);
        }
        if ((pt = this.leeCoord(3, !grid, this.jTextFieldPointX2, this.jTextFieldPointY2, this.jTextFieldLat2, this.jTextFieldLon2, this.jComboBoxNorth2)) != null) {
            res.add(pt);
        }
        if ((pt = this.leeCoord(4, !grid, this.jTextFieldPointX3, this.jTextFieldPointY3, this.jTextFieldLat3, this.jTextFieldLon3, this.jComboBoxNorth3)) != null) {
            res.add(pt);
        }
        return res;
    }

    @Action
    public void buscaFicheroCal() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setSelectedFile(new File(this.dirActual + File.separator + "."));
        fileChooser.addChoosableFileFilter(new FileUtils.MyFilterMap());
        int ii = fileChooser.showOpenDialog(this);
        if (ii == 0) {
            File map = fileChooser.getSelectedFile();
            this.dirActual = new File(map.getParent());
            this.mc = null;
            this.resetCoordenadas();
            this.leeFicheroCalibracion(map);
        }
    }

    @Action
    public void buscaFicheroImg() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setSelectedFile(new File(this.dirActual + File.separator + "."));
        fileChooser.addChoosableFileFilter(new FileUtils.MyFilterImage());
        int i = fileChooser.showOpenDialog(this);
        if (i == 0) {
            File image = fileChooser.getSelectedFile();
            this.dirActual = new File(image.getParent());
            this.jTextFieldFicheroImg.setText(image.toString());
        }
    }

    @Action
    public void buscaDirectorioDest() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setSelectedFile(new File(this.dirActualFinal + File.separator + "."));
        fileChooser.setFileSelectionMode(1);
        fileChooser.setAcceptAllFileFilterUsed(false);
        int i = fileChooser.showOpenDialog(this);
        if (i == 0) {
            File dir;
            this.dirActualFinal = dir = fileChooser.getSelectedFile();
            this.jTextFieldDirectorioDest.setText(dir.toString());
        }
    }

    private void resetCoordenadas() {
        this.jTextFieldLat0.setText("");
        this.jTextFieldLon0.setText("");
        this.jTextFieldPointX0.setText("");
        this.jTextFieldPointY0.setText("");
        this.jTextFieldLat1.setText("");
        this.jTextFieldLon1.setText("");
        this.jTextFieldPointX1.setText("");
        this.jTextFieldPointY1.setText("");
        this.jTextFieldLat2.setText("");
        this.jTextFieldLon2.setText("");
        this.jTextFieldPointX2.setText("");
        this.jTextFieldPointY2.setText("");
        this.jTextFieldLat3.setText("");
        this.jTextFieldLon3.setText("");
        this.jTextFieldPointX3.setText("");
        this.jTextFieldPointY3.setText("");
    }

    private void leeFicheroCalibracion(File map) {
        try {
            int[] dim;
            String mapa = this.jTextFieldFicheroImg.getText();
            if (map.getName().toLowerCase().endsWith("tfwx") || map.getName().toLowerCase().endsWith("tfw") || map.getName().toLowerCase().endsWith("jpw") || map.getName().toLowerCase().endsWith("pgw")) {
                if (!new File(mapa).exists()) {
                    int i = map.toString().toLowerCase().endsWith("tfwx") ? 5 : 4;
                    mapa = FileUtils.buscaImagen(map.getParentFile(), map.getName().substring(0, map.getName().length() - i), FileUtils.imageType);
                    if (mapa != null) {
                        mapa = map.getParentFile().getAbsolutePath() + File.separator + mapa;
                        this.jTextFieldFicheroImg.setText(mapa);
                    }
                }
                if ((dim = ImageUtils.leeImagenDim(new File(this.jTextFieldFicheroImg.getText())))[0] == -1) {
                    throw new Exception("Image not found");
                }
                this.mc = TfwReader.lee(map, dim[0], dim[1]);
                this.mc.dirImg = this.jTextFieldFicheroImg.getText();
            } else if (map.getName().toLowerCase().endsWith("kap")) {
                if (!new File(mapa).exists() && (mapa = FileUtils.buscaImagen(map.getParentFile(), map.getName().substring(0, map.getName().length() - 4), FileUtils.imageType)) != null) {
                    mapa = map.getParentFile().getAbsolutePath() + File.separator + mapa;
                    this.jTextFieldFicheroImg.setText(mapa);
                }
                if ((dim = ImageUtils.leeImagenDim(new File(this.jTextFieldFicheroImg.getText())))[0] == -1) {
                    throw new Exception("Image not found");
                }
                this.mc = KapReader.lee(map, dim[0], dim[1]);
                this.mc.dirImg = this.jTextFieldFicheroImg.getText();
            } else if (map.getName().toLowerCase().endsWith("tif") || map.getName().toLowerCase().endsWith("tiff")) {
                this.mc = GeoTiffReader.lee(map);
                if (this.mc.datum + this.mc.proyeccion == 0) {
                    GeotiffInfo jd = new GeotiffInfo(null, true);
                    jd.setMensaje(this.resourceMap.getString("msg_geotff_datum_proj", new Object[0]) + "\n" + GeoTiffReader.result);
                    jd.setLocationRelativeTo(this);
                    jd.pack();
                    jd.setVisible(true);
                }
            } else {
                this.mc = map.getName().toLowerCase().endsWith("okm") ? OkmReader.lee(map) : OziReader.lee(map);
            }
        }
        catch (Exception e) {
            this.displayMsg(this.resourceMap.getString("msg_bad_ozi_file", new Object[0]) + e.getMessage());
            this.mc = null;
            return;
        }
        this.lambertParams = this.mc.proyeccionData;
        this.jTextFieldNombreMapa.setText(this.mc.nombreMapa);
        if (this.mc.dirImg == null) {
            this.mc.dirImg = "";
            this.displayMsg(this.resourceMap.getString("msg_no_file", new Object[0]));
        } else if (!new File(this.mc.dirImg).exists()) {
            int i = map.getName().lastIndexOf(".");
            String mapa = FileUtils.buscaImagen(map.getParentFile(), map.getName().substring(0, i), FileUtils.imageType);
            if (mapa != null) {
                this.mc.dirImg = map.getParentFile() + File.separator + mapa;
            } else {
                String path2 = this.dirActual + File.separator + this.mc.dirImg;
                if (new File(path2).exists()) {
                    this.mc.dirImg = path2;
                } else {
                    File f = new File(this.mc.dirImg);
                    String path3 = this.dirActual + File.separator + f.getName();
                    if (new File(path3).exists()) {
                        this.mc.dirImg = path3;
                    } else {
                        this.mc.dirImg = "";
                        this.displayMsg(this.resourceMap.getString("msg_no_file", new Object[0]));
                    }
                }
            }
        }
        this.jTextFieldFicheroImg.setText(this.mc.dirImg);
        this.jTextFieldFicheroCal.setText(map.toString());
        if (new File(this.mc.dirImg).exists()) {
            ImageUtils.leeImagenDim(this.mc);
        }
        if (CalibradorMapa.coodenadasEsquinasOk(this.mc, this.mc.puntosCalibracionB) && this.mc.proyeccion != 4) {
            this.jTextFieldLat0.setText("" + this.mc.puntosCalibracionB.get((int)0).yLat);
            this.jTextFieldLon0.setText("" + this.mc.puntosCalibracionB.get((int)0).xLon);
            this.jTextFieldLat1.setText("" + this.mc.puntosCalibracionB.get((int)1).yLat);
            this.jTextFieldLon1.setText("" + this.mc.puntosCalibracionB.get((int)1).xLon);
            this.jTextFieldLat2.setText("" + this.mc.puntosCalibracionB.get((int)2).yLat);
            this.jTextFieldLon2.setText("" + this.mc.puntosCalibracionB.get((int)2).xLon);
            this.jTextFieldLat3.setText("" + this.mc.puntosCalibracionB.get((int)3).yLat);
            this.jTextFieldLon3.setText("" + this.mc.puntosCalibracionB.get((int)3).xLon);
            this.jTextFieldPointX0.setText("" + this.mc.puntosCalibracionB.get((int)0).x);
            this.jTextFieldPointY0.setText("" + this.mc.puntosCalibracionB.get((int)0).y);
            this.jTextFieldPointX1.setText("" + this.mc.puntosCalibracionB.get((int)1).x);
            this.jTextFieldPointY1.setText("" + this.mc.puntosCalibracionB.get((int)1).y);
            this.jTextFieldPointX2.setText("" + this.mc.puntosCalibracionB.get((int)2).x);
            this.jTextFieldPointY2.setText("" + this.mc.puntosCalibracionB.get((int)2).y);
            this.jTextFieldPointX3.setText("" + this.mc.puntosCalibracionB.get((int)3).x);
            this.jTextFieldPointY3.setText("" + this.mc.puntosCalibracionB.get((int)3).y);
            this.jRadioButtonGrid.setSelected(false);
            this.jRadioButtonGeo.setSelected(true);
            this.toGrid(false);
        } else if (Double.isNaN(this.mc.puntosCalibracionA.get((int)0).xEast) && Double.isNaN(this.mc.puntosCalibracionA.get((int)0).yNorth)) {
            try {
                this.jTextFieldLat0.setText("" + this.mc.puntosCalibracionA.get((int)0).yLat);
                this.jTextFieldLon0.setText("" + this.mc.puntosCalibracionA.get((int)0).xLon);
                this.jTextFieldPointX0.setText("" + this.mc.puntosCalibracionA.get((int)0).x);
                this.jTextFieldPointY0.setText("" + this.mc.puntosCalibracionA.get((int)0).y);
                this.jTextFieldLat1.setText("" + this.mc.puntosCalibracionA.get((int)1).yLat);
                this.jTextFieldLon1.setText("" + this.mc.puntosCalibracionA.get((int)1).xLon);
                this.jTextFieldPointX1.setText("" + this.mc.puntosCalibracionA.get((int)1).x);
                this.jTextFieldPointY1.setText("" + this.mc.puntosCalibracionA.get((int)1).y);
                this.jTextFieldLat2.setText("" + this.mc.puntosCalibracionA.get((int)2).yLat);
                this.jTextFieldLon2.setText("" + this.mc.puntosCalibracionA.get((int)2).xLon);
                this.jTextFieldPointX2.setText("" + this.mc.puntosCalibracionA.get((int)2).x);
                this.jTextFieldPointY2.setText("" + this.mc.puntosCalibracionA.get((int)2).y);
                this.jTextFieldLat3.setText("" + this.mc.puntosCalibracionA.get((int)3).yLat);
                this.jTextFieldLon3.setText("" + this.mc.puntosCalibracionA.get((int)3).xLon);
                this.jTextFieldPointX3.setText("" + this.mc.puntosCalibracionA.get((int)3).x);
                this.jTextFieldPointY3.setText("" + this.mc.puntosCalibracionA.get((int)3).y);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.jRadioButtonGrid.setSelected(false);
            this.jRadioButtonGeo.setSelected(true);
            this.toGrid(false);
        } else {
            try {
                this.jTextFieldLat0.setText("" + this.mc.puntosCalibracionA.get((int)0).yNorth);
                this.jTextFieldLon0.setText("" + this.mc.puntosCalibracionA.get((int)0).xEast);
                this.jTextFieldPointX0.setText("" + this.mc.puntosCalibracionA.get((int)0).x);
                this.jTextFieldPointY0.setText("" + this.mc.puntosCalibracionA.get((int)0).y);
                this.jTextFieldLat1.setText("" + this.mc.puntosCalibracionA.get((int)1).yNorth);
                this.jTextFieldLon1.setText("" + this.mc.puntosCalibracionA.get((int)1).xEast);
                this.jTextFieldPointX1.setText("" + this.mc.puntosCalibracionA.get((int)1).x);
                this.jTextFieldPointY1.setText("" + this.mc.puntosCalibracionA.get((int)1).y);
                this.jTextFieldLat2.setText("" + this.mc.puntosCalibracionA.get((int)2).yNorth);
                this.jTextFieldLon2.setText("" + this.mc.puntosCalibracionA.get((int)2).xEast);
                this.jTextFieldPointX2.setText("" + this.mc.puntosCalibracionA.get((int)2).x);
                this.jTextFieldPointY2.setText("" + this.mc.puntosCalibracionA.get((int)2).y);
                this.jTextFieldLat3.setText("" + this.mc.puntosCalibracionA.get((int)3).yNorth);
                this.jTextFieldLon3.setText("" + this.mc.puntosCalibracionA.get((int)3).xEast);
                this.jTextFieldPointX3.setText("" + this.mc.puntosCalibracionA.get((int)3).x);
                this.jTextFieldPointY3.setText("" + this.mc.puntosCalibracionA.get((int)3).y);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.jRadioButtonGeo.setSelected(false);
            this.jRadioButtonGrid.setSelected(true);
            this.toGrid(true);
            try {
                this.jComboBoxNorth0.setSelectedIndex(this.mc.puntosCalibracionA.get((int)0).northing ? 0 : 1);
                this.jComboBoxNorth1.setSelectedIndex(this.mc.puntosCalibracionA.get((int)1).northing ? 0 : 1);
                this.jComboBoxNorth2.setSelectedIndex(this.mc.puntosCalibracionA.get((int)2).northing ? 0 : 1);
                this.jComboBoxNorth3.setSelectedIndex(this.mc.puntosCalibracionA.get((int)3).northing ? 0 : 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.jComboBoxDatum.setSelectedIndex(this.mc.datum);
        if (this.mc.datum == 0) {
            this.displayMsg(this.resourceMap.getString("msg_no_datum_conocido", new Object[0]));
        }
        this.skipParametros = true;
        this.jComboBoxProjection.setSelectedIndex(this.mc.proyeccion);
        if (this.mc.proyeccion == 0) {
            this.displayMsg(this.resourceMap.getString("msg_no_proyeccion_conocido", new Object[0]));
        }
    }

    private void initComponents() {
        this.buttonGroup2 = new ButtonGroup();
        this.buttonGroup3 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jButtonFicheroCal = new JButton();
        this.jButtonFicheroImg = new JButton();
        this.jTextFieldLon0 = new JTextField();
        this.jTextFieldLat0 = new JTextField();
        this.jTextFieldLon1 = new JTextField();
        this.jTextFieldLon2 = new JTextField();
        this.jTextFieldLon3 = new JTextField();
        this.jTextFieldLat1 = new JTextField();
        this.jTextFieldLat2 = new JTextField();
        this.jTextFieldLat3 = new JTextField();
        this.jLabel6 = new JLabel();
        this.jButton4 = new JButton();
        this.jTextFieldNombreMapa = new JTextField();
        this.jTextFieldDirectorioDest = new JTextField();
        this.jTextFieldFicheroCal = new JTextField();
        this.jCheckBoxSoloOtrk2 = new JCheckBox();
        this.jComboBoxDatum = new JComboBox();
        this.jComboBoxProjection = new JComboBox();
        this.jTextFieldFicheroImg = new JTextField();
        this.jLabelLongitud = new JLabel();
        this.jLabelLatitud = new JLabel();
        this.jRadioButtonGeo = new JRadioButton();
        this.jRadioButtonGrid = new JRadioButton();
        this.jComboBoxNorth0 = new JComboBox();
        this.jComboBoxNorth1 = new JComboBox();
        this.jComboBoxNorth2 = new JComboBox();
        this.jComboBoxNorth3 = new JComboBox();
        this.jTextFieldPointX3 = new JTextField();
        this.jTextFieldPointY3 = new JTextField();
        this.jTextFieldPointX2 = new JTextField();
        this.jTextFieldPointY2 = new JTextField();
        this.jLabelX = new JLabel();
        this.jLabelY = new JLabel();
        this.jLabelIcon = new JLabel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButtonJpg = new JRadioButton();
        this.jComboBoxQuality = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jTextFieldPointY1 = new JTextField();
        this.jTextFieldPointX1 = new JTextField();
        this.jTextFieldPointX0 = new JTextField();
        this.jTextFieldPointY0 = new JTextField();
        this.jCheckBoxSqlite = new JCheckBox();
        this.jCheckBox1 = new JCheckBox();
        this.jRadioButton2 = new JRadioButton();
        this.jRadioButton3 = new JRadioButton();
        this.jRadioButton4 = new JRadioButton();
        this.jRadioButton5 = new JRadioButton();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.setName("Form");
        this.setPreferredSize(new Dimension(930, 550));
        this.jPanel1.setName("jPanel1");
        ApplicationActionMap actionMap = Application.getInstance(OruxMapsDesktopApp.class).getContext().getActionMap(JPanelConvertor.class, this);
        this.jButton1.setAction(actionMap.get("creaOruxMap"));
        ResourceMap resourceMap = Application.getInstance(OruxMapsDesktopApp.class).getContext().getResourceMap(JPanelConvertor.class);
        this.jButton1.setText(resourceMap.getString("jButton1.text", new Object[0]));
        this.jButton1.setName("jButton1");
        this.jButtonFicheroCal.setAction(actionMap.get("buscaFicheroCal"));
        this.jButtonFicheroCal.setText(resourceMap.getString("jButtonFicheroCal.text", new Object[0]));
        this.jButtonFicheroCal.setName("jButtonFicheroCal");
        this.jButtonFicheroImg.setAction(actionMap.get("buscaFicheroImg"));
        this.jButtonFicheroImg.setText(resourceMap.getString("jButtonFicheroImg.text", new Object[0]));
        this.jButtonFicheroImg.setName("jButtonFicheroImg");
        this.jTextFieldLon0.setToolTipText(resourceMap.getString("jTextFieldLon0.toolTipText", new Object[0]));
        this.jTextFieldLon0.setName("jTextFieldLon0");
        this.jTextFieldLat0.setToolTipText(resourceMap.getString("jTextFieldLon0.toolTipText", new Object[0]));
        this.jTextFieldLat0.setName("jTextFieldLat0");
        this.jTextFieldLon1.setToolTipText(resourceMap.getString("jTextFieldLon0.toolTipText", new Object[0]));
        this.jTextFieldLon1.setName("jTextFieldLon1");
        this.jTextFieldLon2.setToolTipText(resourceMap.getString("jTextFieldLon0.toolTipText", new Object[0]));
        this.jTextFieldLon2.setName("jTextFieldLon2");
        this.jTextFieldLon3.setToolTipText(resourceMap.getString("jTextFieldLon0.toolTipText", new Object[0]));
        this.jTextFieldLon3.setName("jTextFieldLon3");
        this.jTextFieldLat1.setToolTipText(resourceMap.getString("jTextFieldLon0.toolTipText", new Object[0]));
        this.jTextFieldLat1.setName("jTextFieldLat1");
        this.jTextFieldLat2.setToolTipText(resourceMap.getString("jTextFieldLon0.toolTipText", new Object[0]));
        this.jTextFieldLat2.setName("jTextFieldLat2");
        this.jTextFieldLat3.setToolTipText(resourceMap.getString("jTextFieldLon0.toolTipText", new Object[0]));
        this.jTextFieldLat3.setName("jTextFieldLat3");
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText(resourceMap.getString("jLabel6.text", new Object[0]));
        this.jLabel6.setName("jLabel6");
        this.jButton4.setAction(actionMap.get("buscaDirectorioDest"));
        this.jButton4.setText(resourceMap.getString("jButton4.text", new Object[0]));
        this.jButton4.setName("jButton4");
        this.jTextFieldNombreMapa.setName("jTextFieldNombreMapa");
        this.jTextFieldDirectorioDest.setName("jTextFieldDirectorioDest");
        this.jTextFieldFicheroCal.setName("jTextFieldFicheroCal");
        this.jCheckBoxSoloOtrk2.setText(resourceMap.getString("jCheckBoxSoloOtrk2.text", new Object[0]));
        this.jCheckBoxSoloOtrk2.setName("jCheckBoxSoloOtrk2");
        this.jComboBoxDatum.setToolTipText(resourceMap.getString("jComboBoxDatum.toolTipText", new Object[0]));
        this.jComboBoxDatum.setAutoscrolls(true);
        this.jComboBoxDatum.setName("jComboBoxDatum");
        this.jComboBoxProjection.setToolTipText(resourceMap.getString("jComboBoxProjection.toolTipText", new Object[0]));
        this.jComboBoxProjection.setName("jComboBoxProjection");
        this.jComboBoxProjection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelConvertor.this.jComboBoxProjectionActionPerformed(evt);
            }
        });
        this.jTextFieldFicheroImg.setName("jTextFieldFicheroImg");
        this.jLabelLongitud.setText(resourceMap.getString("jLabelLongitud.text", new Object[0]));
        this.jLabelLongitud.setName("jLabelLongitud");
        this.jLabelLatitud.setText(resourceMap.getString("jLabelLatitud.text", new Object[0]));
        this.jLabelLatitud.setName("jLabelLatitud");
        this.buttonGroup2.add(this.jRadioButtonGeo);
        this.jRadioButtonGeo.setSelected(true);
        this.jRadioButtonGeo.setText(resourceMap.getString("jRadioButtonGeo.text", new Object[0]));
        this.jRadioButtonGeo.setName("jRadioButtonGeo");
        this.jRadioButtonGeo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelConvertor.this.jRadioButtonGeoActionPerformed(evt);
            }
        });
        this.buttonGroup2.add(this.jRadioButtonGrid);
        this.jRadioButtonGrid.setText(resourceMap.getString("jRadioButtonGrid.text", new Object[0]));
        this.jRadioButtonGrid.setName("jRadioButtonGrid");
        this.jRadioButtonGrid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelConvertor.this.jRadioButtonGridActionPerformed(evt);
            }
        });
        this.jComboBoxNorth0.setModel(new DefaultComboBoxModel<String>(new String[]{"N", "S"}));
        this.jComboBoxNorth0.setEnabled(false);
        this.jComboBoxNorth0.setName("jComboBoxNorth0");
        this.jComboBoxNorth1.setModel(new DefaultComboBoxModel<String>(new String[]{"N", "S"}));
        this.jComboBoxNorth1.setEnabled(false);
        this.jComboBoxNorth1.setName("jComboBoxNorth1");
        this.jComboBoxNorth2.setModel(new DefaultComboBoxModel<String>(new String[]{"N", "S"}));
        this.jComboBoxNorth2.setEnabled(false);
        this.jComboBoxNorth2.setName("jComboBoxNorth2");
        this.jComboBoxNorth3.setModel(new DefaultComboBoxModel<String>(new String[]{"N", "S"}));
        this.jComboBoxNorth3.setEnabled(false);
        this.jComboBoxNorth3.setName("jComboBoxNorth3");
        this.jTextFieldPointX3.addKeyListener(this.intVer);
        this.jTextFieldPointX3.setName("jTextFieldPointX3");
        this.jTextFieldPointY3.addKeyListener(this.intVer);
        this.jTextFieldPointY3.setName("jTextFieldPointY3");
        this.jTextFieldPointX2.addKeyListener(this.intVer);
        this.jTextFieldPointX2.setName("jTextFieldPointX2");
        this.jTextFieldPointY2.addKeyListener(this.intVer);
        this.jTextFieldPointY2.setName("jTextFieldPointY2");
        this.jLabelX.setText(resourceMap.getString("jLabelX.text", new Object[0]));
        this.jLabelX.setName("jLabelX");
        this.jLabelY.setText(resourceMap.getString("jLabelY.text", new Object[0]));
        this.jLabelY.setName("jLabelY");
        this.jLabelIcon.setName("jLabelIcon");
        this.buttonGroup3.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText(resourceMap.getString("jRadioButton1.text", new Object[0]));
        this.jRadioButton1.setName("jRadioButton1");
        this.buttonGroup3.add(this.jRadioButtonJpg);
        this.jRadioButtonJpg.setText(resourceMap.getString("jRadioButtonJpg.text", new Object[0]));
        this.jRadioButtonJpg.setName("jRadioButtonJpg");
        this.jComboBoxQuality.setModel(new DefaultComboBoxModel<String>(new String[]{"100%", "95%", "90%", "85%", "80%", "75%", "70%", "65%", "60%", "55%", "50%"}));
        this.jComboBoxQuality.setSelectedIndex(3);
        this.jComboBoxQuality.setName("jComboBoxQuality");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jTextFieldPointY1.addKeyListener(this.intVer);
        this.jTextFieldPointY1.setName("jTextFieldPointY1");
        this.jTextFieldPointX1.addKeyListener(this.intVer);
        this.jTextFieldPointX1.setName("jTextFieldPointX1");
        this.jTextFieldPointX0.addKeyListener(this.intVer);
        this.jTextFieldPointX0.setName("jTextFieldPointX0");
        this.jTextFieldPointY0.addKeyListener(this.intVer);
        this.jTextFieldPointY0.setName("jTextFieldPointY0");
        this.jCheckBoxSqlite.setSelected(true);
        this.jCheckBoxSqlite.setText(resourceMap.getString("jCheckBoxSqlite.text", new Object[0]));
        this.jCheckBoxSqlite.setName("jCheckBoxSqlite");
        this.jCheckBox1.setText(resourceMap.getString("jCheckBox1.text", new Object[0]));
        this.jCheckBox1.setName("jCheckBox1");
        this.jCheckBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelConvertor.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jRadioButton2.setText(resourceMap.getString("jRadioButton2.text", new Object[0]));
        this.jRadioButton2.setEnabled(false);
        this.jRadioButton2.setName("jRadioButton2");
        this.jRadioButton3.setText(resourceMap.getString("jRadioButton3.text", new Object[0]));
        this.jRadioButton3.setEnabled(false);
        this.jRadioButton3.setName("jRadioButton3");
        this.jRadioButton4.setText(resourceMap.getString("jRadioButton4.text", new Object[0]));
        this.jRadioButton4.setEnabled(false);
        this.jRadioButton4.setName("jRadioButton4");
        this.jRadioButton5.setText(resourceMap.getString("jRadioButton5.text", new Object[0]));
        this.jRadioButton5.setEnabled(false);
        this.jRadioButton5.setName("jRadioButton5");
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(70, 70, 70).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldPointX3).addComponent(this.jTextFieldPointX2).addComponent(this.jTextFieldPointX1).addComponent(this.jTextFieldPointX0, -1, 94, Short.MAX_VALUE)).addComponent(this.jLabelX, -1, 112, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabelY, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jTextFieldPointY3).addComponent(this.jTextFieldPointY2).addComponent(this.jTextFieldPointY1).addComponent(this.jTextFieldPointY0, -1, 103, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 76, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldLon3, -2, 183, -2).addComponent(this.jTextFieldLon2, -2, 183, -2).addComponent(this.jTextFieldLon0, -2, 183, -2).addComponent(this.jTextFieldLon1, -2, 183, -2).addComponent(this.jLabelLongitud)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldLat3, GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldLat2, GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldLat1, GroupLayout.Alignment.TRAILING).addComponent(this.jTextFieldLat0, GroupLayout.Alignment.TRAILING, -1, 203, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jRadioButtonGrid))).addComponent(this.jLabelLatitud))).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonGeo).addGap(286, 286, 286))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxNorth0, -2, 60, -2).addComponent(this.jComboBoxNorth1, -2, 60, -2).addComponent(this.jComboBoxNorth2, -2, 60, -2).addComponent(this.jComboBoxNorth3, -2, 60, -2)).addGap(55, 55, 55)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButton4, -1, 216, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel6, -1, 213, Short.MAX_VALUE).addGap(9, 9, 9))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxQuality, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1)).addComponent(this.jRadioButtonJpg)).addGap(125, 125, 125).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1, -2, 139, -2).addComponent(this.jCheckBoxSoloOtrk2, -1, 240, Short.MAX_VALUE).addComponent(this.jCheckBoxSqlite, -2, 137, -2))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTextFieldDirectorioDest, GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldNombreMapa, GroupLayout.Alignment.LEADING, -1, 537, Short.MAX_VALUE))))).addContainerGap()).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.jComboBoxDatum, -2, 405, -2).addGap(18, 18, 18).addComponent(this.jComboBoxProjection, 0, 274, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonFicheroCal, GroupLayout.Alignment.TRAILING, -1, 188, Short.MAX_VALUE).addComponent(this.jButtonFicheroImg, GroupLayout.Alignment.TRAILING, -1, 188, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldFicheroImg, -1, 503, Short.MAX_VALUE).addComponent(this.jTextFieldFicheroCal, -1, 503, Short.MAX_VALUE)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelIcon, -2, 123, -2)))).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBox1).addGap(53, 53, 53).addComponent(this.jRadioButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton5).addContainerGap(522, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelIcon, -2, 82, -2).addGroup(jPanel1Layout.createSequentialGroup().addGap(8, 8, 8).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonFicheroCal).addComponent(this.jTextFieldFicheroCal, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonFicheroImg).addComponent(this.jTextFieldFicheroImg, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxProjection, -2, -1, -2).addComponent(this.jComboBoxDatum, -2, -1, -2)))).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelY).addComponent(this.jLabelX)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldPointX0).addComponent(this.jTextFieldPointY0).addComponent(this.jLabel2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldPointY1).addComponent(this.jTextFieldPointX1).addComponent(this.jLabel3)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldPointX2).addComponent(this.jTextFieldPointY2).addComponent(this.jLabel4)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldPointX3).addComponent(this.jTextFieldPointY3).addComponent(this.jLabel5)).addGap(57, 57, 57)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jComboBoxNorth0, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jComboBoxNorth1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jComboBoxNorth2, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jComboBoxNorth3, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelLongitud).addComponent(this.jLabelLatitud)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldLat0, -2, -1, -2).addComponent(this.jTextFieldLon0, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldLat1, -2, -1, -2).addComponent(this.jTextFieldLon1, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldLat2, -2, -1, -2).addComponent(this.jTextFieldLon2, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldLat3, -2, -1, -2).addComponent(this.jTextFieldLon3, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonGeo).addComponent(this.jRadioButtonGrid)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.jTextFieldNombreMapa, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton4).addComponent(this.jTextFieldDirectorioDest, -2, -1, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton1).addComponent(this.jComboBoxQuality, -2, -1, -2).addComponent(this.jLabel1))).addGroup(jPanel1Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jButton1))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxSoloOtrk2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton2).addComponent(this.jRadioButton3).addComponent(this.jRadioButton4).addComponent(this.jRadioButton5).addComponent(this.jCheckBox1)).addComponent(this.jCheckBoxSqlite)).addGap(50, 50, 50)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(462, Short.MAX_VALUE).addComponent(this.jRadioButtonJpg).addGap(90, 90, 90)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 930, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 550, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)));
    }

    private void jRadioButtonGridActionPerformed(ActionEvent evt) {
        this.toGrid(true);
    }

    private void jRadioButtonGeoActionPerformed(ActionEvent evt) {
        this.toGrid(false);
    }

    private void jComboBoxProjectionActionPerformed(ActionEvent evt) {
        String pro = (String)this.jComboBoxProjection.getSelectedItem();
        if (pro.equalsIgnoreCase("MERCATOR") || pro.equalsIgnoreCase("SWISS GRID") || pro.equalsIgnoreCase("IRISH GRID") || pro.equalsIgnoreCase("LAMBERT CONFORMAL") || pro.equalsIgnoreCase("TRANSVERSE MERCATOR")) {
            this.jComboBoxNorth0.setEnabled(false);
            this.jComboBoxNorth3.setEnabled(false);
            this.jComboBoxNorth2.setEnabled(false);
            this.jComboBoxNorth1.setEnabled(false);
            this.jRadioButtonGrid.setEnabled(true);
        } else if (pro.equalsIgnoreCase("AMERICAN POLYCONIC") || pro.equalsIgnoreCase("EQUIRECTANGULAR") || pro.equalsIgnoreCase("FLAT EARTH") || pro.equalsIgnoreCase("LATITUDE/LONGITUDE")) {
            this.jRadioButtonGeo.setEnabled(true);
            this.jRadioButtonGeo.doClick();
            this.jRadioButtonGrid.setEnabled(false);
        } else if (pro.equalsIgnoreCase("UTM")) {
            this.jComboBoxNorth0.setEnabled(true);
            this.jComboBoxNorth3.setEnabled(true);
            this.jComboBoxNorth2.setEnabled(true);
            this.jComboBoxNorth1.setEnabled(true);
            this.jRadioButtonGrid.setEnabled(true);
        } else {
            if (this.jRadioButtonGrid.isSelected()) {
                this.jComboBoxNorth0.setEnabled(true);
                this.jComboBoxNorth3.setEnabled(true);
                this.jComboBoxNorth2.setEnabled(true);
                this.jComboBoxNorth1.setEnabled(true);
            }
            this.jRadioButtonGrid.setEnabled(true);
        }
        this.jComboBoxProjection.hidePopup();
        if (!this.skipParametros) {
            this.lambertParams = "";
            try {
                this.lambertParams = ParamManager.getParams(this, pro);
            }
            catch (Exception ex) {
                this.displayMsg(this.resourceMap.getString("wrong_val", new Object[0]));
            }
        }
        this.skipParametros = false;
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        boolean b = this.jCheckBox1.isSelected();
        this.jRadioButton2.setEnabled(b);
        this.jRadioButton3.setEnabled(b);
        this.jRadioButton4.setEnabled(b);
        this.jRadioButton5.setEnabled(b);
    }

    private void toGrid(boolean grid) {
        if (grid) {
            this.jLabelLongitud.setText(this.resourceMap.getString("eastern", new Object[0]));
            this.jLabelLatitud.setText(this.resourceMap.getString("northern", new Object[0]));
            if (!((String)this.jComboBoxProjection.getSelectedItem()).equalsIgnoreCase("SWISS GRID") && !((String)this.jComboBoxProjection.getSelectedItem()).equalsIgnoreCase("IRISH GRID")) {
                this.jComboBoxNorth0.setEnabled(true);
                this.jComboBoxNorth1.setEnabled(true);
                this.jComboBoxNorth2.setEnabled(true);
                this.jComboBoxNorth3.setEnabled(true);
            }
        } else {
            this.jLabelLongitud.setText(this.resourceMap.getString("longitud", new Object[0]));
            this.jLabelLatitud.setText(this.resourceMap.getString("latitud", new Object[0]));
            this.jComboBoxNorth0.setEnabled(false);
            this.jComboBoxNorth1.setEnabled(false);
            this.jComboBoxNorth2.setEnabled(false);
            this.jComboBoxNorth3.setEnabled(false);
        }
    }
}

