/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import oruxmapsdesktop.OruxMapsDesktopApp;

public class JPanelDemapper
extends JPanel {
    String startdir;
    String patt;
    String newtext;
    String fileExt;
    String resultado;
    JTextArea outarea;
    JLabel fileslab;
    boolean search_flag;
    private ResourceMap resourceMap = Application.getInstance(OruxMapsDesktopApp.class).getContext().getResourceMap(JPanelDemapper.class);
    private JTextField dirfield;
    private JTextField pattfield;
    private JTextField newtextfield;
    private JTextField extfield;

    @Action
    public Task reemplaza() {
        this.startdir = this.dirfield.getText();
        this.patt = this.pattfield.getText();
        this.newtext = this.newtextfield.getText();
        this.fileExt = this.extfield.getText();
        if (this.startdir == null || this.startdir.trim().equals("") || this.patt == null || this.patt.trim().equals("") || this.newtext == null || this.newtext.trim().equals("") || this.fileExt == null || this.fileExt.trim().equals("")) {
            JOptionPane.showMessageDialog(this, this.resourceMap.getString("Invalid", new Object[0]), "Error", 0);
            return null;
        }
        if (this.search_flag) {
            JOptionPane.showMessageDialog(this, this.resourceMap.getString("Buscando", new Object[0]), "Error", 0);
            return null;
        }
        this.search_flag = true;
        return new Reemplazator(Application.getInstance(OruxMapsDesktopApp.class));
    }

    public JPanelDemapper() {
        JPanel paneltop = new JPanel();
        JPanel panelbot = new JPanel();
        paneltop.setLayout(new GridLayout(5, 2));
        JPanel panel1 = new JPanel();
        JButton buttonDir = new JButton(this.resourceMap.getString("Directorio", new Object[0]));
        this.dirfield = new JTextField(25);
        buttonDir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setSelectedFile(new File("."));
                fileChooser.setFileSelectionMode(1);
                fileChooser.setAcceptAllFileFilterUsed(false);
                int i = fileChooser.showOpenDialog(JPanelDemapper.this);
                if (i == 0) {
                    File dir = fileChooser.getSelectedFile();
                    JPanelDemapper.this.startdir = dir.toString();
                    JPanelDemapper.this.dirfield.setText(dir.toString());
                }
            }
        });
        panel1.add(buttonDir);
        panel1.add(this.dirfield);
        JPanel panel8 = new JPanel();
        panel8.add(new JLabel(this.resourceMap.getString("Ext_modificar", new Object[0])));
        this.extfield = new JTextField(10);
        this.extfield.setText(".map");
        panel8.add(this.extfield);
        JPanel panel2 = new JPanel();
        panel2.add(new JLabel(this.resourceMap.getString("Text_modificar", new Object[0])));
        this.pattfield = new JTextField(10);
        this.pattfield.setText(".ozf2");
        panel2.add(this.pattfield);
        JPanel panel3 = new JPanel();
        panel3.add(new JLabel(this.resourceMap.getString("Nuevo", new Object[0])));
        this.newtextfield = new JTextField(10);
        this.newtextfield.setText(".png");
        panel3.add(this.newtextfield);
        JPanel panel4 = new JPanel();
        JButton button = new JButton();
        ApplicationActionMap actionMap = Application.getInstance(OruxMapsDesktopApp.class).getContext().getActionMap(JPanelDemapper.class, this);
        button.setAction(actionMap.get("reemplaza"));
        button.setText(this.resourceMap.getString("Reemplazar", new Object[0]));
        panel4.add(button);
        JPanel panel5 = new JPanel();
        panel5.add(new JLabel(this.resourceMap.getString("Contribucion", new Object[0])));
        JPanel panel6 = new JPanel();
        this.fileslab = new JLabel();
        panel6.add(this.fileslab);
        JPanel panel7 = new JPanel();
        this.outarea = new JTextArea(10, 60);
        this.outarea.setEditable(false);
        JScrollPane jsp = new JScrollPane(this.outarea, 20, 31);
        panel7.add(jsp);
        paneltop.add(panel1);
        paneltop.add(panel8);
        paneltop.add(panel2);
        paneltop.add(panel3);
        paneltop.add(panel5);
        paneltop.add(panel4);
        panelbot.add(panel6);
        panelbot.add(panel7);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 1));
        panel.add(paneltop);
        panel.add(panelbot);
        this.add(panel);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Reemplazator
    extends Task<Object, Void> {
        Reemplazator(Application app) {
            super(app);
        }

        @Override
        protected Object doInBackground() {
            ArrayList filelist = new ArrayList();
            final String sep = System.getProperty("line.separator");
            this.doUpdate(new Runnable(){

                public void run() {
                    JPanelDemapper.this.outarea.setText("");
                    JPanelDemapper.this.fileslab.setText("");
                }
            });
            this.getFileList(new File(JPanelDemapper.this.startdir), filelist);
            final int size = filelist.size();
            this.setProgress(0);
            this.doUpdate(new Runnable(){

                public void run() {
                    JPanelDemapper.this.fileslab.setText(JPanelDemapper.this.resourceMap.getString("Encontrados", new Object[0]) + " " + size + " " + JPanelDemapper.this.resourceMap.getString("Encontrados", new Object[0]));
                }
            });
            for (int i = 0; i < size; ++i) {
                final String fn = (String)filelist.get(i);
                final boolean b = this.fileMatch(fn, JPanelDemapper.this.patt);
                this.setProgress((i + 1) * 100 / size);
                this.setMessage(fn);
                this.doUpdate(new Runnable(){

                    public void run() {
                        if (b) {
                            JPanelDemapper.this.outarea.append(JPanelDemapper.this.resourceMap.getString("Modificado", new Object[0]) + " " + fn + sep);
                        }
                    }
                });
            }
            this.doUpdate(new Runnable(){

                public void run() {
                    JPanelDemapper.this.outarea.setCaretPosition(0);
                    JPanelDemapper.this.fileslab.setText("");
                }
            });
            JPanelDemapper.this.search_flag = false;
            return null;
        }

        void doUpdate(Runnable r) {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InvocationTargetException e1) {
                System.err.println(e1);
            }
            catch (InterruptedException e2) {
                System.err.println(e2);
            }
        }

        void getFileList(File f, List list) {
            if (f.isDirectory()) {
                File[] entries = f.listFiles(new FileFilter(){

                    public boolean accept(File arg0) {
                        return arg0.isDirectory();
                    }
                });
                for (int i = 0; i < entries.length; ++i) {
                    this.getFileList(entries[i], list);
                }
                File[] fich = f.listFiles(new FilenameFilter(){

                    public boolean accept(File arg0, String arg1) {
                        return arg1.toLowerCase().endsWith(JPanelDemapper.this.fileExt);
                    }
                });
                for (int i = 0; i < fich.length; ++i) {
                    list.add(fich[i].getAbsolutePath());
                }
            } else if (f.isFile() && f.getName().toLowerCase().endsWith(JPanelDemapper.this.fileExt)) {
                list.add(f.getAbsolutePath());
            }
        }

        boolean fileMatch(String fn, String patt) {
            String finlinea = System.getProperty("line.separator");
            boolean found = false;
            try {
                String str;
                FileReader fr = new FileReader(fn);
                BufferedReader br = new BufferedReader(fr);
                StringBuffer sb = new StringBuffer();
                while ((str = br.readLine()) != null) {
                    JPanelDemapper.this.resultado = str;
                    if (str.indexOf(patt) != -1) {
                        found = true;
                        JPanelDemapper.this.resultado = "";
                        JPanelDemapper.this.resultado = JPanelDemapper.this.resultado + str.substring(0, str.indexOf(patt)) + JPanelDemapper.this.newtext;
                        JPanelDemapper.this.resultado = JPanelDemapper.this.resultado + str.substring(str.indexOf(patt) + patt.length());
                        JPanelDemapper.this.outarea.append(str + " - " + JPanelDemapper.this.resultado + finlinea);
                    }
                    sb.append(JPanelDemapper.this.resultado + finlinea);
                }
                br.close();
                if (found) {
                    File TextFile = new File(fn);
                    FileWriter TextOut = new FileWriter(TextFile, false);
                    TextOut.write(sb.toString());
                    TextOut.close();
                }
            }
            catch (IOException e) {
                System.err.println(e);
            }
            return found;
        }
    }
}

