/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.Task;
import oruxmapsdesktop.OruxMapsDesktopApp;
import oruxmapsdesktop.utilidades.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPanelSqlite
extends JPanel {
    private ResourceMap resourceMap;
    private StringBuilder mensajeTextArea = new StringBuilder();
    private File dirActualFinal = new File("");
    private File dirOrigenCal;
    private ButtonGroup buttonGroup1;
    private JLabel jLabel7;
    private JLabel jLabel9;
    private JPanel jPanel3;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JTextField jTextFieldDestOrigenCal;
    private JToggleButton jToggleButtonBatchConv;
    private JToggleButton jToggleButtonBuscaDirCal;

    public JPanelSqlite() {
        this.initComponents();
        this.initComponents2();
    }

    private void initComponents2() {
        this.resourceMap = Application.getInstance(OruxMapsDesktopApp.class).getContext().getResourceMap(JPanelSqlite.class);
    }

    public void actualizaMsg(String mensaje) {
        this.mensajeTextArea.append(mensaje);
        this.jTextArea1.setText(this.mensajeTextArea.toString());
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel3 = new JPanel();
        this.jLabel7 = new JLabel();
        this.jToggleButtonBuscaDirCal = new JToggleButton();
        this.jTextFieldDestOrigenCal = new JTextField();
        this.jToggleButtonBatchConv = new JToggleButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jLabel9 = new JLabel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.setName("Form");
        this.setPreferredSize(new Dimension(930, 550));
        this.jPanel3.setName("jPanel3");
        ResourceMap resourceMap = Application.getInstance(OruxMapsDesktopApp.class).getContext().getResourceMap(JPanelSqlite.class);
        this.jLabel7.setText(resourceMap.getString("jLabel7.text", new Object[0]));
        this.jLabel7.setName("jLabel7");
        this.jToggleButtonBuscaDirCal.setText(resourceMap.getString("jToggleButtonBuscaDirCal.text", new Object[0]));
        this.jToggleButtonBuscaDirCal.setName("jToggleButtonBuscaDirCal");
        this.jToggleButtonBuscaDirCal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPanelSqlite.this.jToggleButtonBuscaDirCalActionPerformed(evt);
            }
        });
        this.jTextFieldDestOrigenCal.setName("jTextFieldDestOrigenCal");
        ApplicationActionMap actionMap = Application.getInstance(OruxMapsDesktopApp.class).getContext().getActionMap(JPanelSqlite.class, this);
        this.jToggleButtonBatchConv.setAction(actionMap.get("creaOruxMapsBatch"));
        this.jToggleButtonBatchConv.setText(resourceMap.getString("jToggleButtonBatchConv.text", new Object[0]));
        this.jToggleButtonBatchConv.setName("jToggleButtonBatchConv");
        this.jScrollPane1.setName("jScrollPane1");
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setName("jTextArea1");
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jLabel9.setIcon(resourceMap.getIcon("jLabel9.icon"));
        this.jLabel9.setText(resourceMap.getString("jLabel9.text", new Object[0]));
        this.jLabel9.setName("jLabel9");
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText(resourceMap.getString("jRadioButton1.text", new Object[0]));
        this.jRadioButton1.setName("jRadioButton1");
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.setText(resourceMap.getString("jRadioButton2.text", new Object[0]));
        this.jRadioButton2.setName("jRadioButton2");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel9).addContainerGap(338, Short.MAX_VALUE)).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel7, -2, 136, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToggleButtonBuscaDirCal).addGap(18, 18, 18).addComponent(this.jTextFieldDestOrigenCal, -1, 667, Short.MAX_VALUE).addContainerGap()).addGroup(jPanel3Layout.createSequentialGroup().addGap(338, 338, 338).addComponent(this.jToggleButtonBatchConv, -2, 149, -2).addContainerGap(443, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 930, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addGap(293, 293, 293).addComponent(this.jRadioButton1).addGap(18, 18, 18).addComponent(this.jRadioButton2).addContainerGap(395, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel9).addGap(50, 50, 50).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.jToggleButtonBuscaDirCal).addComponent(this.jTextFieldDestOrigenCal, -2, -1, -2)).addGap(39, 39, 39).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton1).addComponent(this.jRadioButton2)).addGap(69, 69, 69).addComponent(this.jToggleButtonBatchConv).addGap(18, 18, 18).addComponent(this.jScrollPane1, -1, 234, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE));
    }

    private void jToggleButtonBuscaDirCalActionPerformed(ActionEvent evt) {
        File f = FileUtils.seleccionaDirectorio(this, this.dirActualFinal.getAbsolutePath());
        if (f != null) {
            this.dirOrigenCal = f;
            this.dirActualFinal = f;
            this.jTextFieldDestOrigenCal.setText(f.toString());
        }
    }

    private void displayMsg(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Warning", 2);
    }

    @Action
    public Task creaOruxMapsBatch() {
        String ori = this.jTextFieldDestOrigenCal.getText();
        if (ori == null || !new File(ori).isDirectory()) {
            this.displayMsg(this.resourceMap.getString("dir_origen_vacio", new Object[0]));
            return null;
        }
        this.dirOrigenCal = new File(ori);
        File[] files = new File[]{};
        files = this.buscaFicherosRecursivo(new ArrayList<File>(), this.dirOrigenCal).toArray(files);
        this.mensajeTextArea = new StringBuilder();
        this.mensajeTextArea.append(this.resourceMap.getString("fich_enc", new Object[0]) + files.length);
        this.jTextArea1.setText(this.mensajeTextArea.toString());
        this.jToggleButtonBatchConv.setEnabled(false);
        return new CreaOruxMapTaskBatch(Application.getInstance(OruxMapsDesktopApp.class), files);
    }

    private ArrayList<File> buscaFicherosRecursivo(ArrayList<File> files, File dirOrigenCal) {
        if (dirOrigenCal.isDirectory()) {
            File[] res = dirOrigenCal.listFiles(new FileUtils.MyFilterMapDB());
            if (res != null) {
                for (File f : res) {
                    files.add(f);
                }
            }
            if ((res = dirOrigenCal.listFiles(new FileUtils.MyFilterDir())) != null) {
                for (File f : res) {
                    this.buscaFicherosRecursivo(files, f);
                }
            }
        }
        return files;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CreaOruxMapTaskBatch
    extends Task<Object, Void> {
        private File[] fichCalibracion;
        public boolean para;

        CreaOruxMapTaskBatch(Application app, File[] fichCalibracion) {
            super(app);
            this.para = false;
            this.fichCalibracion = fichCalibracion;
        }

        @Override
        protected Object doInBackground() {
            int cont = 0;
            for (File f : this.fichCalibracion) {
                try {
                    RandomAccessFile ra = new RandomAccessFile(f, "rw");
                    ra.seek(18L);
                    int i = ra.read();
                    int ii = ra.read();
                    if (i == 1 && ii == 1) {
                        if (JPanelSqlite.this.jRadioButton1.isSelected()) {
                            ra.seek(18L);
                            ra.writeByte(2);
                            ra.writeByte(2);
                            this.setMessage("\nOK----> 0101 to 0202 |-->" + f.getAbsolutePath());
                            ++cont;
                        }
                    } else if (i == 2 && ii == 2) {
                        if (JPanelSqlite.this.jRadioButton2.isSelected()) {
                            ra.seek(18L);
                            ra.writeByte(1);
                            ra.writeByte(1);
                            this.setMessage("\nOK----> 0202 to 0101 |-->" + f.getAbsolutePath());
                            ++cont;
                        }
                    } else {
                        this.setMessage("\n" + JPanelSqlite.this.resourceMap.getString("fich_fallo", new Object[0]) + f.getAbsolutePath() + " " + "!!!");
                    }
                    ra.close();
                }
                catch (Exception ex) {
                    String s = ex.getMessage();
                    if (s == null) {
                        s = "";
                    }
                    this.setMessage("\n" + JPanelSqlite.this.resourceMap.getString("fich_fallo", new Object[0]) + f.getAbsolutePath() + " " + s + "!!!");
                    Logger.getLogger(JPanelSqlite.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            this.setMessage("\n" + JPanelSqlite.this.resourceMap.getString("msg_fin", new Object[0]) + cont);
            return null;
        }

        @Override
        protected void succeeded(Object result) {
            JPanelSqlite.this.jToggleButtonBatchConv.setEnabled(true);
        }
    }
}

