/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.jdesktop.application.Application;
import org.jdesktop.application.Task;
import oruxmapsdesktop.calculadora.MapaOruxMaps;
import oruxmapsdesktop.utilidades.ImageUtils;
import oruxmapsdesktop.utilidades.OruxMapsWriter;
import oruxmapsdesktop.utilidades.SqliteManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OruxMapsCreatorTask
extends Task<Object, Void> {
    public static final int IMG_SIZE = 512;
    protected MapaOruxMaps mc;
    private String format;
    private float quality;
    private static final DecimalFormat formatter00 = new DecimalFormat("00");
    protected boolean soloOtrk;
    private final int MAX_W = 8192;

    public OruxMapsCreatorTask(Application app, MapaOruxMaps mc, String format, float quality, boolean soloOtrk) {
        super(app);
        this.mc = mc;
        this.quality = quality;
        this.format = format;
        this.soloOtrk = soloOtrk;
    }

    protected boolean initDirectories() {
        boolean res = true;
        for (int k = 0; k < this.mc.capas.length; ++k) {
            if (!this.mc.capas[k]) continue;
            String destFinalImg = this.mc.dirDest + File.separator + this.mc.nombreMapa + File.separator + this.mc.nombreMapa + " " + formatter00.format(this.mc.nivelZoom - k);
            res &= new File(destFinalImg).mkdir();
            res &= new File(destFinalImg + File.separator + "set").mkdir();
        }
        return res;
    }

    protected int startMapCreation() {
        return 0;
    }

    protected void writeTile(ImageWriter writer, BufferedImage bi2, ImageWriteParam iwparam, int i, int j, int z) throws Exception {
        File outputfile = new File(this.mc.dirDest + File.separator + this.mc.nombreMapa + File.separator + this.mc.nombreMapa + " " + formatter00.format(z) + File.separator + "set" + File.separator + this.mc.nombreMapa + " " + formatter00.format(z) + "_" + i + "_" + j + this.mc.file_ext);
        writer.setOutput(ImageIO.createImageOutputStream(outputfile));
        writer.write(null, new IIOImage(bi2, null, null), iwparam);
    }

    protected int finishMapCreation() {
        try {
            OruxMapsWriter.creaOtrk2(this.mc, this.mc.dirDest);
        }
        catch (Exception e) {
            return 4;
        }
        return 0;
    }

    @Override
    protected Object doInBackground() throws Exception {
        String dirDestino = this.mc.dirDest + File.separator + this.mc.nombreMapa;
        if (new File(dirDestino).exists() && new File(dirDestino).isDirectory()) {
            return new Integer(5);
        }
        boolean success = new File(dirDestino).mkdir();
        boolean bl = success = success && this.initDirectories();
        if (!success) {
            return new Integer(2);
        }
        boolean falloCompresion = false;
        ImageInputStream imageStream = null;
        ImageReader reader = null;
        ImageReadParam param = null;
        BufferedImage bi = null;
        try {
            int ret;
            int[] sizeImg = ImageUtils.leeImagenDim(new File(this.mc.dirImg));
            if (sizeImg[0] + sizeImg[1] <= 0) {
                return new Integer(1);
            }
            int img_h = sizeImg[1];
            int img_w = sizeImg[0];
            int x = (img_w - 1) / 512;
            int y = (img_h - 1) / 512;
            this.mc.numXimg = x + 1;
            this.mc.numYimg = y + 1;
            if (this.mc.anchoImagen == 0 || this.mc.altoImagen == 0) {
                this.mc.anchoImagen = img_w;
                this.mc.altoImagen = img_h;
            }
            if (!this.soloOtrk) {
                ImageWriter writer = ImageIO.getImageWritersByFormatName(this.format).next();
                ImageWriteParam iwparam = writer.getDefaultWriteParam();
                try {
                    iwparam.setCompressionMode(2);
                    iwparam.setCompressionQuality(this.quality);
                }
                catch (Exception e) {
                    iwparam = writer.getDefaultWriteParam();
                    falloCompresion = true;
                }
                int temp = this.startMapCreation();
                if (temp != 0) {
                    return temp;
                }
                int factor = 1;
                for (int k = 0; k < this.mc.capas.length; ++k) {
                    if (this.mc.capas[k]) {
                        for (int j = 0; j <= y; ++j) {
                            int kk = (img_w - 1) / 8192;
                            for (int kkk = 0; kkk <= kk; ++kkk) {
                                imageStream = ImageIO.createImageInputStream(new File(this.mc.dirImg));
                                Iterator<ImageReader> it = ImageIO.getImageReaders(imageStream);
                                while (it.hasNext()) {
                                    try {
                                        reader = it.next();
                                        param = reader.getDefaultReadParam();
                                        reader.setInput(imageStream);
                                        param.setSourceRegion(new Rectangle(kkk * 8192, j * 512 * factor, 8192 * (kkk + 1) < img_w ? 8192 : img_w - 8192 * kkk, 512 * factor));
                                        bi = reader.read(0, param);
                                        break;
                                    }
                                    catch (Exception e) {
                                        imageStream = ImageIO.createImageInputStream(new File(this.mc.dirImg));
                                        bi = null;
                                    }
                                }
                                if (bi == null) {
                                    throw new Exception("error leyendo imagen");
                                }
                                x = img_w - kkk * 8192 > 8192 ? 8191 / (512 * factor) : (img_w - kkk * 8192) / (512 * factor);
                                for (int i = 0; i <= x; ++i) {
                                    BufferedImage bi2 = new BufferedImage(512, 512, 5);
                                    Graphics2D g2 = bi2.createGraphics();
                                    g2.setBackground(new Color(203, 211, 243));
                                    g2.clearRect(0, 0, 512, 512);
                                    int size_w = img_w > (i + 1) * 512 * factor + kkk * 8192 ? 512 * factor : img_w - (i * 512 * factor + kkk * 8192);
                                    int size_h = img_h > (j + 1) * 512 * factor ? 512 * factor : img_h - j * 512 * factor;
                                    g2.drawImage(bi, 0, 0, size_w / factor, size_h / factor, i * 512 * factor, 0, i * 512 * factor + size_w, size_h, null);
                                    this.writeTile(writer, bi2, iwparam, i + kkk * 8192 / (512 * factor), j, this.mc.nivelZoom - k);
                                    int iii = (j * (kk + 1) * (x + 1) + kkk * (x + 1) + i + 1) * 100 / ((y + 1) * (kk + 1) * (x + 1));
                                    this.setProgress(iii);
                                }
                                reader.dispose();
                                imageStream.close();
                                System.gc();
                            }
                        }
                    }
                    y = (img_h - 1) / (512 * (factor *= 2));
                }
                if (writer != null) {
                    writer.dispose();
                }
            }
            if ((ret = this.finishMapCreation()) > 0) {
                return new Integer(ret);
            }
        }
        catch (Throwable e1) {
            if (e1 instanceof OutOfMemoryError) {
                return new Integer(333);
            }
            return new Integer(3);
        }
        if (falloCompresion) {
            return new Integer(44);
        }
        return new Integer(0);
    }

    public static class OruxMapsCreatorSqliteTask
    extends OruxMapsCreatorTask {
        private ByteArrayOutputStream bao = new ByteArrayOutputStream(32768);
        private SqliteManager sqlite;

        public OruxMapsCreatorSqliteTask(Application app, MapaOruxMaps mc, String format, float quality, boolean soloOtrk) {
            super(app, mc, format, quality, soloOtrk);
        }

        protected boolean initDirectories() {
            return true;
        }

        protected int startMapCreation() {
            this.sqlite = new SqliteManager(this.mc);
            try {
                int tiles = 0;
                SqliteManager.loadDriver();
                int factor = 1;
                for (int k = 0; k < this.mc.capas.length; ++k) {
                    if (this.mc.capas[k]) {
                        tiles += ((this.mc.anchoImagen / factor - 1) / 512 + 1) * ((this.mc.altoImagen / factor - 1) / 512 + 1);
                    }
                    factor *= 2;
                }
                this.sqlite.initMapCreation(tiles);
            }
            catch (Exception e) {
                return new Integer(99);
            }
            return 0;
        }

        protected void writeTile(ImageWriter writer, BufferedImage bi2, ImageWriteParam iwparam, int i, int j, int z) throws Exception {
            MemoryCacheImageOutputStream imgOut = new MemoryCacheImageOutputStream(this.bao);
            writer.setOutput(imgOut);
            writer.write(null, new IIOImage(bi2, null, null), iwparam);
            imgOut.close();
            this.sqlite.createTile(i, j, z, this.bao.toByteArray());
            this.bao.reset();
        }

        protected int finishMapCreation() {
            if (!this.soloOtrk) {
                this.sqlite.finishMapCreation();
            }
            try {
                OruxMapsWriter.creaOtrk3(this.mc, this.mc.dirDest);
            }
            catch (Exception e) {
                return 4;
            }
            return 0;
        }
    }
}

