/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop;

import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;
import oruxmapsdesktop.OruxMapsCreatorTask;
import oruxmapsdesktop.OruxMapsDesktopView;
import oruxmapsdesktop.calculadora.CalibradorMapa;
import oruxmapsdesktop.calculadora.DatumAdmin;
import oruxmapsdesktop.calculadora.MapaOruxMaps;
import oruxmapsdesktop.calculadora.PuntoCalibracionMapa;
import oruxmapsdesktop.geoloc.ProjectionAdmin;
import oruxmapsdesktop.utilidades.CoordUtil;
import oruxmapsdesktop.utilidades.FileUtils;
import oruxmapsdesktop.utilidades.GeoTiffReader;
import oruxmapsdesktop.utilidades.ImageUtils;
import oruxmapsdesktop.utilidades.KapReader;
import oruxmapsdesktop.utilidades.OkmReader;
import oruxmapsdesktop.utilidades.OziReader;
import oruxmapsdesktop.utilidades.StringUtil;
import oruxmapsdesktop.utilidades.TfwReader;

public class OruxMapsDesktopApp
extends SingleFrameApplication {
    private static int ch1903 = DatumAdmin.busca("CH-1903Swiss");
    private static int rd = DatumAdmin.busca("RijksdriehoeksmetingNederland");
    private static final boolean DEBUG = false;

    private static void commandline(String[] args) throws MyException {
        String dest;
        String proj;
        MapaOruxMaps mc = null;
        String h = OruxMapsDesktopApp.extrae(args, "h");
        if (h != null) {
            OruxMapsDesktopApp.printHelp();
            return;
        }
        String cal = OruxMapsDesktopApp.extrae(args, "c");
        if (cal != null) {
            String img = OruxMapsDesktopApp.extrae(args, "i");
            mc = OruxMapsDesktopApp.extraeMapCalibration2(cal, img);
        } else {
            String puntos = OruxMapsDesktopApp.extrae(args, "r");
            if (puntos == null) {
                throw new MyException("1008");
            }
            String[] arrPuntos = puntos.split(";");
            ArrayList<PuntoCalibracionMapa> p = new ArrayList<PuntoCalibracionMapa>();
            for (String s : arrPuntos) {
                String[] temp = s.split(",");
                try {
                    PuntoCalibracionMapa pc = OruxMapsDesktopApp.leeCoord(temp[0], temp[1], temp[2], temp[3], temp[4], temp.length == 6 ? temp[5] : null);
                    p.add(pc);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            mc = new MapaOruxMaps();
            for (int i = 0; i < p.size(); ++i) {
                mc.puntosCalibracionA.add((PuntoCalibracionMapa)p.get(i));
            }
            mc.dirImg = OruxMapsDesktopApp.extrae(args, "i");
            ImageUtils.leeImagenDim(mc);
            if (mc.altoImagen <= 0 || mc.anchoImagen <= 0) {
                throw new MyException("1003");
            }
            OziReader.recolocaPuntos(mc.puntosCalUser);
        }
        String nombre = OruxMapsDesktopApp.extrae(args, "n");
        if (nombre != null) {
            mc.nombreMapa = nombre;
        }
        if (mc.nombreMapa == null) {
            throw new MyException("1009");
        }
        mc.nombreMapa = StringUtil.normalizaCadena(mc.nombreMapa);
        String datum = OruxMapsDesktopApp.extrae(args, "d");
        if (datum != null) {
            mc.datum = DatumAdmin.busca(datum);
        }
        if ((proj = OruxMapsDesktopApp.extrae(args, "p")) != null) {
            String[] params = proj.split(",");
            mc.proyeccion = ProjectionAdmin.projection(params[0]);
            if (params.length > 1) {
                mc.proyeccionData = proj.substring(params[0].length() + 1);
            }
        }
        String sqlite = OruxMapsDesktopApp.extrae(args, "sqlite");
        boolean sqliteformat = false;
        if (sqlite != null) {
            sqliteformat = true;
        }
        String otrk = OruxMapsDesktopApp.extrae(args, "otrk");
        boolean otrkfile = false;
        if (otrk != null) {
            otrkfile = true;
        }
        String jpeg = OruxMapsDesktopApp.extrae(args, "q");
        String tipo = "JPEG";
        float calidad = 0.85f;
        if (jpeg != null) {
            String[] params = jpeg.split(",");
            tipo = params[0];
            calidad = Float.parseFloat(params[1]) / 100.0f;
        }
        mc.dirDest = (dest = OruxMapsDesktopApp.extrae(args, "o")) != null ? dest : new File(mc.dirImg).getParent();
        if (mc.proyeccion == 0) {
            throw new MyException("1006");
        }
        if (mc.datum == ch1903 || mc.datum == rd && mc.proyeccion == 7) {
            try {
                if (Double.isNaN(mc.puntosCalibracionA.get((int)0).xLon)) {
                    mc.puntosCalUser = mc.puntosCalibracionA;
                    CalibradorMapa.calibraWGS84Grid(mc);
                }
                mc.puntosCalUser = mc.puntosCalibracionA;
                CalibradorMapa.calibraWGS84Geo(mc);
            }
            catch (Exception e) {
                throw new MyException("1007");
            }
        } else if (mc.datum > 0) {
            try {
                if (CalibradorMapa.coodenadasEsquinasOk(mc, mc.puntosCalibracionB)) {
                    mc.puntosCalUser = mc.puntosCalibracionB;
                    CalibradorMapa.calibraWGS84Geo(mc);
                }
                if (Double.isNaN(mc.puntosCalibracionA.get((int)0).xLon)) {
                    mc.puntosCalUser = mc.puntosCalibracionA;
                    CalibradorMapa.calibraWGS84Grid(mc);
                }
                mc.puntosCalUser = mc.puntosCalibracionA;
                CalibradorMapa.calibraWGS84Geo(mc);
            }
            catch (Exception e) {
                throw new MyException("1007");
            }
        } else {
            throw new MyException("1005");
        }
        String zooms = OruxMapsDesktopApp.extrae(args, "z");
        if (zooms != null) {
            String[] params = zooms.split(",");
            mc.capas[1] = OruxMapsDesktopApp.contiene(params, "50");
            mc.capas[2] = OruxMapsDesktopApp.contiene(params, "25");
            mc.capas[3] = OruxMapsDesktopApp.contiene(params, "12.5");
            mc.capas[4] = OruxMapsDesktopApp.contiene(params, "6.25");
            for (int k = 1; k <= 4; ++k) {
                int n = k;
                mc.capas[n] = mc.capas[n] & mc.nivelZoom - k >= 0;
            }
        }
        OruxMapsDesktopApp.checkComponentes();
        if (sqliteformat) {
            new OruxMapsCreatorTask.OruxMapsCreatorSqliteTask(Application.getInstance(OruxMapsDesktopApp.class), mc, tipo, calidad, otrkfile){

                protected void succeeded(Object result) {
                    OruxMapsDesktopApp.notifyEndConversion((Integer)result);
                }
            }.execute();
        } else {
            new OruxMapsCreatorTask(Application.getInstance(OruxMapsDesktopApp.class), mc, tipo, calidad, otrkfile){

                protected void succeeded(Object result) {
                    OruxMapsDesktopApp.notifyEndConversion((Integer)result);
                }
            }.execute();
        }
    }

    private static PuntoCalibracionMapa leeCoord(String geo, String jtfx, String jtfy, String jtfLon, String jtfLat, String jcb) {
        PuntoCalibracionMapa pt = null;
        try {
            pt = new PuntoCalibracionMapa();
            pt.y = Integer.parseInt(jtfy);
            pt.x = Integer.parseInt(jtfx);
            if (geo.equals("geo")) {
                pt.yLat = CoordUtil.leeCoordenada(jtfLat);
                pt.xLon = CoordUtil.leeCoordenada(jtfLon);
                if (Math.abs(pt.yLat) > 90.0 || Math.abs(pt.xLon) > 180.0) {
                    throw new Exception();
                }
            } else {
                pt.yNorth = Double.parseDouble(jtfLat);
                pt.xEast = Double.parseDouble(jtfLon);
                pt.northing = jcb.equalsIgnoreCase("N");
            }
        }
        catch (Exception e) {
            pt = null;
        }
        return pt;
    }

    private static void notifyEndConversion(int result) {
        System.exit(result);
    }

    private static boolean checkComponentes() {
        boolean res = true;
        return res;
    }

    private static boolean contiene(String[] vals, String val) {
        for (String s : vals) {
            if (!s.equals(val)) continue;
            return true;
        }
        return false;
    }

    private static String extrae(String[] args, String param) {
        String check = "-" + param;
        for (String s : args) {
            if (!s.startsWith(check)) continue;
            if (s.length() == check.length()) {
                return s;
            }
            return s.substring(check.length() + 1);
        }
        return null;
    }

    protected void startup() {
        this.show(new OruxMapsDesktopView(this));
    }

    protected void configureWindow(Window root) {
    }

    public static OruxMapsDesktopApp getApplication() {
        return Application.getInstance(OruxMapsDesktopApp.class);
    }

    private static void test(String[] s) {
        try {
            OruxMapsDesktopApp.commandline(s);
        }
        catch (MyException ex) {
            System.out.println(ex.getMessage());
        }
    }

    public static void main(String[] args) {
        if (args != null && args.length > 0) {
            try {
                OruxMapsDesktopApp.commandline(args);
            }
            catch (MyException ex) {
                System.out.println(ex.getMessage() + "-->" + ex.toString());
                System.exit(Integer.parseInt(ex.getMessage()));
            }
        } else {
            OruxMapsDesktopApp.launch(OruxMapsDesktopApp.class, args);
        }
    }

    private static void printHelp() {
        System.out.println("Usage: java -Xmx512m -jar [options]\noptions (if not present, windows version started):\n-c='calibration file path' -->can read .map, .tfw, .jpw, .pgw, .tfwx, .tif, .kap files\n-n='map name' -->mandatory if no -c param\n-r='reference points' -->mandatory if no -c param, ignored if -c exists; format: [geo|grid],x,y,lon_east,lat_north[,[N|S]]\n-i='image file path' -->optional; needed if the image file can not be found calibration file\n-d='datum' -->optional; needed if the datum can not be found inside calibration file. Must be taken from datums.txt file.\n\t\texample, if we want to use Adindan|Burkina Faso|Clarke 1880|-118.000000|-14.000000|218.000000|0.000000|0.000000|0.000000|0.000000 datum:\n\t\t-d='AdindanBurkina Faso' -->two values (datum name + region without | symbol)\n-p='projection plus projection data' -->optional; needed if the projection can not be found inside calibration file.\n\t\tsupported projection + parameters, examples:\n\t\t//'FLAT EARTH'\n\t\t//'UTM,33' --> zone\n\t\t//'MERCATOR,0.0' --> lon0\n\t\t//'SWISS GRID'\n\t\t//'LATITUDE/LONGITUDE'\n\t\t//'IRISH GRID'\n\t\t//'RD GRID'\n\t\t//'LAMBERT CONFORMAL,22.2,120.333,10.0,30.0,5000000.0,10000000.0' -->lat0, lon0, par1, par2, falsE, falsN\n\t\t//'TRANSVERSE MERCATOR,12.2,12.55,0.9996,0.0,0.0' -->lon0, lat0, k, falsE, falsN\n\t\t//'AMERICAN POLYCONIC,-110.0,0.0,0.0' -->lon0, falsE, falsN\n\t\t//'EQUIRECTANGULAR,45.0' -->lat0\n-sqlite -->optional, will create sqlite map (recommended)\n-otrk -->optional, will create only calibration file\n-q=[JPEG|PNG],[0-100] -->optional, default (JPEG,85) map format & quality; example -q=JPEG,85\n-o='path to destination directory' -->optional, if not present the map will be created where the image is found\n-z=[50,][25,][12.5][6.25] -->optional; zoom levels added\n-h -->prints this help ");
    }

    private static MapaOruxMaps extraeMapCalibration2(String cal, String imagen) throws MyException {
        MapaOruxMaps mc2 = null;
        File ficheroCal = new File(cal);
        if (!ficheroCal.exists()) {
            throw new MyException("1001");
        }
        if (ficheroCal.toString().toLowerCase().endsWith(".map")) {
            int[] imagem;
            try {
                mc2 = OziReader.lee(ficheroCal);
            }
            catch (Exception ex) {
                throw new MyException("1002");
            }
            if (imagen == null) {
                imagen = ficheroCal.getParent() + File.separator + FileUtils.buscaImagen(ficheroCal.getParentFile(), ficheroCal.getName().substring(0, ficheroCal.getName().length() - 4), FileUtils.imageType);
            }
            if ((imagem = ImageUtils.leeImagenDim(new File(imagen)))[0] < 1) {
                throw new MyException("1003");
            }
            mc2.anchoImagen = imagem[0];
            mc2.altoImagen = imagem[1];
            OziReader.recolocaPuntos(mc2.puntosCalibracionA);
            OziReader.recolocaPuntos(mc2.puntosCalibracionB);
        } else if (ficheroCal.toString().toLowerCase().endsWith("tfw") || ficheroCal.toString().toLowerCase().endsWith("pgw") || ficheroCal.toString().toLowerCase().endsWith("tfwx") || ficheroCal.toString().toLowerCase().endsWith("jpw") || ficheroCal.toString().toLowerCase().endsWith("kap")) {
            int[] dim;
            if (imagen == null) {
                int i = ficheroCal.toString().toLowerCase().endsWith("tfwx") ? 5 : 4;
                imagen = FileUtils.buscaImagen(ficheroCal.getParentFile(), ficheroCal.getName().substring(0, ficheroCal.getName().length() - i), FileUtils.imageType);
                if (imagen != null) {
                    imagen = ficheroCal.getParentFile().getAbsolutePath() + File.separator + imagen;
                } else {
                    throw new MyException("3");
                }
            }
            if ((dim = ImageUtils.leeImagenDim(new File(imagen)))[0] == -1) {
                throw new MyException("3");
            }
            if (ficheroCal.toString().toLowerCase().endsWith("tfw") || ficheroCal.toString().toLowerCase().endsWith("pgw") || ficheroCal.toString().toLowerCase().endsWith("tfwx") || ficheroCal.toString().toLowerCase().endsWith("jpw")) {
                try {
                    mc2 = TfwReader.lee(ficheroCal, dim[0], dim[1]);
                }
                catch (Exception ex) {
                    throw new MyException("2");
                }
            } else {
                try {
                    mc2 = KapReader.lee(ficheroCal, dim[0], dim[1]);
                }
                catch (Exception ex) {
                    throw new MyException("2");
                }
            }
        } else if (ficheroCal.getName().toLowerCase().endsWith("tif") || ficheroCal.getName().toLowerCase().endsWith("tiff")) {
            try {
                mc2 = GeoTiffReader.lee(ficheroCal);
            }
            catch (Exception ex) {
                throw new MyException("2");
            }
            if (imagen == null) {
                imagen = ficheroCal.toString();
            }
        } else if (ficheroCal.getName().toLowerCase().endsWith("okm")) {
            int[] imagem;
            try {
                mc2 = OkmReader.lee(ficheroCal);
            }
            catch (Exception ex) {
                throw new MyException("1002");
            }
            if (imagen == null) {
                imagen = ficheroCal.getParent() + File.separator + FileUtils.buscaImagen(ficheroCal.getParentFile(), ficheroCal.getName().substring(0, ficheroCal.getName().length() - 4), FileUtils.imageType);
            }
            if ((imagem = ImageUtils.leeImagenDim(new File(imagen)))[0] < 1) {
                throw new MyException("1003");
            }
            mc2.anchoImagen = imagem[0];
            mc2.altoImagen = imagem[1];
            OziReader.recolocaPuntos(mc2.puntosCalibracionA);
        } else {
            throw new MyException("4");
        }
        mc2.dirImg = imagen;
        return mc2;
    }

    private static class MyException
    extends Exception {
        public MyException(String msg) {
            super(msg);
        }

        public String toString() {
            switch (Integer.parseInt(this.getMessage())) {
                case 1001: {
                    return "Error: Can not find calibration file!";
                }
                case 1002: {
                    return "Error: Can not read calibration file!";
                }
                case 1003: {
                    return "Error: Can not find image file!";
                }
                case 1004: {
                    return "Error: Calibration format not supported!";
                }
                case 1005: {
                    return "Error: Unknown datum!";
                }
                case 1006: {
                    return "Error: Unknown projection!";
                }
                case 1007: {
                    return "Error: Calibrating the map!";
                }
                case 1008: {
                    return "Error: Reading calibration points!";
                }
                case 1009: {
                    return "Error: Map name not found!";
                }
            }
            return "";
        }
    }
}

