/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;
import oruxmapsdesktop.JPanelBatchConvertor;
import oruxmapsdesktop.JPanelCalculator;
import oruxmapsdesktop.JPanelConvertor;
import oruxmapsdesktop.JPanelDemapper;
import oruxmapsdesktop.JPanelSqlite;
import oruxmapsdesktop.OruxMapsDesktopAboutBox;
import oruxmapsdesktop.OruxMapsDesktopApp;

public class OruxMapsDesktopView
extends FrameView {
    private JPanelBatchConvertor jPanelBatchConvertor1;
    private JPanelCalculator jPanelCalculator1;
    private JPanelConvertor jPanelConvertor1;
    private JTabbedPane jTabbedPane1;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JProgressBar progressBar;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private JPanelSqlite jPanelSqlite1;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private ResourceMap resourceMap = this.getResourceMap();
    private JDialog aboutBox;

    public OruxMapsDesktopView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        this.initComponents2();
        int messageTimeout = this.resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OruxMapsDesktopView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = this.resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = this.resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OruxMapsDesktopView.this.busyIconIndex = (OruxMapsDesktopView.this.busyIconIndex + 1) % OruxMapsDesktopView.this.busyIcons.length;
                OruxMapsDesktopView.this.statusAnimationLabel.setIcon(OruxMapsDesktopView.this.busyIcons[OruxMapsDesktopView.this.busyIconIndex]);
            }
        });
        this.idleIcon = this.resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!OruxMapsDesktopView.this.busyIconTimer.isRunning()) {
                        OruxMapsDesktopView.this.statusAnimationLabel.setIcon(OruxMapsDesktopView.this.busyIcons[0]);
                        OruxMapsDesktopView.this.busyIconIndex = 0;
                        OruxMapsDesktopView.this.busyIconTimer.start();
                    }
                    OruxMapsDesktopView.this.progressBar.setVisible(true);
                    OruxMapsDesktopView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    OruxMapsDesktopView.this.busyIconTimer.stop();
                    OruxMapsDesktopView.this.statusAnimationLabel.setIcon(OruxMapsDesktopView.this.idleIcon);
                    OruxMapsDesktopView.this.progressBar.setVisible(false);
                    OruxMapsDesktopView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    OruxMapsDesktopView.this.statusMessageLabel.setText(text == null ? "" : text);
                    if (OruxMapsDesktopView.this.jTabbedPane1.getSelectedComponent() == OruxMapsDesktopView.this.jPanelBatchConvertor1) {
                        OruxMapsDesktopView.this.jPanelBatchConvertor1.actualizaMsg(text);
                    } else if (OruxMapsDesktopView.this.jTabbedPane1.getSelectedComponent() == OruxMapsDesktopView.this.jPanelSqlite1) {
                        OruxMapsDesktopView.this.jPanelSqlite1.actualizaMsg(text);
                    }
                    OruxMapsDesktopView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    OruxMapsDesktopView.this.progressBar.setVisible(true);
                    OruxMapsDesktopView.this.progressBar.setIndeterminate(false);
                    OruxMapsDesktopView.this.progressBar.setValue(value);
                }
            }
        });
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = OruxMapsDesktopApp.getApplication().getMainFrame();
            this.aboutBox = new OruxMapsDesktopAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        try {
            OruxMapsDesktopApp.getApplication().show(this.aboutBox);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initComponents2() {
        this.jTabbedPane1.addTab(this.resourceMap.getString("jPanelDemapper", new Object[0]), new JPanelDemapper());
        this.jPanelSqlite1 = new JPanelSqlite();
        this.jTabbedPane1.addTab(this.resourceMap.getString("jPanelSqlite", new Object[0]), this.jPanelSqlite1);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelConvertor1 = new JPanelConvertor();
        this.jPanelBatchConvertor1 = new JPanelBatchConvertor();
        this.jPanelCalculator1 = new JPanelCalculator();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.mainPanel.setMaximumSize(new Dimension(960, 600));
        this.mainPanel.setName("mainPanel");
        this.mainPanel.setPreferredSize(new Dimension(960, 600));
        this.jTabbedPane1.setName("jTabbedPane1");
        this.jPanelConvertor1.setName("jPanelConvertor1");
        ResourceMap resourceMap = Application.getInstance(OruxMapsDesktopApp.class).getContext().getResourceMap(OruxMapsDesktopView.class);
        this.jTabbedPane1.addTab(resourceMap.getString("jPanelConvertor1.TabConstraints.tabTitle", new Object[0]), this.jPanelConvertor1);
        this.jPanelBatchConvertor1.setName("jPanelBatchConvertor1");
        this.jTabbedPane1.addTab(resourceMap.getString("jPanelBatchConvertor1.TabConstraints.tabTitle", new Object[0]), this.jPanelBatchConvertor1);
        this.jPanelCalculator1.setName("jPanelCalculator1");
        this.jTabbedPane1.addTab(resourceMap.getString("jPanelCalculator1.TabConstraints.tabTitle", new Object[0]), this.jPanelCalculator1);
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -1, 1061, Short.MAX_VALUE));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -2, 548, Short.MAX_VALUE));
        this.jTabbedPane1.getAccessibleContext().setAccessibleName(resourceMap.getString("jTabbedPane1.AccessibleContext.accessibleName", new Object[0]));
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        ApplicationActionMap actionMap = Application.getInstance(OruxMapsDesktopApp.class).getContext().getActionMap(OruxMapsDesktopView.class, this);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 1061, Short.MAX_VALUE).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 879, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }
}

