/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.calculadora;

import java.util.ArrayList;
import oruxmapsdesktop.calculadora.DatumAdmin;
import oruxmapsdesktop.calculadora.DatumtoWGS84;
import oruxmapsdesktop.calculadora.MapaOruxMaps;
import oruxmapsdesktop.calculadora.MatrixCalc;
import oruxmapsdesktop.calculadora.PuntoCalibracionMapa;
import oruxmapsdesktop.geoloc.LatLonPoint;
import oruxmapsdesktop.geoloc.LatLonPointImpl;
import oruxmapsdesktop.geoloc.ProjectionAdmin;
import oruxmapsdesktop.geoloc.ProjectionImpl;
import oruxmapsdesktop.geoloc.ProjectionPointImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalibradorMapa {
    public static final int TL = 0;
    public static final int BR = 1;
    public static final int TR = 2;
    public static final int BL = 3;

    public static boolean estaCalibrado(MapaOruxMaps mapa, ArrayList<PuntoCalibracionMapa> puntos) {
        if (puntos.size() < 4) {
            return false;
        }
        try {
            return mapa.datum == DatumAdmin.busca("WGS 1984Global Definition") && CalibradorMapa.coodenadasEsquinasOk(mapa, puntos) && !Double.isNaN(puntos.get((int)2).xLon) && !Double.isNaN(puntos.get((int)0).xLon) && !Double.isNaN(puntos.get((int)1).xLon) && !Double.isNaN(puntos.get((int)3).xLon) && !Double.isNaN(puntos.get((int)2).yLat) && !Double.isNaN(puntos.get((int)1).yLat) && !Double.isNaN(puntos.get((int)0).yLat) && !Double.isNaN(puntos.get((int)3).yLat);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean coodenadasEsquinasOk(MapaOruxMaps mapa, ArrayList<PuntoCalibracionMapa> puntos) {
        try {
            return !(puntos.get((int)0).x != 0 || puntos.get((int)0).y != 0 || puntos.get((int)2).y != 0 || puntos.get((int)3).x != 0 || puntos.get((int)2).x == 0 || puntos.get((int)3).y == 0 || puntos.get((int)1).x == 0 || puntos.get((int)1).y == 0 || puntos.get((int)2).x != puntos.get((int)1).x || puntos.get((int)1).y != puntos.get((int)3).y || puntos.get((int)1).x != mapa.anchoImagen - 1 && puntos.get((int)1).x != mapa.anchoImagen || puntos.get((int)1).y != mapa.altoImagen - 1 && puntos.get((int)1).y != mapa.altoImagen);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static MapaOruxMaps calibraWGS84Grid(MapaOruxMaps mc) throws Exception {
        ProjectionImpl p = null;
        if (CalibradorMapa.coodenadasEsquinasOk(mc, mc.puntosCalUser)) {
            p = ProjectionAdmin.getProjection(mc);
            if (p == null) {
                throw new Exception();
            }
            LatLonPointImpl llp = p.projToLatLon(mc.puntosCalUser.get((int)0).xEast, mc.puntosCalUser.get((int)0).yNorth);
            mc.puntosCalUser.get((int)0).yLat = llp.getLatitude();
            mc.puntosCalUser.get((int)0).xLon = llp.getLongitude();
            llp = p.projToLatLon(mc.puntosCalUser.get((int)2).xEast, mc.puntosCalUser.get((int)2).yNorth);
            mc.puntosCalUser.get((int)2).yLat = llp.getLatitude();
            mc.puntosCalUser.get((int)2).xLon = llp.getLongitude();
            llp = p.projToLatLon(mc.puntosCalUser.get((int)3).xEast, mc.puntosCalUser.get((int)3).yNorth);
            mc.puntosCalUser.get((int)3).yLat = llp.getLatitude();
            mc.puntosCalUser.get((int)3).xLon = llp.getLongitude();
            llp = p.projToLatLon(mc.puntosCalUser.get((int)1).xEast, mc.puntosCalUser.get((int)1).yNorth);
            mc.puntosCalUser.get((int)1).yLat = llp.getLatitude();
            mc.puntosCalUser.get((int)1).xLon = llp.getLongitude();
            if (p.isRequiereConversionDatum()) {
                CalibradorMapa.calibraWGS84Geo(mc);
            } else {
                for (int i = 0; i < 4; ++i) {
                    mc.puntosCalibracionFinales[i] = mc.puntosCalUser.get(i);
                }
            }
        } else {
            CalibradorMapa.calibraWGS84GridPuntos(mc);
        }
        mc.nivelZoom = MapaOruxMaps.nivelMejor(mc, mc.puntosCalibracionFinales);
        return mc;
    }

    private static MapaOruxMaps calibraWGS84GridPuntos(MapaOruxMaps mc) throws Exception {
        PuntoCalibracionMapa[] puntosTemp = PuntoCalibracionMapa.initArrayPuntoCalibracionMapa(4);
        puntosTemp[2].x = mc.anchoImagen - 1;
        puntosTemp[1].x = mc.anchoImagen - 1;
        puntosTemp[3].y = mc.altoImagen - 1;
        puntosTemp[1].y = mc.altoImagen - 1;
        puntosTemp[1].grid = puntosTemp[0].grid = CalibradorMapa.getGrid(mc.puntosCalUser);
        puntosTemp[2].grid = puntosTemp[0].grid;
        puntosTemp[3].grid = puntosTemp[0].grid;
        puntosTemp[1].northing = puntosTemp[0].northing = CalibradorMapa.getNorth(mc.puntosCalUser);
        puntosTemp[2].northing = puntosTemp[0].northing;
        puntosTemp[3].northing = puntosTemp[0].northing;
        ArrayList<PuntoCalibracionMapa> pun = new ArrayList<PuntoCalibracionMapa>();
        for (PuntoCalibracionMapa p : mc.puntosCalUser) {
            if (p == null || Double.isNaN(p.xEast)) continue;
            pun.add(p);
        }
        if (pun.size() < 3 || !CalibradorMapa.calibra2(pun, puntosTemp)) {
            ArrayList<PuntoCalibracionMapa[]> res = new ArrayList<PuntoCalibracionMapa[]>();
            for (int i = 0; i < 3; ++i) {
                for (int j = i + 1; j < 4; ++j) {
                    try {
                        if (Double.isNaN(mc.puntosCalUser.get((int)i).xEast) || Double.isNaN(mc.puntosCalUser.get((int)j).xEast) || Math.abs(mc.puntosCalUser.get((int)i).x - mc.puntosCalUser.get((int)j).x) <= mc.anchoImagen / 10 || Math.abs(mc.puntosCalUser.get((int)i).y - mc.puntosCalUser.get((int)j).y) <= mc.altoImagen / 10) continue;
                        PuntoCalibracionMapa[] param = new PuntoCalibracionMapa[]{mc.puntosCalUser.get(i), mc.puntosCalUser.get(j)};
                        PuntoCalibracionMapa[] res1 = CalibradorMapa.deDosAEsquinas(param, mc.anchoImagen, mc.altoImagen);
                        res.add(res1);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            int cont = res.size();
            if (cont == 0) {
                throw new Exception("Mapa no calibrado");
            }
            puntosTemp[0].xEast = 0.0;
            puntosTemp[1].xEast = 0.0;
            puntosTemp[2].xEast = 0.0;
            puntosTemp[3].xEast = 0.0;
            puntosTemp[0].yNorth = 0.0;
            puntosTemp[1].yNorth = 0.0;
            puntosTemp[2].yNorth = 0.0;
            puntosTemp[3].yNorth = 0.0;
            for (int i = 0; i < cont; ++i) {
                puntosTemp[0].xEast += ((PuntoCalibracionMapa[])res.get((int)i))[0].xEast;
                puntosTemp[1].xEast += ((PuntoCalibracionMapa[])res.get((int)i))[1].xEast;
                puntosTemp[2].xEast += ((PuntoCalibracionMapa[])res.get((int)i))[2].xEast;
                puntosTemp[3].xEast += ((PuntoCalibracionMapa[])res.get((int)i))[3].xEast;
                puntosTemp[0].yNorth += ((PuntoCalibracionMapa[])res.get((int)i))[0].yNorth;
                puntosTemp[1].yNorth += ((PuntoCalibracionMapa[])res.get((int)i))[1].yNorth;
                puntosTemp[2].yNorth += ((PuntoCalibracionMapa[])res.get((int)i))[2].yNorth;
                puntosTemp[3].yNorth += ((PuntoCalibracionMapa[])res.get((int)i))[3].yNorth;
            }
            puntosTemp[0].xEast /= (double)cont;
            puntosTemp[1].xEast /= (double)cont;
            puntosTemp[2].xEast /= (double)cont;
            puntosTemp[3].xEast /= (double)cont;
            puntosTemp[0].yNorth /= (double)cont;
            puntosTemp[1].yNorth /= (double)cont;
            puntosTemp[2].yNorth /= (double)cont;
            puntosTemp[3].yNorth /= (double)cont;
        }
        mc.puntosCalUser.clear();
        mc.puntosCalUser.add(puntosTemp[0]);
        mc.puntosCalUser.add(puntosTemp[1]);
        mc.puntosCalUser.add(puntosTemp[2]);
        mc.puntosCalUser.add(puntosTemp[3]);
        CalibradorMapa.calibraWGS84Grid(mc);
        return mc;
    }

    private static String getGrid(ArrayList<PuntoCalibracionMapa> puntosTemp) {
        String res = "0";
        for (PuntoCalibracionMapa p : puntosTemp) {
            if (Double.isNaN(p.xEast)) continue;
            return p.grid;
        }
        return res;
    }

    private static boolean getNorth(ArrayList<PuntoCalibracionMapa> puntosTemp) {
        boolean res = true;
        for (PuntoCalibracionMapa p : puntosTemp) {
            if (Double.isNaN(p.xEast)) continue;
            return p.northing;
        }
        return res;
    }

    private static PuntoCalibracionMapa[] deDosAEsquinas(PuntoCalibracionMapa[] origen, int width, int height) throws Exception {
        double alfa1 = Math.atan((-origen[0].yNorth + origen[1].yNorth) / (origen[0].xEast - origen[1].xEast));
        double alfa2 = Math.atan(((double)origen[0].y * 1.0 - (double)origen[1].y) / (double)(origen[0].x - origen[1].x));
        double A = alfa2 - alfa1;
        double cosA = Math.cos(A);
        double sinA = Math.sin(A);
        double x1 = (double)origen[1].x * cosA + (double)origen[1].y * sinA;
        double y1 = (double)(-origen[1].x) * sinA + (double)origen[1].y * cosA;
        double x2 = (double)origen[0].x * cosA + (double)origen[0].y * sinA;
        double y2 = (double)(-origen[0].x) * sinA + (double)origen[0].y * cosA;
        double xw = (double)(width - 1) * cosA + (double)(height - 1) * sinA;
        double yh = (double)(-(width - 1)) * sinA + (double)(height - 1) * cosA;
        double coefx = (origen[0].xEast - origen[1].xEast) / (x2 - x1);
        double coefy = (-origen[0].yNorth + origen[1].yNorth) / (y2 - y1);
        PuntoCalibracionMapa[] puntosTemp = PuntoCalibracionMapa.initArrayPuntoCalibracionMapa(4);
        if (x1 < x2) {
            puntosTemp[0].xEast = origen[1].xEast - x1 * coefx;
            puntosTemp[1].xEast = origen[0].xEast + (xw - x2) * coefx;
        } else {
            puntosTemp[0].xEast = origen[0].xEast - x2 * coefx;
            puntosTemp[1].xEast = origen[1].xEast + (xw - x1) * coefx;
        }
        if (y1 < y2) {
            puntosTemp[0].yNorth = origen[1].yNorth + y1 * coefy;
            puntosTemp[1].yNorth = origen[0].yNorth - (yh - y2) * coefy;
        } else {
            puntosTemp[0].yNorth = origen[0].yNorth + y2 * coefy;
            puntosTemp[1].yNorth = origen[1].yNorth - (yh - y1) * coefy;
        }
        puntosTemp[3].xEast = puntosTemp[0].xEast + sinA * (double)(height - 1) * coefx;
        puntosTemp[2].yNorth = puntosTemp[0].yNorth + (double)(width - 1) * sinA * coefy;
        puntosTemp[3].yNorth = puntosTemp[1].yNorth - sinA * (double)(width - 1) * coefy;
        puntosTemp[2].xEast = puntosTemp[1].xEast - (double)(height - 1) * sinA * coefx;
        puntosTemp[3].y = height - 1;
        puntosTemp[1].y = height - 1;
        puntosTemp[1].x = width - 1;
        puntosTemp[2].x = width - 1;
        return puntosTemp;
    }

    private static boolean calibra2(ArrayList<PuntoCalibracionMapa> puntos, PuntoCalibracionMapa[] res) {
        int s = puntos.size();
        int[][] opciones3 = new int[][]{{0, 1, 2}};
        int[][] opciones4 = new int[][]{{0, 1, 2}, {0, 1, 3}, {1, 2, 3}};
        int[][] opciones5 = new int[][]{{0, 1, 2}, {0, 1, 3}, {0, 1, 4}, {0, 2, 3}, {0, 2, 4}, {1, 2, 3}, {1, 2, 4}, {1, 3, 4}, {2, 3, 4}};
        if (s < 3) {
            return false;
        }
        int[][] ops = s == 3 ? opciones3 : (s == 4 ? opciones4 : opciones5);
        for (int[] dd : ops) {
            PuntoCalibracionMapa p0 = puntos.get(dd[0]);
            PuntoCalibracionMapa p1 = puntos.get(dd[1]);
            PuntoCalibracionMapa p2 = puntos.get(dd[2]);
            double[] pixx = new double[]{p0.xEast, p1.xEast, p2.xEast};
            double[] pixy = new double[]{p0.yNorth, p1.yNorth, p2.yNorth};
            double[] res0 = new double[]{0.0, 0.0, 0.0};
            double[] res2 = new double[]{0.0, 0.0, 0.0};
            double[][] matr = new double[][]{{p0.x, p0.y, 1.0}, {p1.x, p1.y, 1.0}, {p2.x, p2.y, 1.0}};
            double[][] matr2 = new double[][]{{p0.x, p0.y, 1.0}, {p1.x, p1.y, 1.0}, {p2.x, p2.y, 1.0}};
            MatrixCalc mc = new MatrixCalc();
            boolean ok = mc.resolver(matr, pixx, res0, 3);
            mc.resolver(matr2, pixy, res2, 3);
            for (PuntoCalibracionMapa p : res) {
                p.xEast = res0[0] * (double)p.x + res0[1] * (double)p.y + res0[2];
                p.yNorth = res2[0] * (double)p.x + res2[1] * (double)p.y + res2[2];
            }
            if (!ok) continue;
            return ok;
        }
        return false;
    }

    private static MapaOruxMaps calibraWGS84GeoPuntos(MapaOruxMaps mc) throws Exception {
        PuntoCalibracionMapa[] puntosTemp = PuntoCalibracionMapa.initArrayPuntoCalibracionMapa(4);
        puntosTemp[2].x = mc.anchoImagen - 1;
        puntosTemp[1].x = mc.anchoImagen - 1;
        puntosTemp[3].y = mc.altoImagen - 1;
        puntosTemp[1].y = mc.altoImagen - 1;
        ProjectionImpl proyeccion = ProjectionAdmin.getProjection(mc);
        if (mc == null) {
            throw new Exception();
        }
        ArrayList<PuntoCalibracionMapa> pun = new ArrayList<PuntoCalibracionMapa>();
        for (PuntoCalibracionMapa p : mc.puntosCalUser) {
            if (p == null || Double.isNaN(p.xLon)) continue;
            ProjectionPointImpl pp1 = proyeccion.latLonToProj(p.yLat, p.xLon);
            p.xEast = pp1.getX();
            p.yNorth = pp1.getY();
            pun.add(p);
        }
        if (pun.size() < 3 || !CalibradorMapa.calibra2(pun, puntosTemp)) {
            ArrayList<PuntoCalibracionMapa[]> res = new ArrayList<PuntoCalibracionMapa[]>();
            int lim = mc.puntosCalUser.size();
            for (int i = 0; i < lim - 1; ++i) {
                for (int j = i + 1; j < lim; ++j) {
                    if (Double.isNaN(mc.puntosCalUser.get((int)i).xLon) || Double.isNaN(mc.puntosCalUser.get((int)j).xLon) || Math.abs(mc.puntosCalUser.get((int)i).x - mc.puntosCalUser.get((int)j).x) <= mc.anchoImagen / 10 || Math.abs(mc.puntosCalUser.get((int)i).y - mc.puntosCalUser.get((int)j).y) <= mc.altoImagen / 10) continue;
                    ProjectionPointImpl pp1 = proyeccion.latLonToProj(mc.puntosCalUser.get((int)i).yLat, mc.puntosCalUser.get((int)i).xLon);
                    ProjectionPointImpl pp2 = proyeccion.latLonToProj(mc.puntosCalUser.get((int)j).yLat, mc.puntosCalUser.get((int)j).xLon);
                    mc.puntosCalUser.get((int)i).xEast = pp1.getX();
                    mc.puntosCalUser.get((int)i).yNorth = pp1.getY();
                    mc.puntosCalUser.get((int)j).xEast = pp2.getX();
                    mc.puntosCalUser.get((int)j).yNorth = pp2.getY();
                    PuntoCalibracionMapa[] params = new PuntoCalibracionMapa[]{mc.puntosCalUser.get(i), mc.puntosCalUser.get(j)};
                    try {
                        PuntoCalibracionMapa[] res1 = CalibradorMapa.deDosAEsquinas(params, mc.anchoImagen, mc.altoImagen);
                        res.add(res1);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            int cont = res.size();
            if (cont == 0) {
                throw new Exception("Mapa no calibrado");
            }
            puntosTemp[0].xEast = 0.0;
            puntosTemp[1].xEast = 0.0;
            puntosTemp[2].xEast = 0.0;
            puntosTemp[3].xEast = 0.0;
            puntosTemp[0].yNorth = 0.0;
            puntosTemp[1].yNorth = 0.0;
            puntosTemp[2].yNorth = 0.0;
            puntosTemp[3].yNorth = 0.0;
            for (int i = 0; i < cont; ++i) {
                puntosTemp[0].xEast += ((PuntoCalibracionMapa[])res.get((int)i))[0].xEast;
                puntosTemp[1].xEast += ((PuntoCalibracionMapa[])res.get((int)i))[1].xEast;
                puntosTemp[2].xEast += ((PuntoCalibracionMapa[])res.get((int)i))[2].xEast;
                puntosTemp[3].xEast += ((PuntoCalibracionMapa[])res.get((int)i))[3].xEast;
                puntosTemp[0].yNorth += ((PuntoCalibracionMapa[])res.get((int)i))[0].yNorth;
                puntosTemp[1].yNorth += ((PuntoCalibracionMapa[])res.get((int)i))[1].yNorth;
                puntosTemp[2].yNorth += ((PuntoCalibracionMapa[])res.get((int)i))[2].yNorth;
                puntosTemp[3].yNorth += ((PuntoCalibracionMapa[])res.get((int)i))[3].yNorth;
            }
            puntosTemp[0].xEast /= (double)cont;
            puntosTemp[1].xEast /= (double)cont;
            puntosTemp[2].xEast /= (double)cont;
            puntosTemp[3].xEast /= (double)cont;
            puntosTemp[0].yNorth /= (double)cont;
            puntosTemp[1].yNorth /= (double)cont;
            puntosTemp[2].yNorth /= (double)cont;
            puntosTemp[3].yNorth /= (double)cont;
        }
        LatLonPointImpl ppp = proyeccion.projToLatLon(puntosTemp[0].xEast, puntosTemp[0].yNorth);
        puntosTemp[0].xLon = ppp.getLongitude();
        puntosTemp[0].yLat = ppp.getLatitude();
        ppp = proyeccion.projToLatLon(puntosTemp[1].xEast, puntosTemp[1].yNorth);
        puntosTemp[1].xLon = ppp.getLongitude();
        puntosTemp[1].yLat = ppp.getLatitude();
        ppp = proyeccion.projToLatLon(puntosTemp[2].xEast, puntosTemp[2].yNorth);
        puntosTemp[2].xLon = ppp.getLongitude();
        puntosTemp[2].yLat = ppp.getLatitude();
        ppp = proyeccion.projToLatLon(puntosTemp[3].xEast, puntosTemp[3].yNorth);
        puntosTemp[3].xLon = ppp.getLongitude();
        puntosTemp[3].yLat = ppp.getLatitude();
        mc.puntosCalUser.clear();
        mc.puntosCalUser.add(puntosTemp[0]);
        mc.puntosCalUser.add(puntosTemp[1]);
        mc.puntosCalUser.add(puntosTemp[2]);
        mc.puntosCalUser.add(puntosTemp[3]);
        return CalibradorMapa.calibraWGS84Geo(mc);
    }

    public static MapaOruxMaps calibraWGS84Geo(MapaOruxMaps mc) throws Exception {
        if (CalibradorMapa.coodenadasEsquinasOk(mc, mc.puntosCalUser)) {
            LatLonPointImpl gpTL = new LatLonPointImpl(mc.puntosCalUser.get((int)0).yLat, mc.puntosCalUser.get((int)0).xLon, 0.0);
            LatLonPointImpl gpTR = new LatLonPointImpl(mc.puntosCalUser.get((int)2).yLat, mc.puntosCalUser.get((int)2).xLon, 0.0);
            LatLonPointImpl gpBL = new LatLonPointImpl(mc.puntosCalUser.get((int)3).yLat, mc.puntosCalUser.get((int)3).xLon, 0.0);
            LatLonPointImpl gpBR = new LatLonPointImpl(mc.puntosCalUser.get((int)1).yLat, mc.puntosCalUser.get((int)1).xLon, 0.0);
            LatLonPoint gp2TL = DatumtoWGS84.transform(gpTL, mc.datum);
            LatLonPoint gp2TR = DatumtoWGS84.transform(gpTR, mc.datum);
            LatLonPoint gp2BL = DatumtoWGS84.transform(gpBL, mc.datum);
            LatLonPoint gp2BR = DatumtoWGS84.transform(gpBR, mc.datum);
            for (int i = 0; i < 4; ++i) {
                mc.puntosCalibracionFinales[i] = new PuntoCalibracionMapa();
            }
            mc.puntosCalibracionFinales[0].xLon = gp2TL.getLongitude();
            mc.puntosCalibracionFinales[0].yLat = gp2TL.getLatitude();
            mc.puntosCalibracionFinales[2].xLon = gp2TR.getLongitude();
            mc.puntosCalibracionFinales[2].yLat = gp2TR.getLatitude();
            mc.puntosCalibracionFinales[3].xLon = gp2BL.getLongitude();
            mc.puntosCalibracionFinales[3].yLat = gp2BL.getLatitude();
            mc.puntosCalibracionFinales[1].xLon = gp2BR.getLongitude();
            mc.puntosCalibracionFinales[1].yLat = gp2BR.getLatitude();
            mc.puntosCalibracionFinales[0].x = mc.puntosCalUser.get((int)0).x;
            mc.puntosCalibracionFinales[2].x = mc.puntosCalUser.get((int)2).x;
            mc.puntosCalibracionFinales[3].x = mc.puntosCalUser.get((int)3).x;
            mc.puntosCalibracionFinales[1].x = mc.puntosCalUser.get((int)1).x;
            mc.puntosCalibracionFinales[0].y = mc.puntosCalUser.get((int)0).y;
            mc.puntosCalibracionFinales[2].y = mc.puntosCalUser.get((int)2).y;
            mc.puntosCalibracionFinales[3].y = mc.puntosCalUser.get((int)3).y;
            mc.puntosCalibracionFinales[1].y = mc.puntosCalUser.get((int)1).y;
        } else {
            CalibradorMapa.calibraWGS84GeoPuntos(mc);
        }
        mc.nivelZoom = MapaOruxMaps.nivelMejor(mc, mc.puntosCalibracionFinales);
        return mc;
    }
}

