/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.calculadora;

import oruxmapsdesktop.calculadora.Ellipsoid;

public class Datum {
    static final double WGSa = 6378137.0;
    static final double WGSb = 6356752.314245179;
    public Ellipsoid ell;
    public String datum;
    public String region;
    public double dX;
    public double dY;
    public double dZ;
    public double Rx;
    public double Ry;
    public double Rz;
    public double e;

    public Datum() {
        this.ell = Ellipsoid.WGS84Ell;
    }

    public Datum(String ell, double dX, double dY, double dZ, double Rx, double Ry, double Rz, double e) {
        this.Rx = Rx;
        this.Ry = Ry;
        this.Rz = Rz;
        this.dX = dX;
        this.dY = dY;
        this.dZ = dZ;
        this.e = e;
        this.ell = Ellipsoid.getEllipsoid(ell);
        if (this.ell == null) {
            this.ell = Ellipsoid.WGS84Ell;
        }
    }

    public double[] fromWGS84(double[] latlon, double[] res) {
        if (res == null) {
            res = new double[2];
        }
        Datum.transform(latlon, 6378137.0, 6356752.314245179, this.ell.EquatorialRadius, this.ell.PolarRadius, -this.dX, -this.dY, -this.dZ, -this.Rx, -this.Ry, -this.Rz, -this.e, res);
        return res;
    }

    public double[] toWGS84(double[] latlon, double[] res) {
        if (res == null) {
            res = new double[2];
        }
        Datum.transform(latlon, this.ell.EquatorialRadius, this.ell.PolarRadius, 6378137.0, 6356752.314245179, this.dX, this.dY, this.dZ, this.Rx, this.Ry, this.Rz, this.e, res);
        return res;
    }

    private static double[] transform(double[] from, double a0, double b0, double a1, double b1, double dx, double dy, double dz, double Rx, double Ry, double Rz, double e, double[] res) {
        if (res == null) {
            res = new double[2];
        }
        double lat = from[0] * Math.PI / 180.0;
        double lon = from[1] * Math.PI / 180.0;
        double a2 = a0 * a0;
        double b2 = b0 * b0;
        double cosLat = Math.cos(lat);
        double cosLon = Math.cos(lon);
        double sinLat = Math.sin(lat);
        double sinLon = Math.sin(lon);
        double N = a2 / Math.sqrt(a2 * cosLat * cosLat + b2 * sinLat * sinLat);
        double x = N * cosLat * cosLon;
        double y = N * cosLat * sinLon;
        double z = b2 / a2 * N * sinLat;
        double xx = dx + (1.0 + e) * (x + Rz * y - Ry * z);
        double yy = dy + (1.0 + e) * (-x * Rz + y + z * Rx);
        double zz = dz + (1.0 + e) * (x * Ry - y * Rx + z);
        double p = Math.sqrt(xx * xx + yy * yy);
        double e_2 = (a1 * a1 - b1 * b1) / (b1 * b1);
        double E_2 = (a1 * a1 - b1 * b1) / (a1 * a1);
        double pi = Math.atan(zz * a1 / (p * b1));
        double sinPi = Math.sin(pi);
        double cosPi = Math.cos(pi);
        res[0] = Math.atan((zz + e_2 * b1 * sinPi * sinPi * sinPi) / (p - E_2 * a1 * cosPi * cosPi * cosPi));
        res[1] = Math.atan(yy / xx);
        res[0] = res[0] * 57.29577951308232;
        res[1] = res[1] * 57.29577951308232;
        if (res[1] < 0.0 && from[1] > 45.0) {
            res[1] = res[1] + 180.0;
        } else if (res[1] > 0.0 && from[1] < -45.0) {
            res[1] = res[1] - 180.0;
        }
        return res;
    }

    public static class DummyDatum
    extends Datum {
        public DummyDatum() {
            this.datum = "WGS 1984";
            this.region = "Global Definition";
        }

        public double[] fromWGS84(double[] latlon, double[] res) {
            res = latlon;
            return res;
        }

        public double[] toWGS84(double[] latlon, double[] res) {
            res = latlon;
            return res;
        }
    }
}

