/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.calculadora;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import oruxmapsdesktop.calculadora.DatumData;

public class DatumAdmin {
    public static String DEFAULT_DATUM = "WGS84";
    public static int ORIGEN_OZI = 0;
    private static DatumData defaultDatum;
    private static DatumData[] datums;
    private static HashMap<String, String> ozi2Orux;
    private static HashMap<String, String> orux2Ozi;

    private static void initDatums() {
        ArrayList<DatumData> inputs = new ArrayList<DatumData>();
        try {
            BufferedReader input = new BufferedReader(new FileReader(new File("datums.txt")));
            String line = null;
            int cont = 1;
            DatumData dt = new DatumData();
            dt.datum = "DATUM:";
            dt.region = "";
            inputs.add(dt);
            line = input.readLine().trim();
            while (line != null) {
                if (!line.startsWith("#")) {
                    dt = new DatumData();
                    String[] valores = line.trim().split("\\|");
                    if (valores.length == 10) {
                        dt.datum = valores[0];
                        dt.region = valores[1];
                        dt.ellipsoid = valores[2];
                        dt.dX = Double.parseDouble(valores[3].trim());
                        dt.dY = Double.parseDouble(valores[4].trim());
                        dt.dZ = Double.parseDouble(valores[5].trim());
                        dt.Rx = Double.parseDouble(valores[6].trim()) * Math.PI / 3600.0 / 180.0;
                        dt.Ry = Double.parseDouble(valores[7].trim()) * Math.PI / 3600.0 / 180.0;
                        dt.Rz = Double.parseDouble(valores[8].trim()) * Math.PI / 3600.0 / 180.0;
                        dt.e = Double.parseDouble(valores[9].trim()) * 1.0E-6;
                        dt.indice = cont;
                    }
                    ++cont;
                    inputs.add(dt);
                }
                line = input.readLine();
            }
        }
        catch (Exception error) {
            System.out.println("ERROR--->READING DATUMS.TXT!!!!!!");
        }
        datums = new DatumData[inputs.size()];
        inputs.toArray(datums);
    }

    public static DatumData[] dameDatums() {
        if (datums == null) {
            DatumAdmin.initDatums();
        }
        return datums;
    }

    public static DatumData WGS84Datum() {
        if (defaultDatum == null) {
            defaultDatum = DatumAdmin.busca("WGS 1984", "Global Definition");
        }
        return defaultDatum;
    }

    public static int determinaDatum(String datum, int origen) {
        switch (origen) {
            case 0: {
                String dat = ozi2Orux.get(datum);
                if (dat == null) {
                    return 0;
                }
                return DatumAdmin.busca(dat);
            }
        }
        return 0;
    }

    public static int busca(String nombre) {
        if (datums == null) {
            DatumAdmin.initDatums();
        }
        if (datums == null) {
            return 0;
        }
        for (int i = 0; i < datums.length; ++i) {
            if (!nombre.equalsIgnoreCase(DatumAdmin.datums[i].datum.trim() + DatumAdmin.datums[i].region.trim())) continue;
            return i;
        }
        return 0;
    }

    public static DatumData busca(String dat, String reg) {
        if (datums == null) {
            DatumAdmin.initDatums();
        }
        if (datums == null) {
            return null;
        }
        for (int i = 0; i < datums.length; ++i) {
            if (!DatumAdmin.datums[i].datum.equals(dat) || !DatumAdmin.datums[i].region.equals(reg)) continue;
            return datums[i];
        }
        return null;
    }

    static {
        datums = null;
        ozi2Orux = new HashMap();
        orux2Ozi = new HashMap();
        try {
            BufferedReader input = new BufferedReader(new FileReader(new File("Ozi2Orux.txt")));
            String line = null;
            line = input.readLine().trim();
            while (line != null) {
                String[] valores;
                if (!line.startsWith("#") && (valores = line.trim().split("\\|")).length == 2) {
                    ozi2Orux.put(valores[0], valores[1]);
                    orux2Ozi.put(valores[1], valores[0]);
                }
                line = input.readLine();
            }
        }
        catch (Exception error) {
            System.out.println("ERROR--->READING Ozi2Orux.txt!!!!!!");
        }
    }
}

