/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.calculadora;

import oruxmapsdesktop.calculadora.DatumAdmin;
import oruxmapsdesktop.calculadora.DatumData;
import oruxmapsdesktop.calculadora.Ellipsoid;
import oruxmapsdesktop.geoloc.LatLonPoint;
import oruxmapsdesktop.geoloc.LatLonPointImpl;

public class DatumtoWGS84 {
    static final double WGSa = 6378137.0;
    static final double WGSinvf = 298.257223563;
    static final double WGSb = 6356752.314245179;

    public static LatLonPoint transform(LatLonPoint from, String datum, String region) {
        DatumData dd = DatumAdmin.busca(datum, region);
        if (dd == null) {
            return null;
        }
        return DatumtoWGS84.transform(from, dd.indice);
    }

    public static LatLonPoint transform(LatLonPoint from, int datum) {
        DatumData dd = DatumAdmin.dameDatums()[datum];
        Ellipsoid ell = Ellipsoid.getEllipsoid(dd.ellipsoid);
        if (ell == null) {
            return null;
        }
        if (dd.datum.equalsIgnoreCase("Rijksdriehoeksmeting")) {
            double f = from.getLatitude();
            double l = from.getLongitude();
            double fWgs = f + (-96.862 - 11.714 * (f - 52.0) - 0.125 * (l - 5.0)) / 100000.0;
            double lWgs = l + (-37.902 + 0.329 * (f - 52.0) - 14.667 * (l - 5.0)) / 100000.0;
            return new LatLonPointImpl(fWgs, lWgs);
        }
        return DatumtoWGS84.transform(from, ell.EquatorialRadius, ell.PolarRadius, 6378137.0, 6356752.314245179, dd.dX, dd.dY, dd.dZ, dd.Rx, dd.Ry, dd.Rz, dd.e);
    }

    public static LatLonPoint transform(LatLonPoint from, double a0, double b0, double a1, double b1, double dx, double dy, double dz, double Rx, double Ry, double Rz, double e) {
        double[] res = new double[3];
        double[] from2 = new double[]{from.getLatitude(), from.getLongitude(), from.getAltitude()};
        DatumtoWGS84.transform(from2, a0, b0, a1, b1, dx, dy, dz, Rx, Ry, Rz, e, res);
        return new LatLonPointImpl(res[0], res[1], res[2]);
    }

    public static double[] transform(double[] from, double a0, double b0, double a1, double b1, double dx, double dy, double dz, double Rx, double Ry, double Rz, double e, double[] res) {
        if (res == null) {
            res = new double[3];
        }
        double lat = from[0] * Math.PI / 180.0;
        double lon = from[1] * Math.PI / 180.0;
        double a2 = a0 * a0;
        double b2 = b0 * b0;
        double cosLat = Math.cos(lat);
        double cosLon = Math.cos(lon);
        double sinLat = Math.sin(lat);
        double sinLon = Math.sin(lon);
        double N = a2 / Math.sqrt(a2 * cosLat * cosLat + b2 * sinLat * sinLat);
        double x = (N + from[2]) * cosLat * cosLon;
        double y = (N + from[2]) * cosLat * sinLon;
        double z = (b2 / a2 * N + from[2]) * sinLat;
        double xx = dx + (1.0 + e) * (x + Rz * y - Ry * z);
        double yy = dy + (1.0 + e) * (-x * Rz + y + z * Rx);
        double zz = dz + (1.0 + e) * (x * Ry - y * Rx + z);
        double p = Math.sqrt(xx * xx + yy * yy);
        double e_2 = (a1 * a1 - b1 * b1) / (b1 * b1);
        double E_2 = (a1 * a1 - b1 * b1) / (a1 * a1);
        double pi = Math.atan(zz * a1 / (p * b1));
        double sinPi = Math.sin(pi);
        double cosPi = Math.cos(pi);
        res[0] = Math.atan((zz + e_2 * b1 * sinPi * sinPi * sinPi) / (p - E_2 * a1 * cosPi * cosPi * cosPi));
        double sinLat2 = Math.sin(res[0]);
        double cosLat2 = Math.cos(res[0]);
        res[1] = Math.atan(yy / xx);
        double N_ = a1 * a1 / Math.sqrt(a1 * a1 * cosLat2 * cosLat2 + b1 * b1 * sinLat2 * sinLat2);
        res[2] = p / cosLat2 - N_;
        res[0] = res[0] * 57.29577951308232;
        res[1] = res[1] * 57.29577951308232;
        if (res[1] < 0.0 && from[1] > 45.0) {
            res[1] = res[1] + 180.0;
        } else if (res[1] > 0.0 && from[1] < -45.0) {
            res[1] = res[1] - 180.0;
        }
        return res;
    }
}

