/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.calculadora;

public class Ellipsoid {
    public int id;
    public String ellipsoidName;
    public double EquatorialRadius;
    public double PolarRadius;
    public double eccentricitySquared;
    public double invFlatt;
    public static Ellipsoid[] ellipsoid = new Ellipsoid[]{new Ellipsoid(-1, "Placeholder", 0.0, 0.0, 0.0), new Ellipsoid(1, "Airy 1830", 6377563.396, 0.00667054, 299.3249753), new Ellipsoid(2, "Australian National", 6378160.0, 0.006694542, 298.2499973), new Ellipsoid(3, "Bessel 1841", 6377397.155, 0.006674372, 299.1528131), new Ellipsoid(4, "Bessel 1841 (Namibia)", 6377484.0, 0.006674372, 299.1528128), new Ellipsoid(5, "Clarke 1866", 6378206.4, 0.006768658, 294.9786982), new Ellipsoid(6, "Clarke 1880", 6378249.145, 0.006803511, 293.465), new Ellipsoid(7, "Everest 1830 (India)", 6377276.345, 0.006637847, 300.8017), new Ellipsoid(8, "Fischer 1960 (Mercury) ", 6378166.0, 0.006693422, 298.3), new Ellipsoid(9, "Fischer 1968", 6378150.0, 0.006693422, 298.3), new Ellipsoid(10, "GRS 1967", 6378160.0, 0.006694605, 298.2471674), new Ellipsoid(11, "GRS 80", 6378137.0, 0.00669438, 298.257222101), new Ellipsoid(12, "Helmert 1906", 6378200.0, 0.006693422, 298.3), new Ellipsoid(13, "Hough 1960", 6378270.0, 0.00672267, 297.0), new Ellipsoid(14, "International 1924", 6378388.0, 0.00672267, 297.0), new Ellipsoid(15, "Krassovsky 1940", 6378245.0, 0.006693422, 298.3), new Ellipsoid(16, "Modified Airy", 6377340.189, 0.00667054, 299.3249655), new Ellipsoid(17, "Everest 1964 (Malaysia, Singapore)", 6377304.0, 0.006637847, 300.8017), new Ellipsoid(18, "Modified Fischer 1960", 6378155.0, 0.006693422, 298.3), new Ellipsoid(19, "South American 1969", 6378160.0, 0.006694542, 298.25), new Ellipsoid(20, "WGS 60", 6378165.0, 0.006693422, 298.3), new Ellipsoid(21, "WGS 66", 6378145.0, 0.006694542, 298.2499981), new Ellipsoid(22, "WGS 72", 6378135.0, 0.006694318, 298.2599986), new Ellipsoid(23, "WGS 84", 6378137.0, 0.00669438, 298.257223563), new Ellipsoid(24, "Everest 1856 (India)", 6377301.243, 0.006637847, 300.8016947773539), new Ellipsoid(25, "Everest (Pakistan)", 6377309.613, 0.0066485848, 300.81589522323446), new Ellipsoid(26, "Indonesian 1974", 6378160.0, 0.0067058512, 298.2469988070381), new Ellipsoid(27, "Everest 1830 (1967 Definition)", 6377298.556, 0.0066378466, 300.8017)};
    public static Ellipsoid WGS84Ell = ellipsoid[23];
    private static final double GRA2RAD = Math.PI / 180;

    public static Ellipsoid getEllipsoid(String name) {
        for (int i = 0; i < ellipsoid.length; ++i) {
            if (!name.equals(Ellipsoid.ellipsoid[i].ellipsoidName)) continue;
            return ellipsoid[i];
        }
        return null;
    }

    public Ellipsoid(int Id, String name, double radius, double ecc, double invf) {
        this.id = Id;
        this.ellipsoidName = name;
        this.EquatorialRadius = radius;
        this.eccentricitySquared = ecc;
        this.invFlatt = invf;
        this.PolarRadius = radius * (1.0 - 1.0 / invf);
    }

    public double distVincenty(double lat1, double lon1, double lat2, double lon2) {
        double lambdaP;
        double sinAlpha;
        double C;
        lat1 *= Math.PI / 180;
        lat2 *= Math.PI / 180;
        double f = 1.0 / this.invFlatt;
        double b = this.PolarRadius;
        double a = this.EquatorialRadius;
        double L = (lon2 *= Math.PI / 180) - (lon1 *= Math.PI / 180);
        double U1 = Math.atan((1.0 - f) * Math.tan(lat1));
        double U2 = Math.atan((1.0 - f) * Math.tan(lat2));
        double sinU1 = Math.sin(U1);
        double cosU1 = Math.cos(U1);
        double sinU2 = Math.sin(U2);
        double cosU2 = Math.cos(U2);
        double cosSqAlpha = 0.0;
        double cosSigma = 0.0;
        double cos2SigmaM = 0.0;
        double sinSigma = 0.0;
        double sigma = 0.0;
        double lambda = L;
        double iterLimit = 100.0;
        do {
            double cosLambda;
            double sinLambda;
            if ((sinSigma = Math.sqrt(cosU2 * (sinLambda = Math.sin(lambda)) * (cosU2 * sinLambda) + (cosU1 * sinU2 - sinU1 * cosU2 * (cosLambda = Math.cos(lambda))) * (cosU1 * sinU2 - sinU1 * cosU2 * cosLambda))) == 0.0) {
                return 0.0;
            }
            cosSigma = sinU1 * sinU2 + cosU1 * cosU2 * cosLambda;
            sigma = Math.atan2(sinSigma, cosSigma);
            sinAlpha = cosU1 * cosU2 * sinLambda / sinSigma;
            cosSqAlpha = 1.0 - sinAlpha * sinAlpha;
            cos2SigmaM = cosSigma - 2.0 * sinU1 * sinU2 / cosSqAlpha;
            if (!Double.isNaN(cos2SigmaM)) continue;
            cos2SigmaM = 0.0;
        } while (Math.abs((lambda = L + (1.0 - (C = f / 16.0 * cosSqAlpha * (4.0 + f * (4.0 - 3.0 * cosSqAlpha)))) * f * sinAlpha * (sigma + C * sinSigma * (cos2SigmaM + C * cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM)))) - (lambdaP = lambda)) > 1.0E-12 && (iterLimit -= 1.0) > 0.0);
        if (iterLimit == 0.0) {
            return Double.NaN;
        }
        double uSq = cosSqAlpha * (a * a - b * b) / (b * b);
        double A = 1.0 + uSq / 16384.0 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
        double B = uSq / 1024.0 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
        double deltaSigma = B * sinSigma * (cos2SigmaM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM) - B / 6.0 * cos2SigmaM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SigmaM * cos2SigmaM)));
        double s = b * A * (sigma - deltaSigma);
        return s;
    }

    public static double bearing(double lat1, double lon1, double lat2, double lon2) {
        lat1 = Math.toRadians(lat1);
        lat2 = Math.toRadians(lat2);
        lon1 = Math.toRadians(lon1);
        lon2 = Math.toRadians(lon2);
        double res = Math.atan2(Math.sin(lon2 - lon1) * Math.cos(lat2), Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(lon2 - lon1));
        res = Math.toDegrees(res);
        return (res + 360.0) % 360.0;
    }

    public static double bearing(int x1, int y1, int x2, int y2) {
        double fi = 0.0;
        double Ax = x2 - x1;
        double Ay = y2 - y1;
        if (Ax != 0.0) {
            fi = Math.atan(Ay / Ax);
            fi = (Math.toDegrees(fi) + 360.0) % 360.0;
            fi = Ax >= 0.0 && Ay >= 0.0 ? (fi += 90.0) : (Ax <= 0.0 && Ay <= 0.0 ? (fi += 270.0) : (Ax >= 0.0 && Ay <= 0.0 ? (fi -= 270.0) : (fi -= 90.0)));
        } else {
            fi = Ay > 0.0 ? 180.0 : 0.0;
        }
        return fi;
    }
}

