/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.calculadora;

import java.util.ArrayList;
import oruxmapsdesktop.calculadora.Ellipsoid;
import oruxmapsdesktop.calculadora.PuntoCalibracionMapa;

public class MapaOruxMaps {
    public static final int TL = 0;
    public static final int BR = 1;
    public static final int TR = 2;
    public static final int BL = 3;
    public static final int MINLAT = 0;
    public static final int MAXLAT = 1;
    public static final int MINLON = 2;
    public static final int MAXLON = 3;
    public String nombreMapa;
    public String calVersion;
    public String dirImg;
    public String dirDest;
    public int altoImagen;
    public int anchoImagen;
    public double[] bounds = new double[4];
    public int imgTileAncho;
    public int imgTileAlto;
    public int numXimg;
    public int numYimg;
    public int datum;
    public int proyeccion;
    public String proyeccionData;
    public String file_ext = ".omc2";
    public int nivelZoom = 0;
    public PuntoCalibracionMapa[] puntosCalibracionFinales = new PuntoCalibracionMapa[4];
    public ArrayList<PuntoCalibracionMapa> puntosCalibracionA = new ArrayList();
    public ArrayList<PuntoCalibracionMapa> puntosCalibracionB = new ArrayList();
    public ArrayList<PuntoCalibracionMapa> puntosCalUser = new ArrayList();
    public boolean[] capas = new boolean[]{true, false, false, false, false};

    public static int nivelMejor(MapaOruxMaps mp, PuntoCalibracionMapa[] puntos) {
        double dist = Ellipsoid.WGS84Ell.distVincenty(puntos[0].yLat, puntos[0].xLon, puntos[3].yLat, puntos[3].xLon);
        double escale = dist / (double)mp.altoImagen;
        int n = 0;
        double mejor = Double.MAX_VALUE;
        for (int i = 0; i < 21; ++i) {
            double comp = Math.abs(escale - 4.0E7 / (double)(256 * (1 << i)));
            if (!(comp < mejor)) continue;
            mejor = comp;
            n = i;
        }
        return n;
    }
}

