/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.calculadora;

public class MatrixCalc {
    public static final double TOLERANCIA = 1.0E-12;

    public boolean resolver(double[][] a, double[] b, double[] x, int n) {
        boolean res = this.triangularizar(a, b, n);
        for (int i = n - 1; i >= 0; --i) {
            double sum = 0.0;
            for (int j = i + 1; j < n; ++j) {
                sum += x[j] * a[i][j];
            }
            x[i] = (b[i] - sum) / a[i][i];
        }
        return res;
    }

    public boolean triangularizar(double[][] a, double[] b, int n) {
        int i;
        for (i = 0; i < n; ++i) {
            int filmax = i;
            double max = Math.abs(a[filmax][i]);
            for (int f = i + 1; f < n; ++f) {
                if (!(Math.abs(a[f][i]) > max)) continue;
                filmax = f;
                max = Math.abs(a[f][i]);
            }
            for (int c = i; c < n; ++c) {
                double aux = a[i][c];
                a[i][c] = a[filmax][c];
                a[filmax][c] = aux;
            }
            double aux = b[i];
            b[i] = b[filmax];
            b[filmax] = aux;
            double prim = a[i][i];
            int j = i;
            while (j < n) {
                double[] dArray = a[i];
                int n2 = j++;
                dArray[n2] = dArray[n2] / prim;
            }
            int n3 = i;
            b[n3] = b[n3] / prim;
            j = i + 1;
            while (j < n) {
                prim = a[j][i];
                for (int k = i; k < n; ++k) {
                    double[] dArray = a[j];
                    int n4 = k;
                    dArray[n4] = dArray[n4] - a[i][k] * prim;
                }
                int n5 = j++;
                b[n5] = b[n5] - b[i] * prim;
            }
        }
        for (i = 0; i < n; ++i) {
            if (!Double.isNaN(a[i][i]) && !(Math.abs(a[i][i]) < 1.0E-12)) continue;
            return false;
        }
        return true;
    }
}

