/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.geoloc;

import oruxmapsdesktop.geoloc.LatLonPoint;

public class LatLonPointImpl
implements LatLonPoint {
    private double lat;
    private double lon;
    private double alt;

    public static boolean betweenLon(double lon, double lonBeg, double lonEnd) {
        lonBeg = LatLonPointImpl.lonNormal(lonBeg, lon);
        lonEnd = LatLonPointImpl.lonNormal(lonEnd, lon);
        return lon >= lonBeg && lon <= lonEnd;
    }

    public static double getClockwiseDistanceTo(double from, double to) {
        double distance;
        for (distance = to - from; distance < 0.0; distance += 360.0) {
        }
        return distance;
    }

    public static double range180(double lon) {
        return LatLonPointImpl.lonNormal(lon);
    }

    public static double lonNormal360(double lon) {
        return LatLonPointImpl.lonNormal(lon, 180.0);
    }

    public static double lonNormal(double lon, double center) {
        return center + Math.IEEEremainder(lon - center, 360.0);
    }

    public static double lonNormal(double lon) {
        if (lon < -180.0 || lon > 180.0) {
            return Math.IEEEremainder(lon, 360.0);
        }
        return lon;
    }

    public static double latNormal(double lat) {
        if (lat < -90.0) {
            return -90.0;
        }
        if (lat > 90.0) {
            return 90.0;
        }
        return lat;
    }

    public LatLonPointImpl() {
        this(0.0, 0.0);
    }

    public LatLonPointImpl(LatLonPoint pt) {
        this(pt.getLatitude(), pt.getLongitude());
    }

    public LatLonPointImpl(double lat, double lon) {
        this.setLatitude(lat);
        this.setLongitude(lon);
    }

    public LatLonPointImpl(double lat, double lon, double alt) {
        this.setLatitude(lat);
        this.setLongitude(lon);
        this.setAltitude(alt);
    }

    public double getLongitude() {
        return this.lon;
    }

    public double getLatitude() {
        return this.lat;
    }

    public double getAltitude() {
        return this.alt;
    }

    public void set(LatLonPoint pt) {
        this.setLongitude(pt.getLongitude());
        this.setLatitude(pt.getLatitude());
        this.setAltitude(pt.getAltitude());
    }

    public void set(double lat, double lon) {
        this.setLongitude(lon);
        this.setLatitude(lat);
    }

    public void set(float lat, float lon) {
        this.setLongitude(lon);
        this.setLatitude(lat);
    }

    public void setLongitude(double lon) {
        this.lon = LatLonPointImpl.lonNormal(lon);
    }

    public void setLatitude(double lat) {
        this.lat = LatLonPointImpl.latNormal(lat);
    }

    public void setAltitude(double alt) {
        this.alt = alt;
    }
}

