/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.geoloc;

import java.util.ArrayList;
import oruxmapsdesktop.calculadora.DatumAdmin;
import oruxmapsdesktop.calculadora.Ellipsoid;
import oruxmapsdesktop.calculadora.MapaOruxMaps;
import oruxmapsdesktop.calculadora.PuntoCalibracionMapa;
import oruxmapsdesktop.geoloc.ParametrosProyeccion;
import oruxmapsdesktop.geoloc.ProjectionImpl;
import oruxmapsdesktop.geoloc.projection.AmericanPolyconicProjection;
import oruxmapsdesktop.geoloc.projection.FlatEarth;
import oruxmapsdesktop.geoloc.projection.GdcToUtmConverter;
import oruxmapsdesktop.geoloc.projection.LambertAzimutal1;
import oruxmapsdesktop.geoloc.projection.LambertConformal;
import oruxmapsdesktop.geoloc.projection.LatLonProjection;
import oruxmapsdesktop.geoloc.projection.Mercator;
import oruxmapsdesktop.geoloc.projection.RDGrid;
import oruxmapsdesktop.geoloc.projection.SwissGrid;
import oruxmapsdesktop.geoloc.projection.TransverseMercator;
import oruxmapsdesktop.geoloc.projection.UtmProjection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectionAdmin {
    public static final int ORIGEN_OZI = 0;
    public static final int PROJECTION_UNKNOW = 0;
    public static final int PROJECTION_FLAT = 1;
    public static final int PROJECTION_UTM = 2;
    public static final int PROJECTION_MERCATOR = 3;
    public static final int PROJECTION_SWISS_GRID = 4;
    public static final int PROJECTION_LONGITUDE_LATITUDE = 5;
    public static final int PROJECTION_IRISH_GRID = 6;
    public static final int PROJECTION_DUCH = 7;
    public static final int PROJECTION_LAMBERTCONFORMAL = 8;
    public static final int PROJECTION_TRANSVERSEMERCATOR = 9;
    public static final int PROJECTION_AMERICANPOLYCONIC = 10;
    public static final int PROJECTION_EQUIRECTANGULAR = 11;
    public static final int PROJECTION_LAMBERTAZIMUTAL = 12;
    public static final String[] PROJECTIONS_NAME = new String[]{"UNKNOW", "Flat Earth", "UTM", "Mercator", "(SUI) Swiss Grid", "Latitude/Longitude", "(IG) Irish Grid", "Rijksdriehoeksmeting", "LambertConformalConic", "Transverse Mercator", "American Polyconic", "Equirectangular", "(A)Lambert Azimuthual Equal Area"};
    public static final String[] PROJECTIONS_TITLE = new String[]{"UNKNOW", "FLAT EARTH", "UTM", "MERCATOR", "SWISS GRID", "LATITUDE/LONGITUDE", "IRISH GRID", "RD GRID", "LAMBERT CONFORMAL", "TRANSVERSE MERCATOR", "AMERICAN POLYCONIC", "EQUIRECTANGULAR", "LAMBERT AZIMUTAL"};

    public static int projection(String s) {
        for (int i = 0; i < PROJECTIONS_TITLE.length; ++i) {
            if (!PROJECTIONS_TITLE[i].equals(s)) continue;
            return i;
        }
        return 0;
    }

    public static ProjectionImpl getProjection(MapaOruxMaps mc) {
        ProjectionImpl res = null;
        Ellipsoid ellips = Ellipsoid.getEllipsoid(DatumAdmin.dameDatums()[mc.datum].ellipsoid);
        ParametrosProyeccion params = new ParametrosProyeccion();
        if (mc.proyeccion == 2) {
            int zona = Integer.parseInt(mc.proyeccionData);
            for (int i = 0; i < mc.puntosCalUser.size(); ++i) {
                if (!Double.isNaN(mc.puntosCalUser.get((int)i).xEast)) {
                    Object[] o = new Object[]{new Double(ellips.EquatorialRadius), new Double(1.0 / ellips.invFlatt), zona, new Boolean(mc.puntosCalUser.get((int)i).northing)};
                    params.param = o;
                } else {
                    if (Double.isNaN(mc.puntosCalUser.get((int)i).xLon)) continue;
                    Object[] o = new Object[]{new Double(ellips.EquatorialRadius), new Double(1.0 / ellips.invFlatt), GdcToUtmConverter.recalculaZona(mc.puntosCalUser.get((int)i).xLon), mc.puntosCalUser.get((int)i).yLat >= 0.0};
                    params.param = o;
                }
                break;
            }
        } else if (mc.proyeccion == 8) {
            String[] parse = mc.proyeccionData.split(",");
            if (parse.length != 6) {
                return null;
            }
            double par1 = Double.parseDouble(parse[2]);
            double par2 = Double.parseDouble(parse[3]);
            double lon0 = Double.parseDouble(parse[1]);
            double lat0 = Double.parseDouble(parse[0]);
            double false_E = Double.parseDouble(parse[4]);
            double false_N = Double.parseDouble(parse[5]);
            Object[] o = new Object[]{ellips, lat0, lon0, par1, par2, false_E, false_N};
            params.param = o;
        } else if (mc.proyeccion == 9) {
            String[] parse = mc.proyeccionData.split(",");
            if (parse.length != 5) {
                return null;
            }
            double k = Double.parseDouble(parse[2]);
            double lon0 = Double.parseDouble(parse[0]);
            double lat0 = Double.parseDouble(parse[1]);
            double false_E = Double.parseDouble(parse[3]);
            double false_N = Double.parseDouble(parse[4]);
            Object[] o = new Object[]{ellips, lon0, lat0, k, false_E, false_N};
            params.param = o;
        } else if (mc.proyeccion == 10) {
            String[] parse = mc.proyeccionData.split(",");
            if (parse.length != 3) {
                return null;
            }
            double lon0 = Double.parseDouble(parse[0]);
            double lat0 = 0.0;
            double false_E = Double.parseDouble(parse[1]);
            double false_N = Double.parseDouble(parse[2]);
            Object[] o = new Object[]{ellips, lon0, lat0, false_E, false_N};
            params.param = o;
        } else if (mc.proyeccion == 12) {
            String[] parse = mc.proyeccionData.split(",");
            if (parse.length != 2) {
                return null;
            }
            double lon0 = Double.parseDouble(parse[0]);
            double lat0 = Double.parseDouble(parse[1]);
            Object[] o = new Object[]{ellips, lon0, lat0};
            params.param = o;
        } else if (mc.proyeccion == 1) {
            PuntoCalibracionMapa[] puntos = new PuntoCalibracionMapa[2];
            for (int i = 0; i < mc.puntosCalUser.size(); ++i) {
                if (Double.isNaN(mc.puntosCalUser.get((int)i).xLon)) continue;
                if (puntos[0] == null) {
                    puntos[0] = mc.puntosCalUser.get(i);
                    continue;
                }
                puntos[1] = mc.puntosCalUser.get(i);
                break;
            }
            double bear0 = Ellipsoid.bearing(puntos[0].yLat, puntos[0].xLon, puntos[1].yLat, puntos[1].xLon);
            double bear1 = Ellipsoid.bearing(puntos[0].x, puntos[0].y, puntos[1].x, puntos[1].y);
            Object[] o = new Object[]{puntos[0].yLat, puntos[0].xLon, bear1 - bear0};
            params.param = o;
        } else if (mc.proyeccion == 11) {
            params = new ParametrosProyeccion();
            Object[] o = new Object[]{Double.parseDouble(mc.proyeccionData)};
            params.param = o;
        } else if (mc.proyeccion == 3) {
            params = new ParametrosProyeccion();
            Object[] o = new Object[]{Double.parseDouble(mc.proyeccionData), 0.0};
            params.param = o;
        }
        res = ProjectionAdmin.dameProjectionImpl(mc.proyeccion, params);
        return res;
    }

    public static ProjectionImpl dameProjectionImpl(int proj, ParametrosProyeccion param) {
        switch (proj) {
            case 0: {
                return new FlatEarth();
            }
            case 1: {
                return new FlatEarth((Double)param.param[0], (Double)param.param[1], (Double)param.param[2]);
            }
            case 2: {
                return new UtmProjection((Double)param.param[0], (Double)param.param[1], (Integer)param.param[2], (Boolean)param.param[3]);
            }
            case 3: {
                if (param.param == null) {
                    return new Mercator(0.0, 0.0);
                }
                return new Mercator((Double)param.param[0], (Double)param.param[1]);
            }
            case 4: {
                return new SwissGrid();
            }
            case 5: {
                return new LatLonProjection(0.0);
            }
            case 6: {
                return new TransverseMercator(new Ellipsoid(16, "Modified Airy", 6377340.0, 0.00667054, 299.3249646), Math.toRadians(-8.0), Math.toRadians(53.5), 1.000035, 200000.0, 250000.0);
            }
            case 7: {
                return new RDGrid();
            }
            case 8: {
                return new LambertConformal((Ellipsoid)param.param[0], (Double)param.param[1], (Double)param.param[2], (Double)param.param[3], (Double)param.param[4], (Double)param.param[5], (Double)param.param[6]);
            }
            case 9: {
                return new TransverseMercator((Ellipsoid)param.param[0], Math.toRadians((Double)param.param[1]), Math.toRadians((Double)param.param[2]), (Double)param.param[3], (Double)param.param[4], (Double)param.param[5]);
            }
            case 10: {
                return new AmericanPolyconicProjection((Ellipsoid)param.param[0], Math.toRadians((Double)param.param[1]), Math.toRadians((Double)param.param[2]), (Double)param.param[3], (Double)param.param[4]);
            }
            case 11: {
                return new LatLonProjection((Double)param.param[0]);
            }
            case 12: {
                return new LambertAzimutal1((Ellipsoid)param.param[0], (Double)param.param[1], (Double)param.param[2]);
            }
        }
        return null;
    }

    public static String parametriza(int proj, String entrada, ArrayList<PuntoCalibracionMapa> puntos) {
        String salida = "";
        switch (proj) {
            case 8: {
                String[] datos = entrada.split(",");
                try {
                    if (datos[1].equals("")) {
                        datos[1] = String.valueOf((Double.parseDouble(datos[6].trim()) + Double.parseDouble(datos[7].trim())) / 2.0);
                    }
                    if (datos[4].equals("")) {
                        datos[4] = "0.0";
                    }
                    if (datos[5].equals("")) {
                        datos[5] = "0.0";
                    }
                    salida = datos[1].trim() + "," + datos[2].trim() + "," + datos[6].trim() + "," + datos[7].trim() + "," + datos[4].trim() + "," + datos[5].trim();
                }
                catch (Exception e) {
                    salida = "";
                }
                break;
            }
            case 9: {
                String[] datos = entrada.split(",");
                try {
                    if (datos[1].trim().length() < 0 || datos[2].trim().length() < 0 || datos[3].trim().length() < 0 || datos[4].trim().length() < 0 || datos[5].trim().length() < 0) break;
                    salida = datos[2].trim() + "," + datos[1].trim() + "," + datos[3].trim() + "," + datos[4].trim() + "," + datos[5].trim();
                }
                catch (Exception e) {
                    salida = "";
                }
                break;
            }
            case 12: {
                String[] datos = entrada.split(",");
                try {
                    if (datos[1].trim().length() < 0 || datos[2].trim().length() < 0) break;
                    salida = datos[2].trim() + "," + datos[1].trim();
                }
                catch (Exception e) {
                    salida = "";
                }
                break;
            }
            case 2: {
                for (PuntoCalibracionMapa p : puntos) {
                    if (p == null) continue;
                    if (!Double.isNaN(p.xEast)) {
                        return p.grid;
                    }
                    if (Double.isNaN(p.xLon)) continue;
                    return String.valueOf(GdcToUtmConverter.recalculaZona(p.xLon));
                }
                break;
            }
            case 3: {
                salida = "0.0";
                break;
            }
        }
        return salida;
    }

    public static int determinaProjection(String proj, String data, int origen) {
        switch (origen) {
            case 0: {
                if (proj.equals("(UTM) Universal Transverse Mercator")) {
                    return 2;
                }
                if (proj.equals("Mercator")) {
                    return 3;
                }
                if (proj.equals("(SUI) Swiss Grid")) {
                    return 4;
                }
                if (proj.equals("Latitude/Longitude")) {
                    return 5;
                }
                if (proj.equals("(IG) Irish Grid")) {
                    return 6;
                }
                if (proj.equals("(A)Lambert Azimuthual Equal Area")) {
                    return 12;
                }
                if (proj.equals("Transverse Mercator")) {
                    String[] datos = data.split(",");
                    if (datos.length >= 6 && datos[1].trim().startsWith("0") && datos[2].trim().startsWith("5.38763") && datos[4].trim().startsWith("155000")) {
                        return 7;
                    }
                    if (datos[1].trim().length() >= 0 && datos[2].trim().length() >= 0 && datos[3].trim().length() >= 0 && datos[4].trim().length() >= 0 && datos[5].trim().length() >= 0) {
                        return 9;
                    }
                    return 0;
                }
                if (proj.equals("Lambert Conformal Conic")) {
                    return 8;
                }
                return 0;
            }
            case 1: {
                if (proj.equals("Mercator")) {
                    return 3;
                }
                if (proj.equals("Longitude/Latitude")) {
                    return 5;
                }
                if (proj.equals("Transverse Mercator")) {
                    return 9;
                }
                if (proj.startsWith("Lambert Conformal Conic")) {
                    return 8;
                }
                return 0;
            }
        }
        return 0;
    }
}

