/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.geoloc.projection;

import oruxmapsdesktop.calculadora.Ellipsoid;
import oruxmapsdesktop.geoloc.LatLonPoint;
import oruxmapsdesktop.geoloc.LatLonPointImpl;
import oruxmapsdesktop.geoloc.ParametrosProyeccion;
import oruxmapsdesktop.geoloc.ProjectionImpl;
import oruxmapsdesktop.geoloc.ProjectionPoint;
import oruxmapsdesktop.geoloc.ProjectionPointImpl;

public class AmericanPolyconicProjection
extends ProjectionImpl {
    private double ml0;
    private double[] en;
    private double projectionLatitude = 0.0;
    private double projectionLongitude = 0.0;
    private double falseEasting = 0.0;
    private double falseNorthing = 0.0;
    private double a = 0.0;
    private double e = 0.0;
    private double es = 0.0;
    private double fromMetres = 1.0;
    private double totalScale = 0.0;
    private double totalFalseEasting = 0.0;
    private double totalFalseNorthing = 0.0;
    private static final double RTD = 57.29577951308232;
    private static final double DTR = Math.PI / 180;
    private static final double EPSILON = 1.0E-10;
    private static final int MAXIMUM_ITERATIONS = 20;
    private static final double ITERATION_TOLERANCE = 1.0E-12;
    public static final double HALFPI = 1.5707963267948966;
    public static final double QUARTERPI = 0.7853981633974483;
    public static final double TWOPI = Math.PI * 2;
    private static final double C00 = 1.0;
    private static final double C02 = 0.25;
    private static final double C04 = 0.046875;
    private static final double C06 = 0.01953125;
    private static final double C08 = 0.01068115234375;
    private static final double C22 = 0.75;
    private static final double C44 = 0.46875;
    private static final double C46 = 0.013020833333333334;
    private static final double C48 = 0.007120768229166667;
    private static final double C66 = 0.3645833333333333;
    private static final double C68 = 0.005696614583333333;
    private static final double C88 = 0.3076171875;

    public AmericanPolyconicProjection() {
        this(Ellipsoid.WGS84Ell, 0.0, 0.0, 0.0, 0.0);
    }

    public AmericanPolyconicProjection(ParametrosProyeccion params) {
        this(params.ell, params.lon_or, params.lat_or, params.falso_este, params.falso_norte);
    }

    public AmericanPolyconicProjection(Ellipsoid ellipsoid, double lon_0, double lat_0, double x_0, double y_0) {
        this.requiereConversionDatum = false;
        this.name = "American Polyconic";
        this.tieneParametros = true;
        this.setEllipsoid(ellipsoid);
        this.projectionLongitude = lon_0;
        this.projectionLatitude = lat_0;
        this.falseEasting = x_0;
        this.falseNorthing = y_0;
        this.initialize();
    }

    private void setEllipsoid(Ellipsoid ellipsoid) {
        this.a = ellipsoid.EquatorialRadius;
        this.e = Math.sqrt(ellipsoid.eccentricitySquared);
        this.es = this.e * this.e;
    }

    private static double normalizeLongitude(double angle) {
        if (Double.isInfinite(angle) || Double.isNaN(angle)) {
            return 0.0;
        }
        while (angle > Math.PI) {
            angle -= Math.PI * 2;
        }
        while (angle < -Math.PI) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    private static double[] enfn(double es) {
        double[] en = new double[5];
        en[0] = 1.0 - es * (0.25 + es * (0.046875 + es * (0.01953125 + es * 0.01068115234375)));
        en[1] = es * (0.75 - es * (0.046875 + es * (0.01953125 + es * 0.01068115234375)));
        double t = es * es;
        en[2] = t * (0.46875 - es * (0.013020833333333334 + es * 0.007120768229166667));
        en[3] = (t *= es) * (0.3645833333333333 - es * 0.005696614583333333);
        en[4] = t * es * 0.3076171875;
        return en;
    }

    private static double mlfn(double phi, double sphi, double cphi, double[] en) {
        cphi *= sphi;
        sphi *= sphi;
        return en[0] * phi - cphi * (en[1] + sphi * (en[2] + sphi * (en[3] + sphi * en[4])));
    }

    private void initialize() {
        this.totalScale = this.a * this.fromMetres;
        this.totalFalseEasting = this.falseEasting * this.fromMetres;
        this.totalFalseNorthing = this.falseNorthing * this.fromMetres;
        this.en = AmericanPolyconicProjection.enfn(this.es);
        this.ml0 = AmericanPolyconicProjection.mlfn(this.projectionLatitude, Math.sin(this.projectionLatitude), Math.cos(this.projectionLatitude), this.en);
    }

    private static double asin(double v) {
        if (Math.abs(v) > 1.0) {
            return v < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        }
        return Math.asin(v);
    }

    private double msfn(double s, double c) {
        return c / Math.sqrt(1.0 - s * s * this.es);
    }

    private double[] project(double lam, double phi, double[] xy) {
        double y;
        double x;
        if (Math.abs(phi) <= 1.0E-10) {
            x = lam;
            y = -this.ml0;
        } else {
            double d;
            double sp = Math.sin(phi);
            double cp = Math.cos(phi);
            double ms = Math.abs(d) > 1.0E-10 ? this.msfn(sp, cp) / sp : 0.0;
            x = ms * Math.sin(lam *= sp);
            y = AmericanPolyconicProjection.mlfn(phi, sp, cp, this.en) - this.ml0 + ms * (1.0 - Math.cos(lam));
        }
        xy[0] = x;
        xy[1] = y;
        return xy;
    }

    private double[] projectInverse(double x, double y, double[] outs) {
        double phi;
        double lam;
        if (Math.abs(y += this.ml0) <= 1.0E-10) {
            lam = x;
            phi = 0.0;
        } else {
            double r = y * y + x * x;
            phi = y;
            for (int i = 0; i <= 20; ++i) {
                double mlb;
                double sp = Math.sin(phi);
                double cp = Math.cos(phi);
                double s2ph = sp * cp;
                double mlp = Math.sqrt(1.0 - this.es * sp * sp);
                double c = sp * mlp / cp;
                double ml = AmericanPolyconicProjection.mlfn(phi, sp, cp, this.en);
                double dPhi = (ml + ml + c * (mlb = ml * ml + r) - 2.0 * y * (c * ml + 1.0)) / (this.es * s2ph * (mlb - 2.0 * y * ml) / c + 2.0 * (y - ml) * (c * (mlp = (1.0 - this.es) / (mlp * mlp * mlp)) - 1.0 / s2ph) - mlp - mlp);
                if (Math.abs(dPhi) <= 1.0E-12) break;
                phi += dPhi;
            }
            double c = Math.sin(phi);
            lam = AmericanPolyconicProjection.asin(x * Math.tan(phi) * Math.sqrt(1.0 - this.es * c * c)) / c;
        }
        outs[0] = lam;
        outs[1] = phi;
        return outs;
    }

    public ProjectionPoint latLonToProj(LatLonPoint latlon, ProjectionPointImpl destPoint) {
        double x = latlon.getLongitude() * (Math.PI / 180);
        if (this.projectionLongitude != 0.0) {
            x = AmericanPolyconicProjection.normalizeLongitude(x - this.projectionLongitude);
        }
        double[] dst = this.project(x, latlon.getLatitude() * (Math.PI / 180), new double[2]);
        dst[0] = this.totalScale * dst[0] + this.totalFalseEasting;
        dst[1] = this.totalScale * dst[1] + this.totalFalseNorthing;
        return new ProjectionPointImpl(dst[0], dst[1]);
    }

    public LatLonPoint projToLatLon(ProjectionPoint ppt, LatLonPointImpl destPoint) {
        double y;
        double x = (ppt.getX() - this.totalFalseEasting) / this.totalScale;
        double[] dst = this.projectInverse(x, y = (ppt.getY() - this.totalFalseNorthing) / this.totalScale, new double[2]);
        if (dst[0] < -Math.PI) {
            dst[0] = -Math.PI;
        } else if (dst[0] > Math.PI) {
            dst[0] = Math.PI;
        }
        if (this.projectionLongitude != 0.0) {
            dst[0] = AmericanPolyconicProjection.normalizeLongitude(dst[0] + this.projectionLongitude);
        }
        dst[1] = dst[1] * 57.29577951308232;
        dst[0] = dst[0] * 57.29577951308232;
        return new LatLonPointImpl(dst[1], dst[0]);
    }
}

