/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.geoloc.projection;

import oruxmapsdesktop.geoloc.LatLonPoint;
import oruxmapsdesktop.geoloc.LatLonPointImpl;
import oruxmapsdesktop.geoloc.ParametrosProyeccion;
import oruxmapsdesktop.geoloc.ProjectionImpl;
import oruxmapsdesktop.geoloc.ProjectionPoint;
import oruxmapsdesktop.geoloc.ProjectionPointImpl;

public class EquirectangularProjection
extends ProjectionImpl {
    private double centerLon = 0.0;
    private double std_parallel = 0.0;
    private double factor = 1.0;

    public EquirectangularProjection(double centerLon, double stdParallel) {
        this.centerLon = centerLon;
        this.std_parallel = stdParallel;
        this.factor = Math.cos(stdParallel);
        this.requiereConversionDatum = false;
        this.name = "Equirectangular";
        this.tieneParametros = true;
    }

    public EquirectangularProjection() {
        this(0.0, 0.0);
    }

    public EquirectangularProjection(ParametrosProyeccion params) {
        this(params.lon_or, params.lat_or);
    }

    public ProjectionPoint latLonToProj(LatLonPoint latlon, ProjectionPointImpl result) {
        result.setLocation(LatLonPointImpl.lonNormal(latlon.getLongitude(), this.centerLon) * this.factor, latlon.getLatitude());
        return result;
    }

    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        result.setLongitude(LatLonPointImpl.lonNormal(world.getX() / this.factor + this.centerLon));
        result.setLatitude(world.getY());
        return result;
    }

    public double setCenterLon(double centerLon) {
        this.centerLon = LatLonPointImpl.lonNormal(centerLon);
        return this.centerLon;
    }

    public double getCenterLon() {
        return this.centerLon;
    }
}

