/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.geoloc.projection;

import oruxmapsdesktop.geoloc.LatLonPoint;
import oruxmapsdesktop.geoloc.LatLonPointImpl;
import oruxmapsdesktop.geoloc.ParametrosProyeccion;
import oruxmapsdesktop.geoloc.ProjectionImpl;
import oruxmapsdesktop.geoloc.ProjectionPoint;
import oruxmapsdesktop.geoloc.ProjectionPointImpl;

public class FlatEarth
extends ProjectionImpl {
    private double rotAngle;
    private double lat0;
    private double lon0;
    private double cosRot;
    private double sinRot;
    private LatLonPointImpl origin;
    private double radius = 6371.229;

    public FlatEarth() {
        this(0.0, 0.0, 0.0);
    }

    public FlatEarth(double lat0, double lon0, double rotAngle) {
        this.requiereConversionDatum = false;
        this.name = "Flat Earth";
        this.tieneParametros = false;
        this.lat0 = Math.toRadians(lat0);
        this.lon0 = Math.toRadians(lon0);
        this.rotAngle = Math.toRadians(rotAngle);
        this.origin = new LatLonPointImpl(lat0, lon0);
        this.precalculate();
    }

    public FlatEarth(ParametrosProyeccion params) {
        this(params.lat_or, params.lon_or, params.giro);
    }

    public FlatEarth(double lat0, double lon0) {
        this.lat0 = Math.toRadians(lat0);
        this.lon0 = Math.toRadians(lon0);
        this.rotAngle = Math.toRadians(0.0);
        this.origin = new LatLonPointImpl(lat0, lon0);
        this.precalculate();
    }

    private void precalculate() {
        this.sinRot = Math.sin(this.rotAngle);
        this.cosRot = Math.cos(this.rotAngle);
    }

    public double getOriginLon() {
        return this.origin.getLongitude();
    }

    public void setOriginLon(double lon) {
        this.origin.setLongitude(lon);
        this.lon0 = Math.toRadians(lon);
        this.precalculate();
    }

    public double getOriginLat() {
        return this.origin.getLatitude();
    }

    public double getRotationAngle() {
        return this.rotAngle;
    }

    public void setOriginLat(double lat) {
        this.origin.setLatitude(lat);
        this.lat0 = Math.toRadians(lat);
        this.precalculate();
    }

    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        fromLat = Math.toRadians(fromLat);
        double dy = this.radius * (fromLat - this.lat0);
        double dx = this.radius * Math.cos(fromLat) * (Math.toRadians(fromLon) - this.lon0);
        double toX = this.cosRot * dx - this.sinRot * dy;
        double toY = this.sinRot * dx + this.cosRot * dy;
        result.setLocation(toX, toY);
        return result;
    }

    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double x = world.getX();
        double y = world.getY();
        double xp = this.cosRot * x + this.sinRot * y;
        double yp = -this.sinRot * x + this.cosRot * y;
        double toLat = Math.toDegrees(this.lat0) + Math.toDegrees(yp / this.radius);
        double cosl = Math.cos(Math.toRadians(toLat));
        double toLon = Math.abs(cosl) < 1.0E-6 ? Math.toDegrees(this.lon0) : Math.toDegrees(this.lon0) + Math.toDegrees(xp / cosl / this.radius);
        toLon = LatLonPointImpl.lonNormal(toLon);
        result.setLatitude(toLat);
        result.setLongitude(toLon);
        return result;
    }
}

