/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.geoloc.projection;

import oruxmapsdesktop.calculadora.Ellipsoid;
import oruxmapsdesktop.geoloc.LatLonPoint;
import oruxmapsdesktop.geoloc.LatLonPointImpl;
import oruxmapsdesktop.geoloc.ProjectionPoint;
import oruxmapsdesktop.geoloc.ProjectionPointImpl;

public class GdcToUtmConverter {
    static double pi = 3.14159265358979;
    static double UTMScaleFactor = 0.9996;
    static final double RADIANS_PER_DEGREE = Math.PI / 180;
    static final double DEGREES_PER_RADIAN = 57.29577951308232;
    private int zone;
    private boolean isNorth;
    private double sm_a;
    private double sm_b;
    private double F;
    private double ep2;
    private double alpha;
    private double beta;
    private double gamma;
    private double delta;
    private double epsilon;
    private double n;
    private double beta_;
    private double gamma_;
    private double delta_;
    private double epsilon_;
    private double coefT1;

    public GdcToUtmConverter(double a, double f, int zone, boolean hemisphere_north) {
        this.init(a, f, zone, hemisphere_north);
    }

    public GdcToUtmConverter(Ellipsoid ellipse, int zone, boolean isNorth) {
        this.init(ellipse.EquatorialRadius, 1.0 / ellipse.invFlatt, zone, isNorth);
    }

    protected void init(double a, double f, int zone, boolean isNorth) {
        this.sm_a = a;
        this.sm_b = a - a * f;
        this.zone = zone;
        this.isNorth = isNorth;
        this.F = 1.0 / f;
        this.n = (this.sm_a - this.sm_b) / (this.sm_a + this.sm_b);
        this.ep2 = (Math.pow(this.sm_a, 2.0) - Math.pow(this.sm_b, 2.0)) / Math.pow(this.sm_b, 2.0);
        this.alpha = (this.sm_a + this.sm_b) / 2.0 * (1.0 + Math.pow(this.n, 2.0) / 4.0 + Math.pow(this.n, 4.0) / 64.0);
        this.beta = -3.0 * this.n / 2.0 + 9.0 * Math.pow(this.n, 3.0) / 16.0 + -3.0 * Math.pow(this.n, 5.0) / 32.0;
        this.gamma = 15.0 * Math.pow(this.n, 2.0) / 16.0 + -15.0 * Math.pow(this.n, 4.0) / 32.0;
        this.delta = -35.0 * Math.pow(this.n, 3.0) / 48.0 + 105.0 * Math.pow(this.n, 5.0) / 256.0;
        this.epsilon = 315.0 * Math.pow(this.n, 4.0) / 512.0;
        this.beta_ = 3.0 * this.n / 2.0 + -27.0 * Math.pow(this.n, 3.0) / 32.0 + 269.0 * Math.pow(this.n, 5.0) / 512.0;
        this.gamma_ = 21.0 * Math.pow(this.n, 2.0) / 16.0 + -55.0 * Math.pow(this.n, 4.0) / 32.0;
        this.delta_ = 151.0 * Math.pow(this.n, 3.0) / 96.0 + -417.0 * Math.pow(this.n, 5.0) / 128.0;
        this.epsilon_ = 1097.0 * Math.pow(this.n, 4.0) / 512.0;
        this.coefT1 = Math.pow(this.sm_a, 2.0) / this.sm_b;
    }

    public double getA() {
        return this.sm_a;
    }

    public double getF() {
        return this.F;
    }

    public int getZone() {
        return this.zone;
    }

    public boolean isNorth() {
        return this.isNorth;
    }

    public LatLonPoint projToLatLon(double x, double y, LatLonPointImpl latlon) {
        double[] res = this.UTMXYToLatLon(x, y, this.zone, !this.isNorth);
        latlon.set(res[0], res[1]);
        return latlon;
    }

    public ProjectionPoint latLonToProj(double latitude, double longitude, ProjectionPointImpl result) {
        double[] res = this.LatLonToUTMXY(latitude, longitude, this.zone);
        result.x = res[0];
        result.y = res[1];
        return result;
    }

    double DegToRad(double deg) {
        return deg * (Math.PI / 180);
    }

    double RadToDeg(double rad) {
        return rad * 57.29577951308232;
    }

    double ArcLengthOfMeridian(double phi) {
        return this.alpha * (phi + this.beta * Math.sin(2.0 * phi) + this.gamma * Math.sin(4.0 * phi) + this.delta * Math.sin(6.0 * phi) + this.epsilon * Math.sin(8.0 * phi));
    }

    double UTMCentralMeridian(int zone) {
        return this.DegToRad(-183.0 + (double)zone * 6.0);
    }

    double FootpointLatitude(double y) {
        double y_ = y / this.alpha;
        return y_ + this.beta_ * Math.sin(2.0 * y_) + this.gamma_ * Math.sin(4.0 * y_) + this.delta_ * Math.sin(6.0 * y_) + this.epsilon_ * Math.sin(8.0 * y_);
    }

    double[] MapLatLonToXY(double phi, double lambda, double lambda0) {
        double[] xy = new double[2];
        double cosPhi = Math.cos(phi);
        double nu2 = this.ep2 * Math.pow(cosPhi, 2.0);
        double N = this.coefT1 / Math.sqrt(1.0 + nu2);
        double t = Math.tan(phi);
        double t2 = t * t;
        double l = lambda - lambda0;
        double l3coef = 1.0 - t2 + nu2;
        double l4coef = 5.0 - t2 + 9.0 * nu2 + 4.0 * (nu2 * nu2);
        double l5coef = 5.0 - 18.0 * t2 + t2 * t2 + 14.0 * nu2 - 58.0 * t2 * nu2;
        double l6coef = 61.0 - 58.0 * t2 + t2 * t2 + 270.0 * nu2 - 330.0 * t2 * nu2;
        double l7coef = 61.0 - 479.0 * t2 + 179.0 * (t2 * t2) - t2 * t2 * t2;
        double l8coef = 1385.0 - 3111.0 * t2 + 543.0 * (t2 * t2) - t2 * t2 * t2;
        xy[0] = N * cosPhi * l + N / 6.0 * Math.pow(cosPhi, 3.0) * l3coef * Math.pow(l, 3.0) + N / 120.0 * Math.pow(cosPhi, 5.0) * l5coef * Math.pow(l, 5.0) + N / 5040.0 * Math.pow(cosPhi, 7.0) * l7coef * Math.pow(l, 7.0);
        xy[1] = this.ArcLengthOfMeridian(phi) + t / 2.0 * N * Math.pow(cosPhi, 2.0) * Math.pow(l, 2.0) + t / 24.0 * N * Math.pow(cosPhi, 4.0) * l4coef * Math.pow(l, 4.0) + t / 720.0 * N * Math.pow(cosPhi, 6.0) * l6coef * Math.pow(l, 6.0) + t / 40320.0 * N * Math.pow(cosPhi, 8.0) * l8coef * Math.pow(l, 8.0);
        return xy;
    }

    double[] MapXYToLatLon(double x, double y, double lambda0) {
        double Nf;
        double[] philambda = new double[2];
        double phif = this.FootpointLatitude(y);
        double cf = Math.cos(phif);
        double nuf2 = this.ep2 * Math.pow(cf, 2.0);
        double Nfpow = Nf = this.coefT1 / Math.sqrt(1.0 + nuf2);
        double tf = Math.tan(phif);
        double tf2 = tf * tf;
        double tf4 = tf2 * tf2;
        double x1frac = 1.0 / (Nfpow * cf);
        double x2frac = tf / (2.0 * (Nfpow *= Nf));
        double x3frac = 1.0 / (6.0 * (Nfpow *= Nf) * cf);
        double x4frac = tf / (24.0 * (Nfpow *= Nf));
        double x5frac = 1.0 / (120.0 * (Nfpow *= Nf) * cf);
        double x6frac = tf / (720.0 * (Nfpow *= Nf));
        double x7frac = 1.0 / (5040.0 * (Nfpow *= Nf) * cf);
        double x8frac = tf / (40320.0 * (Nfpow *= Nf));
        double x2poly = -1.0 - nuf2;
        double x3poly = -1.0 - 2.0 * tf2 - nuf2;
        double x4poly = 5.0 + 3.0 * tf2 + 6.0 * nuf2 - 6.0 * tf2 * nuf2 - 3.0 * (nuf2 * nuf2) - 9.0 * tf2 * (nuf2 * nuf2);
        double x5poly = 5.0 + 28.0 * tf2 + 24.0 * tf4 + 6.0 * nuf2 + 8.0 * tf2 * nuf2;
        double x6poly = -61.0 - 90.0 * tf2 - 45.0 * tf4 - 107.0 * nuf2 + 162.0 * tf2 * nuf2;
        double x7poly = -61.0 - 662.0 * tf2 - 1320.0 * tf4 - 720.0 * (tf4 * tf2);
        double x8poly = 1385.0 + 3633.0 * tf2 + 4095.0 * tf4 + 1575.0 * (tf4 * tf2);
        philambda[0] = phif + x2frac * x2poly * (x * x) + x4frac * x4poly * Math.pow(x, 4.0) + x6frac * x6poly * Math.pow(x, 6.0) + x8frac * x8poly * Math.pow(x, 8.0);
        philambda[1] = lambda0 + x1frac * x + x3frac * x3poly * Math.pow(x, 3.0) + x5frac * x5poly * Math.pow(x, 5.0) + x7frac * x7poly * Math.pow(x, 7.0);
        return philambda;
    }

    public double[] LatLonToUTMXY(double lat, double lon, int zone) {
        lat = this.DegToRad(lat);
        lon = this.DegToRad(lon);
        double[] xy = this.MapLatLonToXY(lat, lon, this.UTMCentralMeridian(zone));
        xy[0] = xy[0] * UTMScaleFactor + 500000.0;
        xy[1] = xy[1] * UTMScaleFactor;
        if (xy[1] < 0.0) {
            xy[1] = xy[1] + 1.0E7;
        }
        return xy;
    }

    public double[] UTMXYToLatLon(double x, double y, int zone, boolean southhemi) {
        x -= 500000.0;
        x /= UTMScaleFactor;
        if (southhemi) {
            y -= 1.0E7;
        }
        double cmeridian = this.UTMCentralMeridian(zone);
        double[] latlon = this.MapXYToLatLon(x, y /= UTMScaleFactor, cmeridian);
        latlon[0] = this.RadToDeg(latlon[0]);
        latlon[1] = this.RadToDeg(latlon[1]);
        return latlon;
    }

    public static int recalculaZona(double lon) {
        return (int)(Math.floor((lon + 180.0) / 6.0) + 1.0);
    }

    public static boolean recalculaHem(double lat) {
        return lat < 0.0;
    }
}

