/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.geoloc.projection;

import oruxmapsdesktop.calculadora.Ellipsoid;
import oruxmapsdesktop.geoloc.LatLonPoint;
import oruxmapsdesktop.geoloc.LatLonPointImpl;
import oruxmapsdesktop.geoloc.ParametrosProyeccion;
import oruxmapsdesktop.geoloc.ProjectionImpl;
import oruxmapsdesktop.geoloc.ProjectionPoint;
import oruxmapsdesktop.geoloc.ProjectionPointImpl;

public class LambertAzimutal
extends ProjectionImpl {
    private static final double FINE_EPSILON = 1.0E-10;
    private static final double EPSILON = 1.0E-7;
    private static final double EPSILON_LATITUDE = 1.0E-10;
    private static final double P00 = 0.3333333333333333;
    private static final double P01 = 0.17222222222222222;
    private static final double P02 = 0.10257936507936508;
    private static final double P10 = 0.06388888888888888;
    private static final double P11 = 0.0664021164021164;
    private static final double P20 = 0.016415012942191543;
    static final int OBLIQUE = 0;
    static final int EQUATORIAL = 1;
    static final int NORTH_POLE = 2;
    static final int SOUTH_POLE = 3;
    int mode;
    private double sinb1;
    private double cosb1;
    private double xmf;
    private double ymf;
    private double qp;
    private double dd;
    private double rq;
    private double APA0;
    private double APA1;
    private double APA2;
    private double latitudeOfOrigin = 0.0;
    private double centralMeridian = 0.0;
    private double a = 0.0;
    private double e = 0.0;
    private double es = 0.0;
    private boolean spherical;
    private double fromMetres = 1.0;
    private double totalScale = 0.0;
    private double totalFalseEasting = 0.0;
    private double totalFalseNorthing = 0.0;
    private static final double RTD = 57.29577951308232;
    private static final double DTR = Math.PI / 180;
    private static final double TWOPI = Math.PI * 2;
    private static final double HALFPI = 1.5707963267948966;

    public LambertAzimutal() {
        this(Ellipsoid.WGS84Ell, 0.0, 0.0);
        this.initialize();
    }

    public LambertAzimutal(ParametrosProyeccion params) {
        this(params.ell, params.lon_or, params.lat_or);
    }

    public LambertAzimutal(Ellipsoid ellipsoid, double lon_0, double lat_0) {
        this.setEllipsoid(ellipsoid);
        this.centralMeridian = lon_0 * (Math.PI / 180);
        this.latitudeOfOrigin = lat_0 * (Math.PI / 180);
        this.requiereConversionDatum = true;
        this.name = "Lambert Azimutal";
        this.tieneParametros = true;
        this.initialize();
    }

    private void setEllipsoid(Ellipsoid ellipsoid) {
        this.a = ellipsoid.EquatorialRadius;
        this.e = Math.sqrt(ellipsoid.eccentricitySquared);
        this.es = ellipsoid.eccentricitySquared;
    }

    private static double normalizeLongitude(double angle) {
        if (Double.isInfinite(angle) || Double.isNaN(angle)) {
            return 0.0;
        }
        while (angle > Math.PI) {
            angle -= Math.PI * 2;
        }
        while (angle < -Math.PI) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    public void initialize() {
        this.spherical = this.e == 0.0;
        this.totalScale = this.a * this.fromMetres;
        double t = Math.abs(this.latitudeOfOrigin);
        this.mode = Math.abs(t - 1.5707963267948966) < 1.0E-10 ? (this.latitudeOfOrigin < 0.0 ? 3 : 2) : (Math.abs(t) < 1.0E-10 ? 1 : 0);
        double es2 = this.es * this.es;
        double es3 = this.es * es2;
        this.APA0 = 0.10257936507936508 * es3 + 0.17222222222222222 * es2 + 0.3333333333333333 * this.es;
        this.APA1 = 0.0664021164021164 * es3 + 0.06388888888888888 * es2;
        this.APA2 = 0.016415012942191543 * es3;
        this.qp = this.qsfn(1.0);
        this.rq = Math.sqrt(0.5 * this.qp);
        double sinphi = Math.sin(this.latitudeOfOrigin);
        if (this.spherical) {
            this.sinb1 = Math.sin(this.latitudeOfOrigin);
            this.cosb1 = Math.cos(this.latitudeOfOrigin);
        } else {
            this.sinb1 = this.qsfn(sinphi) / this.qp;
            this.cosb1 = Math.sqrt(1.0 - this.sinb1 * this.sinb1);
        }
        switch (this.mode) {
            case 2: 
            case 3: {
                this.dd = 1.0;
                this.xmf = this.ymf = this.rq;
                break;
            }
            case 1: {
                this.dd = 1.0 / this.rq;
                this.xmf = 1.0;
                this.ymf = 0.5 * this.qp;
                break;
            }
            case 0: {
                this.dd = Math.cos(this.latitudeOfOrigin) / (Math.sqrt(1.0 - this.es * sinphi * sinphi) * this.rq * this.cosb1);
                this.xmf = this.rq * this.dd;
                this.ymf = this.rq / this.dd;
                break;
            }
        }
    }

    public double[] project(double lambda, double phi, double[] xy) {
        if (this.spherical) {
            double sinphi = Math.sin(phi);
            double cosphi = Math.cos(phi);
            double coslam = Math.cos(lambda);
            double x = 0.0;
            double y = 0.0;
            switch (this.mode) {
                case 1: {
                    y = 1.0 + cosphi * coslam;
                    y = Math.sqrt(2.0 / y);
                    x = y * cosphi * Math.sin(lambda);
                    y *= sinphi;
                    break;
                }
                case 0: {
                    y = 1.0 + this.sinb1 * sinphi + this.cosb1 * cosphi * coslam;
                    y = Math.sqrt(2.0 / y);
                    x = y * cosphi * Math.sin(lambda);
                    y *= this.cosb1 * sinphi - this.sinb1 * cosphi * coslam;
                    break;
                }
                case 2: {
                    y = 0.7853981633974483 - phi * 0.5;
                    y = 2.0 * Math.sin(y);
                    x = y * Math.sin(lambda);
                    y *= -coslam;
                    break;
                }
                case 3: {
                    y = 0.7853981633974483 - phi * 0.5;
                    y = 2.0 * Math.cos(y);
                    x = y * Math.sin(lambda);
                    y *= coslam;
                    break;
                }
            }
            xy[0] = x;
            xy[1] = y;
        } else {
            double coslam = Math.cos(lambda);
            double sinlam = Math.sin(lambda);
            double sinphi = Math.sin(phi);
            double q = this.qsfn(sinphi);
            double x = 0.0;
            double y = 0.0;
            switch (this.mode) {
                case 0: {
                    double sinb = q / this.qp;
                    double cosb = Math.sqrt(1.0 - sinb * sinb);
                    double c = 1.0 + this.sinb1 * sinb + this.cosb1 * cosb * coslam;
                    double b = Math.sqrt(2.0 / c);
                    y = this.ymf * b * (this.cosb1 * sinb - this.sinb1 * cosb * coslam);
                    x = this.xmf * b * cosb * sinlam;
                    break;
                }
                case 1: {
                    double sinb = q / this.qp;
                    double cosb = Math.sqrt(1.0 - sinb * sinb);
                    double c = 1.0 + cosb * coslam;
                    double b = Math.sqrt(2.0 / c);
                    y = this.ymf * b * sinb;
                    x = this.xmf * b * cosb * sinlam;
                    break;
                }
                case 2: {
                    double c = 1.5707963267948966 + phi;
                    q = this.qp - q;
                    if (q >= 0.0) {
                        double b = Math.sqrt(q);
                        x = b * sinlam;
                        y = coslam * -b;
                        break;
                    }
                    y = 0.0;
                    x = 0.0;
                    break;
                }
                case 3: {
                    double c = phi - 1.5707963267948966;
                    q = this.qp + q;
                    if (q >= 0.0) {
                        double b = Math.sqrt(q);
                        x = b * sinlam;
                        y = coslam * b;
                        break;
                    }
                    y = 0.0;
                    x = 0.0;
                    break;
                }
            }
            xy[0] = x;
            xy[1] = y;
        }
        return xy;
    }

    public double[] projectInverse(double x, double y, double[] out) {
        if (this.spherical) {
            double lambda;
            double rh = Math.hypot(x, y);
            double phi = rh * 0.5;
            phi = 2.0 * Math.asin(phi);
            switch (this.mode) {
                case 1: {
                    double sinz = Math.sin(phi);
                    double cosz = Math.cos(phi);
                    phi = Math.abs(rh) <= 1.0E-10 ? 0.0 : Math.asin(y * sinz / rh);
                    y = cosz * rh;
                    lambda = y == 0.0 ? 0.0 : Math.atan2(x *= sinz, y);
                    break;
                }
                case 0: {
                    double sinz = Math.sin(phi);
                    double cosz = Math.cos(phi);
                    phi = Math.abs(rh) <= 1.0E-10 ? this.latitudeOfOrigin : Math.asin(cosz * this.sinb1 + y * sinz * this.cosb1 / rh);
                    y = (cosz - Math.sin(phi) * this.sinb1) * rh;
                    lambda = y == 0.0 ? 0.0 : Math.atan2(x *= sinz * this.cosb1, y);
                    break;
                }
                case 2: {
                    phi = 1.5707963267948966 - phi;
                    lambda = Math.atan2(x, -y);
                    break;
                }
                case 3: {
                    phi -= 1.5707963267948966;
                    lambda = Math.atan2(x, y);
                    break;
                }
                default: {
                    throw new AssertionError(this.mode);
                }
            }
            out[1] = phi;
            out[0] = lambda;
        } else {
            double lambda = 0.0;
            double phi = 0.0;
            switch (this.mode) {
                case 0: 
                case 1: {
                    double ab;
                    double rho = Math.hypot(x /= this.dd, y *= this.dd);
                    if (rho < 1.0E-10) {
                        lambda = 0.0;
                        phi = 0.0;
                        break;
                    }
                    double sCe = 2.0 * Math.asin(0.5 * rho / this.rq);
                    double cCe = Math.cos(sCe);
                    sCe = Math.sin(sCe);
                    x *= sCe;
                    if (this.mode == 0) {
                        ab = cCe * this.sinb1 + y * sCe * this.cosb1 / rho;
                        double q = this.qp * ab;
                        y = rho * this.cosb1 * cCe - y * this.sinb1 * sCe;
                    } else {
                        ab = y * sCe / rho;
                        double q = this.qp * ab;
                        y = rho * cCe;
                    }
                    lambda = Math.atan2(x, y);
                    phi = this.authlat(Math.asin(ab));
                    break;
                }
                case 2: {
                    y = -y;
                }
                case 3: {
                    double q = x * x + y * y;
                    if (q == 0.0) {
                        lambda = 0.0;
                        phi = 0.0;
                        break;
                    }
                    double ab = 1.0 - q / this.qp;
                    if (this.mode == 3) {
                        ab = -ab;
                    }
                    lambda = Math.atan2(x, y);
                    phi = this.authlat(Math.asin(ab));
                    break;
                }
            }
            out[1] = phi;
            out[0] = lambda;
        }
        return out;
    }

    private static double normalizeLatitude(double angle) {
        if (Double.isInfinite(angle) || Double.isNaN(angle)) {
            return 0.0;
        }
        while (angle > 1.5707963267948966) {
            angle -= Math.PI;
        }
        while (angle < -1.5707963267948966) {
            angle += Math.PI;
        }
        return angle;
    }

    public ProjectionPoint latLonToProj(LatLonPoint latlon, ProjectionPointImpl destPoint) {
        double x = latlon.getLongitude() * (Math.PI / 180);
        double y = latlon.getLatitude() * (Math.PI / 180);
        if (this.centralMeridian != 0.0) {
            x = LambertAzimutal.normalizeLongitude(x - this.centralMeridian);
        }
        if (this.latitudeOfOrigin != 0.0) {
            y = LambertAzimutal.normalizeLatitude(y - this.latitudeOfOrigin);
        }
        double[] dst = this.project(x, y, new double[2]);
        dst[0] = this.totalScale * dst[0] + this.totalFalseEasting;
        dst[1] = this.totalScale * dst[1] + this.totalFalseNorthing;
        return new ProjectionPointImpl(dst[0], dst[1]);
    }

    public LatLonPoint projToLatLon(ProjectionPoint ppt, LatLonPointImpl destPoint) {
        double y;
        double x = (ppt.getX() - this.totalFalseEasting) / this.totalScale;
        double[] dst = this.projectInverse(x, y = (ppt.getY() - this.totalFalseNorthing) / this.totalScale, new double[2]);
        if (dst[0] < -Math.PI) {
            dst[0] = -Math.PI;
        } else if (dst[0] > Math.PI) {
            dst[0] = Math.PI;
        }
        if (this.centralMeridian != 0.0) {
            dst[0] = LambertAzimutal.normalizeLongitude(dst[0] + this.centralMeridian);
        }
        if (this.latitudeOfOrigin != 0.0) {
            dst[1] = LambertAzimutal.normalizeLatitude(dst[1] + this.latitudeOfOrigin);
        }
        dst[0] = dst[0] * 57.29577951308232;
        dst[1] = dst[1] * 57.29577951308232;
        return new LatLonPointImpl(dst[1], dst[0]);
    }

    private double qsfn(double sinphi) {
        if (this.e >= 1.0E-7) {
            double con = this.e * sinphi;
            return (1.0 - this.es) * (sinphi / (1.0 - con * con) - 0.5 / this.e * Math.log((1.0 - con) / (1.0 + con)));
        }
        return sinphi + sinphi;
    }

    private double authlat(double beta) {
        double t = beta + beta;
        return beta + this.APA0 * Math.sin(t) + this.APA1 * Math.sin(t + t) + this.APA2 * Math.sin(t + t + t);
    }

    public static void main(String[] args) {
        LambertAzimutal la = new LambertAzimutal(Ellipsoid.WGS84Ell, 6.0, 44.0);
        ProjectionPointImpl p = la.latLonToProj(45.0, 7.2567);
        ProjectionPointImpl p2 = la.latLonToProj(45.0, 7.3881);
        ProjectionPointImpl p3 = la.latLonToProj(47.006213, 5.2423);
        LatLonPointImpl l = la.projToLatLon(p.getX(), p.getY());
        l = la.projToLatLon(0.0, 0.0);
        l = la.projToLatLon(10000.0, 10000.0);
        l = la.projToLatLon(0.0, 10000.0);
        l = la.projToLatLon(0.0, -10000.0);
        l = la.projToLatLon(p.getX(), p.getY());
        l = la.projToLatLon(p.getX(), p.getY());
        System.currentTimeMillis();
    }
}

