/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.geoloc.projection;

import oruxmapsdesktop.calculadora.Ellipsoid;
import oruxmapsdesktop.geoloc.LatLonPoint;
import oruxmapsdesktop.geoloc.LatLonPointImpl;
import oruxmapsdesktop.geoloc.ParametrosProyeccion;
import oruxmapsdesktop.geoloc.ProjectionImpl;
import oruxmapsdesktop.geoloc.ProjectionPoint;
import oruxmapsdesktop.geoloc.ProjectionPointImpl;

public class LambertAzimutal1
extends ProjectionImpl {
    private double R = 6371.229;
    private double sinLat0;
    private double cosLat0;
    private double lon0Degrees;
    private double lat0;
    private double lon0;
    private double falseEasting;
    private double falseNorthing;
    private LatLonPointImpl origin;
    private static final double EPSILON = 1.0E-7;
    private double APA0;
    private double APA1;
    private double APA2;
    private double a = 0.0;
    private double e = 0.0;
    private double es = 0.0;

    public LambertAzimutal1() {
        this(Ellipsoid.WGS84Ell, 0.0, 0.0);
    }

    public LambertAzimutal1(ParametrosProyeccion params) {
        this(params.ell, params.lon_or, params.lat_or);
    }

    public LambertAzimutal1(Ellipsoid ellipsoid, double lon_0, double lat_0) {
        this.lat0 = Math.toRadians(lat_0);
        this.lon0Degrees = lon_0;
        this.lon0 = Math.toRadians(lon_0);
        this.origin = new LatLonPointImpl(lat_0, lon_0);
        this.precalculate();
        this.requiereConversionDatum = true;
        this.name = "Lambert Azimutal";
        this.tieneParametros = true;
    }

    private void precalculate() {
        this.sinLat0 = Math.sin(this.lat0);
        this.cosLat0 = Math.cos(this.lat0);
        this.lon0Degrees = Math.toDegrees(this.lon0);
    }

    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        fromLat = Math.toRadians(fromLat);
        double lonDiff = Math.toRadians(LatLonPointImpl.lonNormal(fromLon - this.lon0Degrees));
        double g = this.sinLat0 * Math.sin(fromLat) + this.cosLat0 * Math.cos(fromLat) * Math.cos(lonDiff);
        double kPrime = Math.sqrt(2.0 / (1.0 + g));
        double toX = this.R * kPrime * Math.cos(fromLat) * Math.sin(lonDiff) + this.falseEasting;
        double toY = this.R * kPrime * (this.cosLat0 * Math.sin(fromLat) - this.sinLat0 * Math.cos(fromLat) * Math.cos(lonDiff)) + this.falseNorthing;
        result.setLocation(toX, toY);
        return result;
    }

    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double toLat;
        double fromX = world.getX();
        double fromY = world.getY();
        double rho = Math.sqrt((fromX -= this.falseEasting) * fromX + (fromY -= this.falseNorthing) * fromY);
        double c = 2.0 * Math.asin(rho / (2.0 * this.R));
        double toLon = this.lon0;
        double temp = 0.0;
        if (Math.abs(rho) > 1.0E-6) {
            toLat = Math.asin(Math.cos(c) * this.sinLat0 + fromY * Math.sin(c) * this.cosLat0 / rho);
            if (Math.abs(this.lat0 - 0.7853981633974483) > 1.0E-6) {
                temp = rho * this.cosLat0 * Math.cos(c) - fromY * this.sinLat0 * Math.sin(c);
                toLon = this.lon0 + Math.atan(fromX * Math.sin(c) / temp);
            } else if (this.lat0 == 0.7853981633974483) {
                temp = rho * this.cosLat0 * Math.cos(c) - fromY * this.sinLat0 * Math.sin(c);
                toLon = this.lon0 + Math.atan(fromX * Math.sin(c) / temp);
            } else {
                toLon = this.lon0 + Math.atan(fromX / fromY);
                temp = fromY;
            }
        } else {
            toLat = this.lat0;
        }
        toLat = Math.toDegrees(toLat);
        toLon = Math.toDegrees(toLon);
        if (temp < 0.0) {
            toLon += 180.0;
        }
        toLon = LatLonPointImpl.lonNormal(toLon);
        result.setLatitude(toLat);
        result.setLongitude(toLon);
        return result;
    }

    public static void main(String[] args) {
        LambertAzimutal1 la = new LambertAzimutal1(Ellipsoid.WGS84Ell, 6.0, 45.0);
        ProjectionPointImpl p = la.latLonToProj(45.0, 7.2567);
        ProjectionPointImpl p2 = la.latLonToProj(45.0, 7.3881);
        ProjectionPointImpl p3 = la.latLonToProj(44.006213, 5.2423);
        LatLonPointImpl l = la.projToLatLon(p.getX(), p.getY());
        l = la.projToLatLon(0.0, 0.0);
        l = la.projToLatLon(10000.0, 10000.0);
        l = la.projToLatLon(0.0, 10000.0);
        l = la.projToLatLon(0.0, -10000.0);
        l = la.projToLatLon(p.getX(), p.getY());
        l = la.projToLatLon(p.getX(), p.getY());
        System.currentTimeMillis();
    }
}

