/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.geoloc.projection;

import oruxmapsdesktop.calculadora.Ellipsoid;
import oruxmapsdesktop.geoloc.LatLonPoint;
import oruxmapsdesktop.geoloc.LatLonPointImpl;
import oruxmapsdesktop.geoloc.ParametrosProyeccion;
import oruxmapsdesktop.geoloc.ProjectionImpl;
import oruxmapsdesktop.geoloc.ProjectionPoint;
import oruxmapsdesktop.geoloc.ProjectionPointImpl;

public class LambertConformal
extends ProjectionImpl {
    private double n;
    private double F;
    private double rho0;
    private double excentricity;
    private double excentricitySquared;
    private double latitudeOfOrigin;
    private double longitudeOfOrigin;
    private double phi1;
    private double phi2;
    private double totalScale;
    private double falseEasting;
    private double falseNorthing;
    private static final double EPSILON = 1.0E-6;
    private static final int MAXIMUM_ITERATIONS = 15;
    private static final double ITERATION_TOLERANCE = 1.0E-10;
    public static final double HALFPI = 1.5707963267948966;
    public static final double QUARTERPI = 0.7853981633974483;
    public static final double TWOPI = Math.PI * 2;
    public static final double RTD = 57.29577951308232;
    public static final double DTR = Math.PI / 180;

    public LambertConformal(Ellipsoid ellipsoid, double lat0, double lon0, double par1, double par2, double false_easting, double false_northing) {
        this.requiereConversionDatum = true;
        this.name = "LambertConformalConic";
        this.tieneParametros = true;
        this.falseEasting = false_easting;
        this.falseNorthing = false_northing;
        this.phi1 = par1 * Math.PI / 180.0;
        this.phi2 = par2 * Math.PI / 180.0;
        this.latitudeOfOrigin = lat0 * Math.PI / 180.0;
        this.longitudeOfOrigin = lon0 * Math.PI / 180.0;
        this.excentricitySquared = ellipsoid.eccentricitySquared;
        this.excentricity = Math.sqrt(this.excentricitySquared);
        this.totalScale = ellipsoid.EquatorialRadius;
        double cosphi1 = Math.cos(this.phi1);
        double sinphi1 = Math.sin(this.phi1);
        boolean secant = Math.abs(this.phi1 - this.phi2) > 1.0E-6;
        double m1 = this.msfn(sinphi1, cosphi1);
        double t1 = this.tsfn(this.phi1, sinphi1);
        if (secant) {
            double sinphi2 = Math.sin(this.phi2);
            double m2 = this.msfn(sinphi2, Math.cos(this.phi2));
            double t2 = this.tsfn(this.phi2, sinphi2);
            this.n = Math.log(m1 / m2) / Math.log(t1 / t2);
        } else {
            this.n = sinphi1;
        }
        this.F = m1 * Math.pow(t1, -this.n) / this.n;
        this.rho0 = Math.abs(Math.abs(this.latitudeOfOrigin) - 1.5707963267948966) >= 1.0E-6 ? this.F * Math.pow(this.tsfn(this.latitudeOfOrigin, Math.sin(this.latitudeOfOrigin)), this.n) : 0.0;
    }

    public LambertConformal(ParametrosProyeccion params) {
        this(params.ell, params.lat_or, params.lon_or, params.par1, params.par2, params.falso_este, params.falso_norte);
    }

    final double msfn(double s, double c) {
        return c / Math.sqrt(1.0 - s * s * this.excentricitySquared);
    }

    final double tsfn(double phi, double sinphi) {
        return Math.tan(0.5 * (1.5707963267948966 - phi)) / Math.pow((1.0 - (sinphi *= this.excentricity)) / (1.0 + sinphi), 0.5 * this.excentricity);
    }

    public double[] latLonToProj(double lat, double lon, double[] res) {
        double rho;
        res[1] = lat * Math.PI / 180.0;
        res[0] = lon * Math.PI / 180.0;
        if (this.longitudeOfOrigin != 0.0) {
            res[0] = LambertConformal.normalizeLongitudeRadians(res[0] - this.longitudeOfOrigin);
        }
        if (Math.abs(Math.abs(res[1]) - 1.5707963267948966) < 1.0E-6) {
            if (res[1] * this.n <= 0.0) {
                return null;
            }
            rho = 0.0;
        } else {
            rho = this.F * Math.pow(this.tsfn(res[1], Math.sin(res[1])), this.n);
        }
        res[0] = res[0] * this.n;
        res[1] = this.rho0 - rho * Math.cos(res[0]);
        res[0] = rho * Math.sin(res[0]);
        res[0] = this.totalScale * res[0] + this.falseEasting;
        res[1] = this.totalScale * res[1] + this.falseNorthing;
        return res;
    }

    public double[] projToLatLon(double x, double y, double[] res) {
        x = (x - this.falseEasting) / this.totalScale;
        y = (y - this.falseNorthing) / this.totalScale;
        double rho = Math.hypot(x, y = this.rho0 - y);
        if (rho > 1.0E-6) {
            if (this.n < 0.0) {
                rho = -rho;
                x = -x;
                y = -y;
            }
            double theta = Math.atan2(x, y);
            x = theta / this.n;
            try {
                y = this.cphi2(Math.pow(rho / this.F, 1.0 / this.n));
            }
            catch (Exception e) {
                y = 0.0;
            }
        } else {
            x = 0.0;
            double d = y = this.n < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        }
        if (x < -Math.PI) {
            x = -Math.PI;
        } else if (x > Math.PI) {
            x = Math.PI;
        }
        if (this.longitudeOfOrigin != 0.0) {
            x = LambertConformal.normalizeLongitudeRadians(x + this.longitudeOfOrigin);
        }
        res[1] = x * 57.29577951308232;
        res[0] = y * 57.29577951308232;
        return res;
    }

    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double rho;
        double y = latLon.getLatitude() * Math.PI / 180.0;
        double x = latLon.getLongitude() * Math.PI / 180.0;
        if (this.longitudeOfOrigin != 0.0) {
            x = LambertConformal.normalizeLongitudeRadians(x - this.longitudeOfOrigin);
        }
        if (Math.abs(Math.abs(y) - 1.5707963267948966) < 1.0E-6) {
            if (y * this.n <= 0.0) {
                return null;
            }
            rho = 0.0;
        } else {
            rho = this.F * Math.pow(this.tsfn(y, Math.sin(y)), this.n);
        }
        y = this.rho0 - rho * Math.cos(x *= this.n);
        x = rho * Math.sin(x);
        if (result != null) {
            result.x = this.totalScale * x + this.falseEasting;
            result.y = this.totalScale * y + this.falseNorthing;
            return result;
        }
        return new ProjectionPointImpl(this.totalScale * x + this.falseEasting, this.totalScale * y + this.falseNorthing);
    }

    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double x = (world.getX() - this.falseEasting) / this.totalScale;
        double y = (world.getY() - this.falseNorthing) / this.totalScale;
        double rho = Math.hypot(x, y = this.rho0 - y);
        if (rho > 1.0E-6) {
            if (this.n < 0.0) {
                rho = -rho;
                x = -x;
                y = -y;
            }
            double theta = Math.atan2(x, y);
            x = theta / this.n;
            try {
                y = this.cphi2(Math.pow(rho / this.F, 1.0 / this.n));
            }
            catch (Exception e) {
                y = 0.0;
            }
        } else {
            x = 0.0;
            double d = y = this.n < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        }
        if (x < -Math.PI) {
            x = -Math.PI;
        } else if (x > Math.PI) {
            x = Math.PI;
        }
        if (this.longitudeOfOrigin != 0.0) {
            x = LambertConformal.normalizeLongitudeRadians(x + this.longitudeOfOrigin);
        }
        x *= 57.29577951308232;
        y *= 57.29577951308232;
        if (result != null) {
            result.set(y, x);
            return result;
        }
        return new LatLonPointImpl(y, x);
    }

    final double cphi2(double ts) throws Exception {
        double eccnth = 0.5 * this.excentricity;
        double phi = 1.5707963267948966 - 2.0 * Math.atan(ts);
        for (int i = 0; i < 15; ++i) {
            double con = this.excentricity * Math.sin(phi);
            double dphi = 1.5707963267948966 - 2.0 * Math.atan(ts * Math.pow((1.0 - con) / (1.0 + con), eccnth)) - phi;
            phi += dphi;
            if (!(Math.abs(dphi) <= 1.0E-10)) continue;
            return phi;
        }
        throw new Exception();
    }

    public static double normalizeLongitudeRadians(double angle) {
        if (Double.isInfinite(angle) || Double.isNaN(angle)) {
            throw new IllegalArgumentException("Infinite longitude");
        }
        while (angle > Math.PI) {
            angle -= Math.PI * 2;
        }
        while (angle < -Math.PI) {
            angle += Math.PI * 2;
        }
        return angle;
    }
}

