/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.geoloc.projection;

import oruxmapsdesktop.geoloc.LatLonPoint;
import oruxmapsdesktop.geoloc.LatLonPointImpl;
import oruxmapsdesktop.geoloc.ParametrosProyeccion;
import oruxmapsdesktop.geoloc.ProjectionImpl;
import oruxmapsdesktop.geoloc.ProjectionPoint;
import oruxmapsdesktop.geoloc.ProjectionPointImpl;

public class LatLonProjection
extends ProjectionImpl {
    private double centerLon = 0.0;
    private double cosFactor = 1.0;

    public LatLonProjection(double std_paralell) {
        this.requiereConversionDatum = true;
        this.name = "Latitude/Longitude";
        this.tieneParametros = false;
        this.cosFactor = Math.cos(Math.toRadians(std_paralell));
    }

    public LatLonProjection(ParametrosProyeccion params) {
        this(params.lat_or);
    }

    public ProjectionPoint latLonToProj(LatLonPoint latlon, ProjectionPointImpl result) {
        result.setLocation(LatLonPointImpl.lonNormal(latlon.getLongitude() * this.cosFactor, this.centerLon), latlon.getLatitude());
        return result;
    }

    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        result.setLongitude(LatLonPointImpl.lonNormal((world.getX() + this.centerLon) / this.cosFactor));
        result.setLatitude(world.getY());
        return result;
    }

    public double setCenterLon(double centerLon) {
        this.centerLon = LatLonPointImpl.lonNormal(centerLon);
        return this.centerLon;
    }

    public double getCenterLon() {
        return this.centerLon;
    }
}

