/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.geoloc.projection;

import oruxmapsdesktop.geoloc.LatLonPoint;
import oruxmapsdesktop.geoloc.LatLonPointImpl;
import oruxmapsdesktop.geoloc.ParametrosProyeccion;
import oruxmapsdesktop.geoloc.ProjectionImpl;
import oruxmapsdesktop.geoloc.ProjectionPoint;
import oruxmapsdesktop.geoloc.ProjectionPointImpl;
import oruxmapsdesktop.geoloc.SpecialMathFunction;

public class Mercator
extends ProjectionImpl {
    private double lon0;
    private double par;
    private double par_r;
    private double A;
    private double falseEasting;
    private double falseNorthing;
    private LatLonPointImpl origin;

    public Mercator() {
        this(-105.0, 20.0);
    }

    public Mercator(double lon0, double par) {
        this(lon0, par, 0.0, 0.0);
    }

    public Mercator(ParametrosProyeccion params) {
        this(params.lon_or, params.lat_or, params.falso_este, params.falso_norte);
    }

    public Mercator(double lon0, double par, double false_easting, double false_northing) {
        this.origin = new LatLonPointImpl(0.0, lon0);
        this.lon0 = lon0;
        this.par = par;
        this.falseEasting = false_easting;
        this.falseNorthing = false_northing;
        this.par_r = Math.toRadians(par);
        this.requiereConversionDatum = true;
        this.name = "Mercator";
        this.tieneParametros = false;
        this.precalculate();
    }

    private void precalculate() {
        this.A = 6371.229 * Math.cos(this.par_r) * 1000.0;
    }

    public double getParallel() {
        return this.par;
    }

    public void setParallel(double par) {
        this.par = par;
        this.precalculate();
    }

    public double getOriginLon() {
        return this.origin.getLongitude();
    }

    public void setOriginLon(double lon) {
        this.origin.setLongitude(lon);
        this.lon0 = lon;
        this.precalculate();
    }

    public double getFalseEasting() {
        return this.falseEasting;
    }

    public void setFalseEasting(double falseEasting) {
        this.falseEasting = falseEasting;
    }

    public double getFalseNorthing() {
        return this.falseNorthing;
    }

    public void setFalseNorthing(double falseNorthing) {
        this.falseNorthing = falseNorthing;
    }

    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double toY;
        double toX;
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        double fromLat_r = Math.toRadians(fromLat);
        if (Math.abs(90.0 - Math.abs(fromLat)) < 1.0E-6) {
            toX = Double.POSITIVE_INFINITY;
            toY = Double.POSITIVE_INFINITY;
        } else {
            toX = this.A * Math.toRadians(LatLonPointImpl.range180(fromLon - this.lon0));
            toY = this.A * SpecialMathFunction.atanh(Math.sin(fromLat_r));
        }
        result.setLocation(toX + this.falseEasting, toY + this.falseNorthing);
        return result;
    }

    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double fromX = world.getX() - this.falseEasting;
        double fromY = world.getY() - this.falseNorthing;
        double toLon = Math.toDegrees(fromX / this.A) + this.lon0;
        double e = Math.exp(-fromY / this.A);
        double toLat = Math.toDegrees(1.5707963267948966 - 2.0 * Math.atan(e));
        result.setLatitude(toLat);
        result.setLongitude(toLon);
        return result;
    }
}

