/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.geoloc.projection;

import oruxmapsdesktop.geoloc.LatLonPoint;
import oruxmapsdesktop.geoloc.LatLonPointImpl;
import oruxmapsdesktop.geoloc.ProjectionImpl;
import oruxmapsdesktop.geoloc.ProjectionPoint;
import oruxmapsdesktop.geoloc.ProjectionPointImpl;

public class RDGrid
extends ProjectionImpl {
    private double x0 = 155000.0;
    private double y0 = 463000.0;
    private double f0 = 52.15616056;
    private double l0 = 5.38763889;
    private double c01 = 190066.98903;
    private double d10 = 309020.3181;
    private double c11 = -11830.85831;
    private double d02 = 3638.36193;
    private double c21 = -114.19754;
    private double d12 = -157.95222;
    private double c03 = -32.3836;
    private double d20 = 72.97141;
    private double c31 = -2.34078;
    private double d30 = 59.79734;
    private double c13 = -0.60639;
    private double d22 = -6.43481;
    private double c23 = 0.15774;
    private double d04 = 0.09351;
    private double c41 = -0.04158;
    private double d32 = -0.07379;
    private double c05 = -0.00661;
    private double d14 = -0.05419;
    private double d40 = -0.03444;
    private double a01 = 3236.0331637;
    private double b10 = 5261.3028966;
    private double a20 = -32.5915821;
    private double b11 = 105.9780241;
    private double a02 = -0.2472814;
    private double b12 = 2.4576469;
    private double a21 = -0.8501341;
    private double b30 = -0.8192156;
    private double a03 = -0.0655238;
    private double b31 = -0.0560092;
    private double a22 = -0.0171137;
    private double b13 = 0.0560089;
    private double a40 = 0.0052771;
    private double b32 = -0.0025614;
    private double a23 = -3.859E-4;
    private double b14 = 0.001277;
    private double a41 = 3.314E-4;
    private double b50 = 2.574E-4;
    private double a04 = 3.71E-5;
    private double b33 = -9.73E-5;
    private double a42 = 1.43E-5;
    private double b51 = 2.93E-5;
    private double a24 = -9.0E-6;
    private double b15 = 2.91E-5;

    public ProjectionPoint latLonToProj(LatLonPoint latlon, ProjectionPointImpl destPoint) {
        double[] xy = this.LatLonToGrid(latlon.getLatitude(), latlon.getLongitude());
        destPoint.x = xy[0];
        destPoint.y = xy[1];
        return destPoint;
    }

    public LatLonPoint projToLatLon(ProjectionPoint ppt, LatLonPointImpl destPoint) {
        double[] latlon = this.GridToLatLon(ppt.getX(), ppt.getY());
        destPoint.set(latlon[0], latlon[1]);
        return destPoint;
    }

    public RDGrid() {
        this.requiereConversionDatum = false;
        this.name = "Rijksdriehoeksmeting";
        this.tieneParametros = false;
    }

    public double[] LatLonToGrid(double lat, double lon) {
        double fWgs = lat - (-96.862 - 11.714 * (lat - 52.0) - 0.125 * (lon - 5.0)) / 100000.0;
        double lWgs = lon - (-37.902 + 0.329 * (lat - 52.0) - 14.667 * (lon - 5.0)) / 100000.0;
        double df = (fWgs - this.f0) * 0.36;
        double dl = (lWgs - this.l0) * 0.36;
        double df2 = df * df;
        double df3 = df2 * df;
        double df4 = df3 * df;
        double dl2 = dl * dl;
        double dl3 = dl2 * dl;
        double dl4 = dl3 * dl;
        double dx = this.c01 * dl + this.c11 * df * dl + this.c21 * df2 * dl + this.c03 * dl3;
        dx += this.c31 * df3 * dl + this.c13 * df * dl3 + this.c23 * df2 * dl3;
        double x = this.x0 + (dx += this.c41 * df4 * dl + this.c05 * dl4 * dl);
        double dy = this.d10 * df + this.d20 * df2 + this.d02 * dl2 + this.d12 * df * dl2;
        dy += this.d30 * df3 + this.d22 * df2 * dl2 + this.d40 * df4;
        double y = this.y0 + (dy += this.d04 * dl4 + this.d32 * df3 * dl2 + this.d14 * df * dl4);
        double[] temp = new double[]{x, y};
        return temp;
    }

    public double[] GridToLatLon(double x, double y) {
        double dx = (x - this.x0) * Math.pow(10.0, -5.0);
        double dy = (y - this.y0) * Math.pow(10.0, -5.0);
        double dx2 = dx * dx;
        double dx3 = dx2 * dx;
        double dx4 = dx3 * dx;
        double dy2 = dy * dy;
        double dy3 = dy2 * dy;
        double dy4 = dy3 * dy;
        double df = this.a01 * dy + this.a20 * dx2 + this.a02 * dy2 + this.a21 * dx2 * dy + this.a03 * dy3;
        df += this.a40 * dx4 + this.a22 * dx2 * dy2 + this.a04 * dy4 + this.a41 * dx4 * dy;
        double f = this.f0 + (df += this.a23 * dx2 * dy3 + this.a42 * dx4 * dy2 + this.a24 * dx2 * dy4) / 3600.0;
        double dl = this.b10 * dx + this.b11 * dx * dy + this.b30 * dx3 + this.b12 * dx * dy2 + this.b31 * dx3 * dy;
        dl += this.b13 * dx * dy3 + this.b50 * dx4 * dx + this.b32 * dx3 * dy2 + this.b14 * dx * dy4;
        double l = this.l0 + (dl += this.b51 * dx4 * dx * dy + this.b33 * dx3 * dy3 + this.b15 * dx * dy4 * dy) / 3600.0;
        double fWgs = f + (-96.862 - 11.714 * (f - 52.0) - 0.125 * (l - 5.0)) / 100000.0;
        double lWgs = l + (-37.902 + 0.329 * (f - 52.0) - 14.667 * (l - 5.0)) / 100000.0;
        double[] res = new double[]{fWgs, lWgs};
        return res;
    }

    public static double SexToDecAngle(double dms) {
        double deg = 0.0;
        double min = 0.0;
        double sec = 0.0;
        deg = Math.floor(dms);
        min = Math.floor((dms - deg) * 100.0);
        sec = ((dms - deg) * 100.0 - min) * 100.0;
        return deg + min / 60.0 + sec / 3600.0;
    }

    public static double DecToSexAngle(double dec) {
        int deg = (int)Math.floor(dec);
        int min = (int)Math.floor((dec - (double)deg) * 60.0);
        double sec = ((dec - (double)deg) * 60.0 - (double)min) * 60.0;
        return (double)deg + (double)min / 100.0 + sec / 10000.0;
    }

    public static double SexAngleToSeconds(double dms) {
        double deg = 0.0;
        double min = 0.0;
        double sec = 0.0;
        deg = Math.floor(dms);
        min = Math.floor((dms - deg) * 100.0);
        sec = ((dms - deg) * 100.0 - min) * 100.0;
        return sec + min * 60.0 + deg * 3600.0;
    }
}

