/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.geoloc.projection;

import oruxmapsdesktop.geoloc.LatLonPoint;
import oruxmapsdesktop.geoloc.LatLonPointImpl;
import oruxmapsdesktop.geoloc.ProjectionImpl;
import oruxmapsdesktop.geoloc.ProjectionPoint;
import oruxmapsdesktop.geoloc.ProjectionPointImpl;

public class SwissGrid
extends ProjectionImpl {
    public SwissGrid() {
        this.requiereConversionDatum = false;
        this.name = "(SUI) Swiss Grid";
        this.tieneParametros = false;
    }

    public ProjectionPoint latLonToProj(LatLonPoint latlon, ProjectionPointImpl destPoint) {
        double[] xy = SwissGrid.WGS84toLV03(latlon.getLatitude(), latlon.getLongitude());
        destPoint.x = xy[0];
        destPoint.y = xy[1];
        return destPoint;
    }

    public LatLonPoint projToLatLon(ProjectionPoint ppt, LatLonPointImpl destPoint) {
        double[] latlon = SwissGrid.LV03toWGS84(ppt.getX(), ppt.getY());
        destPoint.set(latlon[0], latlon[1]);
        return destPoint;
    }

    public static double[] LV03toWGS84(double east, double north) {
        double[] result = new double[]{SwissGrid.CHtoWGSlat(east, north), SwissGrid.CHtoWGSlng(east, north)};
        return result;
    }

    public static double[] WGS84toLV03(double latitude, double longitude) {
        double[] result = new double[]{SwissGrid.WGStoCHy(latitude, longitude), SwissGrid.WGStoCHx(latitude, longitude)};
        return result;
    }

    private static double WGStoCHy(double lat, double lng) {
        lat = SwissGrid.DecToSexAngle(lat);
        lng = SwissGrid.DecToSexAngle(lng);
        lat = SwissGrid.SexAngleToSeconds(lat);
        lng = SwissGrid.SexAngleToSeconds(lng);
        double lat_aux = (lat - 169028.66) / 10000.0;
        double lng_aux = (lng - 26782.5) / 10000.0;
        double y = 600072.37 + 211455.93 * lng_aux - 10938.51 * lng_aux * lat_aux - 0.36 * lng_aux * Math.pow(lat_aux, 2.0) - 44.54 * Math.pow(lng_aux, 3.0);
        return y;
    }

    private static double WGStoCHx(double lat, double lng) {
        lat = SwissGrid.DecToSexAngle(lat);
        lng = SwissGrid.DecToSexAngle(lng);
        lat = SwissGrid.SexAngleToSeconds(lat);
        lng = SwissGrid.SexAngleToSeconds(lng);
        double lat_aux = (lat - 169028.66) / 10000.0;
        double lng_aux = (lng - 26782.5) / 10000.0;
        double x = 200147.07 + 308807.95 * lat_aux + 3745.25 * Math.pow(lng_aux, 2.0) + 76.63 * Math.pow(lat_aux, 2.0) - 194.56 * Math.pow(lng_aux, 2.0) * lat_aux + 119.79 * Math.pow(lat_aux, 3.0);
        return x;
    }

    private static double CHtoWGSlat(double y, double x) {
        double y_aux = (y - 600000.0) / 1000000.0;
        double x_aux = (x - 200000.0) / 1000000.0;
        double lat = 16.9023892 + 3.238272 * x_aux - 0.270978 * Math.pow(y_aux, 2.0) - 0.002528 * Math.pow(x_aux, 2.0) - 0.0447 * Math.pow(y_aux, 2.0) * x_aux - 0.014 * Math.pow(x_aux, 3.0);
        lat = lat * 100.0 / 36.0;
        return lat;
    }

    private static double CHtoWGSlng(double y, double x) {
        double y_aux = (y - 600000.0) / 1000000.0;
        double x_aux = (x - 200000.0) / 1000000.0;
        double lng = 2.6779094 + 4.728982 * y_aux + 0.791484 * y_aux * x_aux + 0.1306 * y_aux * Math.pow(x_aux, 2.0) - 0.0436 * Math.pow(y_aux, 3.0);
        lng = lng * 100.0 / 36.0;
        return lng;
    }

    public static double SexToDecAngle(double dms) {
        double deg = 0.0;
        double min = 0.0;
        double sec = 0.0;
        deg = Math.floor(dms);
        min = Math.floor((dms - deg) * 100.0);
        sec = ((dms - deg) * 100.0 - min) * 100.0;
        return deg + min / 60.0 + sec / 3600.0;
    }

    public static double DecToSexAngle(double dec) {
        int deg = (int)Math.floor(dec);
        int min = (int)Math.floor((dec - (double)deg) * 60.0);
        double sec = ((dec - (double)deg) * 60.0 - (double)min) * 60.0;
        return (double)deg + (double)min / 100.0 + sec / 10000.0;
    }

    public static double SexAngleToSeconds(double dms) {
        double deg = 0.0;
        double min = 0.0;
        double sec = 0.0;
        deg = Math.floor(dms);
        min = Math.floor((dms - deg) * 100.0);
        sec = ((dms - deg) * 100.0 - min) * 100.0;
        return sec + min * 60.0 + deg * 3600.0;
    }
}

