/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.geoloc.projection;

import oruxmapsdesktop.calculadora.Ellipsoid;
import oruxmapsdesktop.geoloc.LatLonPoint;
import oruxmapsdesktop.geoloc.LatLonPointImpl;
import oruxmapsdesktop.geoloc.ParametrosProyeccion;
import oruxmapsdesktop.geoloc.ProjectionImpl;
import oruxmapsdesktop.geoloc.ProjectionPoint;
import oruxmapsdesktop.geoloc.ProjectionPointImpl;

public class TransverseMercator
extends ProjectionImpl {
    private static final double FC1 = 1.0;
    private static final double FC2 = 0.5;
    private static final double FC3 = 0.16666666666666666;
    private static final double FC4 = 0.08333333333333333;
    private static final double FC5 = 0.05;
    private static final double FC6 = 0.03333333333333333;
    private static final double FC7 = 0.023809523809523808;
    private static final double FC8 = 0.017857142857142856;
    private double esp;
    private double ml0;
    private double[] en;
    protected double minLatitude = -1.5707963267948966;
    protected double minLongitude = -Math.PI;
    protected double maxLatitude = 1.5707963267948966;
    protected double maxLongitude = Math.PI;
    protected double projectionLatitude = 0.0;
    protected double projectionLongitude = 0.0;
    protected double projectionLatitude1 = 0.0;
    protected double projectionLatitude2 = 0.0;
    protected double scaleFactor = 1.0;
    protected double falseEasting = 0.0;
    protected double falseNorthing = 0.0;
    protected double trueScaleLatitude = 0.0;
    protected double a = 0.0;
    protected double e = 0.0;
    protected double es = 0.0;
    protected double one_es = 0.0;
    protected double rone_es = 0.0;
    protected Ellipsoid ellipsoid;
    protected boolean spherical;
    protected boolean geocentric;
    protected double fromMetres = 1.0;
    private double totalScale = 0.0;
    private double totalFalseEasting = 0.0;
    private double totalFalseNorthing = 0.0;
    protected static final double EPS10 = 1.0E-10;
    protected static final double RTD = 57.29577951308232;
    protected static final double DTR = Math.PI / 180;
    public static final double HALFPI = 1.5707963267948966;
    public static final double QUARTERPI = 0.7853981633974483;
    public static final double TWOPI = Math.PI * 2;
    private static final double C00 = 1.0;
    private static final double C02 = 0.25;
    private static final double C04 = 0.046875;
    private static final double C06 = 0.01953125;
    private static final double C08 = 0.01068115234375;
    private static final double C22 = 0.75;
    private static final double C44 = 0.46875;
    private static final double C46 = 0.013020833333333334;
    private static final double C48 = 0.007120768229166667;
    private static final double C66 = 0.3645833333333333;
    private static final double C68 = 0.005696614583333333;
    private static final double C88 = 0.3076171875;
    private static final int MAX_ITER = 10;

    public TransverseMercator() {
        this(Ellipsoid.WGS84Ell, 0.0, 0.0, 1.0, 0.0, 0.0);
        this.initialize();
    }

    public TransverseMercator(ParametrosProyeccion params) {
        this(params.ell, params.lon_or, params.lat_or, params.factor, params.falso_este, params.falso_norte);
    }

    public TransverseMercator(Ellipsoid ellipsoid, double lon_0, double lat_0, double k, double x_0, double y_0) {
        this.setEllipsoid(ellipsoid);
        this.projectionLongitude = lon_0;
        this.projectionLatitude = lat_0;
        this.scaleFactor = k;
        this.falseEasting = x_0;
        this.falseNorthing = y_0;
        this.requiereConversionDatum = true;
        this.name = "Transverse Mercator";
        this.tieneParametros = true;
        this.initialize();
    }

    public void setEllipsoid(Ellipsoid ellipsoid) {
        this.ellipsoid = ellipsoid;
        this.a = ellipsoid.EquatorialRadius;
        this.e = Math.sqrt(ellipsoid.eccentricitySquared);
        this.es = ellipsoid.eccentricitySquared;
    }

    public static double normalizeLatitude(double angle) {
        if (Double.isInfinite(angle) || Double.isNaN(angle)) {
            return 0.0;
        }
        while (angle > 1.5707963267948966) {
            angle -= Math.PI;
        }
        while (angle < -1.5707963267948966) {
            angle += Math.PI;
        }
        return angle;
    }

    public static double normalizeLongitude(double angle) {
        if (Double.isInfinite(angle) || Double.isNaN(angle)) {
            return 0.0;
        }
        while (angle > Math.PI) {
            angle -= Math.PI * 2;
        }
        while (angle < -Math.PI) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    public static double[] enfn(double es) {
        double[] en = new double[5];
        en[0] = 1.0 - es * (0.25 + es * (0.046875 + es * (0.01953125 + es * 0.01068115234375)));
        en[1] = es * (0.75 - es * (0.046875 + es * (0.01953125 + es * 0.01068115234375)));
        double t = es * es;
        en[2] = t * (0.46875 - es * (0.013020833333333334 + es * 0.007120768229166667));
        en[3] = (t *= es) * (0.3645833333333333 - es * 0.005696614583333333);
        en[4] = t * es * 0.3076171875;
        return en;
    }

    public static double mlfn(double phi, double sphi, double cphi, double[] en) {
        cphi *= sphi;
        sphi *= sphi;
        return en[0] * phi - cphi * (en[1] + sphi * (en[2] + sphi * (en[3] + sphi * en[4])));
    }

    public static double inv_mlfn(double arg, double es, double[] en) {
        double k = 1.0 / (1.0 - es);
        double phi = arg;
        for (int i = 10; i != 0; --i) {
            double s = Math.sin(phi);
            double t = 1.0 - es * s * s;
            t = (TransverseMercator.mlfn(phi, s, Math.cos(phi), en) - arg) * (t * Math.sqrt(t)) * k;
            phi -= t;
            if (!(Math.abs(t) < 1.0E-11)) continue;
            return phi;
        }
        return phi;
    }

    public void initialize() {
        this.spherical = this.e == 0.0;
        this.one_es = 1.0 - this.es;
        this.rone_es = 1.0 / this.one_es;
        this.totalScale = this.a * this.fromMetres;
        this.totalFalseEasting = this.falseEasting * this.fromMetres;
        this.totalFalseNorthing = this.falseNorthing * this.fromMetres;
        if (this.spherical) {
            this.esp = this.scaleFactor;
            this.ml0 = 0.5 * this.esp;
        } else {
            this.en = TransverseMercator.enfn(this.es);
            this.ml0 = TransverseMercator.mlfn(this.projectionLatitude, Math.sin(this.projectionLatitude), Math.cos(this.projectionLatitude), this.en);
            this.esp = this.es / (1.0 - this.es);
        }
    }

    public static double asin(double v) {
        if (Math.abs(v) > 1.0) {
            return v < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
        }
        return Math.asin(v);
    }

    public static double acos(double v) {
        if (Math.abs(v) > 1.0) {
            return v < 0.0 ? Math.PI : 0.0;
        }
        return Math.acos(v);
    }

    public double[] project(double lplam, double lpphi, double[] xy) {
        if (this.spherical) {
            double cosphi = Math.cos(lpphi);
            double b = cosphi * Math.sin(lplam);
            xy[0] = this.ml0 * this.scaleFactor * Math.log((1.0 + b) / (1.0 - b));
            double ty = cosphi * Math.cos(lplam) / Math.sqrt(1.0 - b * b);
            ty = TransverseMercator.acos(ty);
            if (lpphi < 0.0) {
                ty = -ty;
            }
            xy[1] = this.esp * (ty - this.projectionLatitude);
        } else {
            double sinphi = Math.sin(lpphi);
            double cosphi = Math.cos(lpphi);
            double t = Math.abs(cosphi) > 1.0E-10 ? sinphi / cosphi : 0.0;
            t *= t;
            double al = cosphi * lplam;
            double als = al * al;
            double n = this.esp * cosphi * cosphi;
            xy[0] = this.scaleFactor * (al /= Math.sqrt(1.0 - this.es * sinphi * sinphi)) * (1.0 + 0.16666666666666666 * als * (1.0 - t + n + 0.05 * als * (5.0 + t * (t - 18.0) + n * (14.0 - 58.0 * t) + 0.023809523809523808 * als * (61.0 + t * (t * (179.0 - t) - 479.0)))));
            xy[1] = this.scaleFactor * (TransverseMercator.mlfn(lpphi, sinphi, cosphi, this.en) - this.ml0 + sinphi * al * lplam * 0.5 * (1.0 + 0.08333333333333333 * als * (5.0 - t + n * (9.0 + 4.0 * n) + 0.03333333333333333 * als * (61.0 + t * (t - 58.0) + n * (270.0 - 330.0 * t) + 0.017857142857142856 * als * (1385.0 + t * (t * (543.0 - t) - 3111.0))))));
        }
        return xy;
    }

    public double[] projectInverse(double x, double y, double[] out) {
        if (this.spherical) {
            double h = Math.exp(x / this.scaleFactor);
            double g = 0.5 * (h - 1.0 / h);
            h = Math.cos(this.projectionLatitude + y / this.scaleFactor);
            out[1] = TransverseMercator.asin(Math.sqrt((1.0 - h * h) / (1.0 + g * g)));
            if (y < 0.0) {
                out[1] = -out[1];
            }
            out[0] = Math.atan2(g, h);
        } else {
            out[1] = TransverseMercator.inv_mlfn(this.ml0 + y / this.scaleFactor, this.es, this.en);
            if (Math.abs(y) >= 1.5707963267948966) {
                out[1] = y < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
                out[0] = 0.0;
            } else {
                double sinphi = Math.sin(out[1]);
                double cosphi = Math.cos(out[1]);
                double t = Math.abs(cosphi) > 1.0E-10 ? sinphi / cosphi : 0.0;
                double n = this.esp * cosphi * cosphi;
                double con = 1.0 - this.es * sinphi * sinphi;
                double d = x * Math.sqrt(con) / this.scaleFactor;
                con *= t;
                t *= t;
                double ds = d * d;
                out[1] = out[1] - con * ds / (1.0 - this.es) * 0.5 * (1.0 - ds * 0.08333333333333333 * (5.0 + t * (3.0 - 9.0 * n) + n * (1.0 - 4.0 * n) - ds * 0.03333333333333333 * (61.0 + t * (90.0 - 252.0 * n + 45.0 * t) + 46.0 * n - ds * 0.017857142857142856 * (1385.0 + t * (3633.0 + t * (4095.0 + 1574.0 * t))))));
                out[0] = d * (1.0 - ds * 0.16666666666666666 * (1.0 + 2.0 * t + n - ds * 0.05 * (5.0 + t * (28.0 + 24.0 * t + 8.0 * n) + 6.0 * n - ds * 0.023809523809523808 * (61.0 + t * (662.0 + t * (1320.0 + 720.0 * t)))))) / cosphi;
            }
        }
        return out;
    }

    public ProjectionPoint latLonToProj(LatLonPoint latlon, ProjectionPointImpl destPoint) {
        double x = latlon.getLongitude() * (Math.PI / 180);
        if (this.projectionLongitude != 0.0) {
            x = TransverseMercator.normalizeLongitude(x - this.projectionLongitude);
        }
        double[] dst = this.project(x, latlon.getLatitude() * (Math.PI / 180), new double[2]);
        dst[0] = this.totalScale * dst[0] + this.totalFalseEasting;
        dst[1] = this.totalScale * dst[1] + this.totalFalseNorthing;
        return new ProjectionPointImpl(dst[0], dst[1]);
    }

    public LatLonPoint projToLatLon(ProjectionPoint ppt, LatLonPointImpl destPoint) {
        double y;
        double x = (ppt.getX() - this.totalFalseEasting) / this.totalScale;
        double[] dst = this.projectInverse(x, y = (ppt.getY() - this.totalFalseNorthing) / this.totalScale, new double[2]);
        if (dst[0] < -Math.PI) {
            dst[0] = -Math.PI;
        } else if (dst[0] > Math.PI) {
            dst[0] = Math.PI;
        }
        if (this.projectionLongitude != 0.0) {
            dst[0] = TransverseMercator.normalizeLongitude(dst[0] + this.projectionLongitude);
        }
        dst[0] = dst[0] * 57.29577951308232;
        dst[1] = dst[1] * 57.29577951308232;
        return new LatLonPointImpl(dst[1], dst[0]);
    }
}

