/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.geoloc.projection;

import oruxmapsdesktop.calculadora.PuntoCalibracionMapa;
import oruxmapsdesktop.geoloc.LatLonPoint;
import oruxmapsdesktop.geoloc.LatLonPointImpl;
import oruxmapsdesktop.geoloc.ParametrosProyeccion;
import oruxmapsdesktop.geoloc.ProjectionImpl;
import oruxmapsdesktop.geoloc.ProjectionPoint;
import oruxmapsdesktop.geoloc.ProjectionPointImpl;
import oruxmapsdesktop.geoloc.projection.GdcToUtmConverter;

public class UtmProjection
extends ProjectionImpl {
    private GdcToUtmConverter convert2latlon;
    private GdcToUtmConverter convert2xy;

    public UtmProjection(double a, double f, int zone, boolean isNorth) {
        this.convert2latlon = new GdcToUtmConverter(a, f, zone, isNorth);
        this.convert2xy = new GdcToUtmConverter(a, f, zone, isNorth);
        this.requiereConversionDatum = true;
        this.name = "UTM";
        this.tieneParametros = true;
    }

    public UtmProjection(ParametrosProyeccion params) {
        this(params.ell.EquatorialRadius, 1.0 / params.ell.invFlatt, params.zona, params.norte);
    }

    public int getZone() {
        return this.convert2latlon.getZone();
    }

    public void setZone(int newZone) {
        this.convert2latlon = new GdcToUtmConverter(this.convert2latlon.getA(), 1.0 / this.convert2latlon.getF(), newZone, this.convert2latlon.isNorth());
        this.convert2xy = new GdcToUtmConverter(this.convert2latlon.getA(), 1.0 / this.convert2latlon.getF(), this.convert2latlon.getZone(), this.convert2latlon.isNorth());
    }

    public boolean isNorth() {
        return this.convert2latlon.isNorth();
    }

    public void setNorth(boolean newNorth) {
        this.convert2latlon = new GdcToUtmConverter(this.convert2latlon.getA(), 1.0 / this.convert2latlon.getF(), this.convert2latlon.getZone(), newNorth);
        this.convert2xy = new GdcToUtmConverter(this.convert2latlon.getA(), 1.0 / this.convert2latlon.getF(), this.convert2latlon.getZone(), newNorth);
    }

    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        return this.convert2xy.latLonToProj(fromLat, fromLon, result);
    }

    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        return this.convert2latlon.projToLatLon(world.getX(), world.getY(), result);
    }

    public static int longitudeZone(double lon) {
        double LongTemp = lon + 180.0 - (double)((int)((lon + 180.0) / 360.0) * 360) - 180.0;
        return (int)((LongTemp + 180.0) / 6.0) + 1;
    }

    public void normalizaZona(PuntoCalibracionMapa a) {
        int z = this.getZone();
        if (a.grid != null && a.grid.length() > 0 && !String.valueOf(this.getZone()).equals(a.grid)) {
            this.setZone(Integer.parseInt(a.grid));
            LatLonPointImpl llp = this.projToLatLon(a.xEast, a.yNorth);
            this.setZone(z);
            ProjectionPoint res = this.latLonToProj(llp);
            a.xEast = res.getX();
            a.yNorth = res.getY();
        }
    }

    public static char UTMLetterDesignator(double Lat) {
        int LetterDesignator = 84.0 >= Lat && Lat >= 72.0 ? 88 : (72.0 > Lat && Lat >= 64.0 ? 87 : (64.0 > Lat && Lat >= 56.0 ? 86 : (56.0 > Lat && Lat >= 48.0 ? 85 : (48.0 > Lat && Lat >= 40.0 ? 84 : (40.0 > Lat && Lat >= 32.0 ? 83 : (32.0 > Lat && Lat >= 24.0 ? 82 : (24.0 > Lat && Lat >= 16.0 ? 81 : (16.0 > Lat && Lat >= 8.0 ? 80 : (8.0 > Lat && Lat >= 0.0 ? 78 : (0.0 > Lat && Lat >= -8.0 ? 77 : (-8.0 > Lat && Lat >= -16.0 ? 76 : (-16.0 > Lat && Lat >= -24.0 ? 75 : (-24.0 > Lat && Lat >= -32.0 ? 74 : (-32.0 > Lat && Lat >= -40.0 ? 72 : (-40.0 > Lat && Lat >= -48.0 ? 71 : (-48.0 > Lat && Lat >= -56.0 ? 70 : (-56.0 > Lat && Lat >= -64.0 ? 69 : (-64.0 > Lat && Lat >= -72.0 ? 68 : (-72.0 > Lat && Lat >= -80.0 ? 67 : 90)))))))))))))))))));
        return (char)LetterDesignator;
    }
}

