/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.utilidades;

import java.awt.Component;
import java.io.File;
import java.io.FileFilter;
import javax.swing.JFileChooser;

public class FileUtils {
    public static final String[] imageType = new String[]{".png", ".bmp", ".jpg", ".jpeg", ".tif", ".tiff", ".gif"};

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static String buscaImagen(File cal, String root, String[] imageType) {
        String res = null;
        if (cal != null && cal.isDirectory()) {
            for (File f : cal.listFiles()) {
                for (String s : imageType) {
                    String test = (root + s).toLowerCase();
                    if (!test.equals(f.getName().toLowerCase())) continue;
                    return root + s;
                }
            }
        }
        return res;
    }

    public static File seleccionaDirectorio(Component parent, String inicio) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setSelectedFile(new File(inicio + File.separator + "."));
        fileChooser.setFileSelectionMode(1);
        fileChooser.setAcceptAllFileFilterUsed(false);
        int i = fileChooser.showOpenDialog(parent);
        if (i == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    public static class MyFilterDir
    implements FileFilter {
        public boolean accept(File file) {
            return file.isDirectory();
        }
    }

    public static class MyFilterImage
    extends javax.swing.filechooser.FileFilter {
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String filename = file.getName().toLowerCase();
            return filename.endsWith(".jpg") || filename.endsWith(".jpeg") || filename.endsWith(".png") || filename.endsWith(".bmp") || filename.endsWith(".tiff") || filename.endsWith(".tif") || filename.endsWith(".gif");
        }

        public String getDescription() {
            return "*.jpg, *.bmp, *.png, *.jpeg, *.gif, *.tif";
        }
    }

    public static class MyFilterMapDB
    implements FileFilter {
        public boolean accept(File file) {
            String filename = file.getName();
            return filename.equals("OruxMapsImages.db");
        }
    }

    public static class MyFilterMap2
    implements FileFilter {
        public boolean accept(File file) {
            String filename = file.getName().toLowerCase();
            return filename.endsWith(".okm") || filename.endsWith(".map") || filename.endsWith(".tfw") || filename.endsWith(".jpw") || filename.endsWith(".tfwx") || filename.endsWith(".tif") || filename.endsWith(".tiff") || filename.endsWith(".pgw") || filename.endsWith(".kap");
        }
    }

    public static class MyFilterMap
    extends javax.swing.filechooser.FileFilter {
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String filename = file.getName().toLowerCase();
            return filename.endsWith(".okm") || filename.endsWith(".map") || filename.endsWith(".tfw") || filename.endsWith(".jpw") || filename.endsWith(".tfwx") || filename.endsWith(".tif") || filename.endsWith(".tiff") || filename.endsWith(".pgw") || filename.endsWith(".kap");
        }

        public String getDescription() {
            return "*.map, *.pgw, *.tfw, *.jpw, *.kap, *.tif, *.okm";
        }
    }
}

