/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.utilidades;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jdesktop.application.Application;
import oruxmapsdesktop.JPanelCalculator;
import oruxmapsdesktop.OruxMapsDesktopApp;
import oruxmapsdesktop.calculadora.MapaOruxMaps;
import oruxmapsdesktop.calculadora.PuntoCalibracionMapa;
import ucar.nc2.geotiff.GeoKey;
import ucar.nc2.geotiff.GeoTiff;
import ucar.nc2.geotiff.IFDEntry;

public class GeoTiffReader {
    public static String result;

    public static MapaOruxMaps lee(File file) throws Exception {
        MapaOruxMaps mc = new MapaOruxMaps();
        mc.dirImg = file.getAbsolutePath();
        GeoTiff gt = new GeoTiff(file.getAbsolutePath());
        gt.read();
        result = gt.showInfo();
        List<IFDEntry> tags = gt.getTags();
        int geo = -1;
        int width = 0;
        int height = 0;
        double x = 0.0;
        double y = 0.0;
        double xVal = 0.0;
        double yVal = 0.0;
        double xInc = 0.0;
        double yInc = 0.0;
        for (IFDEntry tag : tags) {
            double[] inc;
            int t = tag.getTag().getCode();
            if (t == 34735) {
                ArrayList geokeys = tag.getGeokeys();
                if (geokeys == null) continue;
                for (Object gk : geokeys) {
                    GeoKey g = (GeoKey)gk;
                    switch (g.tagCode()) {
                        case 1024: {
                            geo = g.value();
                            break;
                        }
                    }
                }
                continue;
            }
            if (t == 33550) {
                inc = tag.getValueD();
                xInc = inc[0];
                yInc = inc[1];
                continue;
            }
            if (t == 33922) {
                inc = tag.getValueD();
                x = inc[0];
                y = inc[1];
                xVal = inc[3];
                yVal = inc[4];
                continue;
            }
            if (t == 256) {
                width = tag.getValue()[0];
                continue;
            }
            if (t != 257) continue;
            height = tag.getValue()[0];
        }
        mc.altoImagen = height;
        mc.anchoImagen = width;
        PuntoCalibracionMapa ptemp = new PuntoCalibracionMapa();
        mc.puntosCalibracionA.add(ptemp);
        PuntoCalibracionMapa ptemp2 = new PuntoCalibracionMapa();
        mc.puntosCalibracionA.add(ptemp2);
        ptemp.x = (int)x;
        ptemp.y = (int)y;
        ptemp2.x = width - 1;
        ptemp2.y = height - 1;
        if (geo == 1) {
            ptemp.xEast = xVal;
            ptemp.yNorth = yVal;
            ptemp2.xEast = xVal + xInc * (double)(width - ptemp.x - 1);
            ptemp2.yNorth = yVal - yInc * (double)(height - ptemp.y - 1);
        } else if (geo == 2) {
            ptemp.xLon = xVal;
            ptemp.yLat = yVal;
            ptemp2.xLon = xVal + xInc * (double)(width - ptemp.x - 1);
            ptemp2.yLat = yVal - yInc * (double)(height - ptemp.y - 1);
        } else {
            String s = Application.getInstance(OruxMapsDesktopApp.class).getContext().getResourceMap(JPanelCalculator.class).getString("crs_bad", new Object[0]);
            throw new Exception(s);
        }
        ptemp.northing = true;
        ptemp2.northing = true;
        String nombre = file.getName().trim();
        int cont2 = nombre.length();
        mc.nombreMapa = nombre.toLowerCase().endsWith("tif") ? nombre.substring(0, cont2 - 4) : (nombre.toLowerCase().endsWith("tiff") ? nombre.substring(0, cont2 - 5) : nombre);
        return mc;
    }
}

