/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.utilidades;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import oruxmapsdesktop.calculadora.DatumAdmin;
import oruxmapsdesktop.calculadora.MapaOruxMaps;
import oruxmapsdesktop.calculadora.PuntoCalibracionMapa;
import oruxmapsdesktop.utilidades.OziReader;

public class KapReader {
    public static MapaOruxMaps lee(File f, int ancho, int alto) throws Exception {
        MapaOruxMaps mc = new MapaOruxMaps();
        BufferedReader input = new BufferedReader(new FileReader(f));
        String line = null;
        ArrayList<PuntoCalibracionMapa> puntos = new ArrayList<PuntoCalibracionMapa>();
        boolean inREF = false;
        boolean finREF = false;
        try {
            line = input.readLine();
            while (line != null && !finREF) {
                String nextLine = input.readLine();
                while (nextLine.startsWith(" ") || nextLine.startsWith("\t")) {
                    line = line + nextLine;
                    nextLine = input.readLine();
                }
                if ((line = line.trim().toUpperCase()).length() > 0 && line.startsWith("KNP/")) {
                    if (line.contains("PR=MERCATOR")) {
                        mc.proyeccion = 3;
                        mc.proyeccionData = "0.0";
                    } else if (line.contains("PR=POLYCONIC")) {
                        mc.proyeccion = 10;
                        String[] tok = line.split(",");
                        for (int i = 0; i < tok.length; ++i) {
                            if (!tok[i].trim().startsWith("PP=")) continue;
                            mc.proyeccionData = tok[i].substring(3, tok[i].length()) + "," + "0.0" + "," + "0.0";
                            break;
                        }
                    } else if (line.contains("PR=TRANSVERSE")) {
                        mc.proyeccion = 9;
                        double lat_or = 0.0;
                        double lon_or = 0.0;
                        double k = 1.0;
                        double false_e = 0.0;
                        double false_n = 0.0;
                        String[] tok = line.split("[,\\s]");
                        for (int i = 0; i < tok.length; ++i) {
                            if (tok[i].trim().startsWith("PP=")) {
                                lon_or = Double.parseDouble(tok[i].substring(3, tok[i].length()).trim());
                                continue;
                            }
                            if (tok[i].trim().startsWith("P1=")) {
                                lat_or = Double.parseDouble(tok[i].substring(3, tok[i].length()).trim());
                                continue;
                            }
                            if (tok[i].trim().startsWith("P2=")) {
                                k = Double.parseDouble(tok[i].substring(3, tok[i].length()).trim());
                                continue;
                            }
                            if (tok[i].trim().startsWith("P3=")) {
                                false_e = Double.parseDouble(tok[i].substring(3, tok[i].length()).trim());
                                continue;
                            }
                            if (!tok[i].trim().startsWith("P4=")) continue;
                            false_n = Double.parseDouble(tok[i].substring(3, tok[i].length()).trim());
                        }
                        mc.proyeccionData = "" + lon_or + "," + lat_or + "," + k + "," + false_e + "," + false_n;
                    }
                    if (line.contains("GD=NAD83")) {
                        mc.datum = DatumAdmin.busca("North American 1983");
                    } else if (line.contains("GD=WGS84")) {
                        mc.datum = DatumAdmin.busca("WGS 1984Global Definition");
                    }
                } else if (line.length() > 0 && line.startsWith("REF/")) {
                    inREF = true;
                    String[] coord = line.split(",");
                    if (coord.length != 5) continue;
                    PuntoCalibracionMapa pt = new PuntoCalibracionMapa();
                    pt.x = Integer.parseInt(coord[1].trim());
                    pt.y = Integer.parseInt(coord[2].trim());
                    pt.xLon = Double.parseDouble(coord[4]);
                    pt.yLat = Double.parseDouble(coord[3]);
                    puntos.add(pt);
                } else if (inREF) {
                    finREF = true;
                }
                line = nextLine;
            }
            if (puntos.size() < 2) {
                throw new Exception("");
            }
            OziReader.recolocaPuntos(puntos);
            mc.puntosCalibracionA = puntos;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        mc.altoImagen = alto;
        mc.anchoImagen = ancho;
        int cont2 = f.getName().length();
        mc.nombreMapa = f.getName().substring(0, cont2 - 4);
        return mc;
    }
}

