/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.utilidades;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import oruxmapsdesktop.calculadora.Datum;
import oruxmapsdesktop.calculadora.DatumAdmin;
import oruxmapsdesktop.calculadora.Ellipsoid;
import oruxmapsdesktop.calculadora.MapaOruxMaps;
import oruxmapsdesktop.calculadora.PuntoCalibracionMapa;
import oruxmapsdesktop.geoloc.ProjectionAdmin;

public class OkmReader {
    private static HashMap<String, Datum> datums;

    public static MapaOruxMaps lee(File file) throws Exception {
        MapaOruxMaps mc = new MapaOruxMaps();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        String encode = "utf-8";
        InputSource inputSource = new InputSource(new FileInputStream(file));
        inputSource.setEncoding(encode);
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document xml = parser.parse(inputSource);
        Element root = xml.getDocumentElement();
        if (root == null) {
            throw new Exception();
        }
        String s = root.getLocalName();
        if (!s.equals("map")) {
            throw new Exception();
        }
        Element nDocument = (Element)xml.getElementsByTagName("metadata").item(0);
        Element n = (Element)nDocument.getElementsByTagName("name").item(0);
        mc.nombreMapa = n != null ? ((Text)n.getFirstChild()).getNodeValue() : file.getName().substring(0, file.getName().length() - 4);
        n = (Element)xml.getElementsByTagName("filename").item(0);
        mc.dirImg = file.getAbsolutePath() + File.separator + ((Text)n.getFirstChild()).getNodeValue();
        n = (Element)nDocument.getElementsByTagName("bounds").item(0);
        mc.bounds[1] = Double.parseDouble(n.getAttribute("maxlat"));
        mc.bounds[3] = Double.parseDouble(n.getAttribute("maxlon"));
        mc.bounds[0] = Double.parseDouble(n.getAttribute("minlat"));
        mc.bounds[2] = Double.parseDouble(n.getAttribute("minlon"));
        nDocument = (Element)xml.getElementsByTagName("size").item(0);
        n = (Element)nDocument.getElementsByTagName("width").item(0);
        mc.anchoImagen = Integer.parseInt(((Text)n.getFirstChild()).getNodeValue());
        n = (Element)nDocument.getElementsByTagName("height").item(0);
        mc.altoImagen = Integer.parseInt(((Text)n.getFirstChild()).getNodeValue());
        nDocument = (Element)xml.getElementsByTagName("datum").item(0);
        String datum = ((Text)nDocument.getFirstChild()).getNodeValue();
        mc.datum = DatumAdmin.WGS84Datum().indice;
        nDocument = (Element)xml.getElementsByTagName("proj").item(0);
        n = (Element)nDocument.getElementsByTagName("name").item(0);
        String proj = ((Text)n.getFirstChild()).getNodeValue();
        mc.proyeccion = ProjectionAdmin.determinaProjection(proj, null, 1);
        n = (Element)nDocument.getElementsByTagName("falseEasting").item(0);
        double falseE = Double.parseDouble(((Text)n.getFirstChild()).getNodeValue());
        n = (Element)nDocument.getElementsByTagName("falseNorthing").item(0);
        double falseN = Double.parseDouble(((Text)n.getFirstChild()).getNodeValue());
        n = (Element)nDocument.getElementsByTagName("centerLon").item(0);
        double centerlon = Double.parseDouble(((Text)n.getFirstChild()).getNodeValue());
        n = (Element)nDocument.getElementsByTagName("centerLat").item(0);
        double centerlat = Double.parseDouble(((Text)n.getFirstChild()).getNodeValue());
        n = (Element)nDocument.getElementsByTagName("scaleX").item(0);
        double scaleX = Double.parseDouble(((Text)n.getFirstChild()).getNodeValue());
        n = (Element)nDocument.getElementsByTagName("scaleY").item(0);
        double scaleY = Double.parseDouble(((Text)n.getFirstChild()).getNodeValue());
        n = (Element)nDocument.getElementsByTagName("centerLineAzimuth").item(0);
        double centerLineAzimuth = Double.parseDouble(((Text)n.getFirstChild()).getNodeValue());
        n = (Element)nDocument.getElementsByTagName("centerLineBearing").item(0);
        double centerLineBearing = Double.parseDouble(((Text)n.getFirstChild()).getNodeValue());
        n = (Element)nDocument.getElementsByTagName("firstStdLat").item(0);
        double std1 = Double.parseDouble(((Text)n.getFirstChild()).getNodeValue());
        n = (Element)nDocument.getElementsByTagName("secondStdLat").item(0);
        double std2 = Double.parseDouble(((Text)n.getFirstChild()).getNodeValue());
        mc.proyeccionData = OkmReader.getProjData(mc.proyeccion, falseE, falseN, centerlat, centerlon, scaleX, scaleY, centerLineAzimuth, centerLineBearing, std1, std2);
        Datum dt = OkmReader.getDatum(datum);
        double[] from = new double[]{0.0, 0.0};
        double[] res = new double[]{0.0, 0.0};
        from[0] = mc.bounds[1];
        from[1] = mc.bounds[2];
        dt.toWGS84(from, res);
        mc.bounds[1] = res[0];
        mc.bounds[2] = res[1];
        from[0] = mc.bounds[0];
        from[1] = mc.bounds[3];
        dt.toWGS84(from, res);
        mc.bounds[3] = res[1];
        mc.bounds[0] = res[0];
        NodeList nl = xml.getElementsByTagName("grefpnt");
        int cont = nl.getLength();
        for (int i = 0; i < cont; ++i) {
            PuntoCalibracionMapa mcp = new PuntoCalibracionMapa();
            n = (Element)((Element)nl.item(i)).getElementsByTagName("x").item(0);
            mcp.x = Integer.parseInt(((Text)n.getFirstChild()).getNodeValue());
            n = (Element)((Element)nl.item(i)).getElementsByTagName("y").item(0);
            mcp.y = Integer.parseInt(((Text)n.getFirstChild()).getNodeValue());
            n = (Element)((Element)nl.item(i)).getElementsByTagName("lon").item(0);
            mcp.xLon = Double.parseDouble(((Text)n.getFirstChild()).getNodeValue());
            n = (Element)((Element)nl.item(i)).getElementsByTagName("lat").item(0);
            from[0] = mcp.yLat = Double.parseDouble(((Text)n.getFirstChild()).getNodeValue());
            from[1] = mcp.xLon;
            dt.toWGS84(from, res);
            mcp.xLon = res[1];
            mcp.yLat = res[0];
            mc.puntosCalibracionA.add(mcp);
        }
        return mc;
    }

    private static String getProjData(int proj, double falseE, double falseN, double centerlat, double centerlon, double scaleX, double scaleY, double centerLineAzimuth, double centerLineBearing, double std1, double std2) {
        String salida = "";
        switch (proj) {
            case 8: {
                if (std1 == 0.0 || std2 == 0.0) {
                    std1 = centerlat;
                    std2 = centerlat;
                }
                salida = salida + String.valueOf(centerlat) + "," + centerlon + "," + std1 + "," + std2 + "," + falseE + "," + falseN;
                break;
            }
            case 9: {
                salida = salida + String.valueOf(centerlon) + "," + centerlat + "," + scaleY + "," + falseE + "," + falseN;
                break;
            }
            case 3: {
                salida = salida + String.valueOf(centerlon);
                break;
            }
        }
        return salida;
    }

    private static Datum getDatum(String nombre) {
        if (datums == null) {
            OkmReader.initDatums();
        }
        return datums.get(nombre);
    }

    private static void initDatums() {
        try {
            datums = new HashMap();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            String encode = "utf-8";
            InputSource inputSource = new InputSource(new FileInputStream("okmdatums.xml"));
            inputSource.setEncoding(encode);
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document xml = parser.parse(inputSource);
            NodeList nl = xml.getElementsByTagName("datum");
            int cont = nl.getLength();
            for (int i = 0; i < cont; ++i) {
                Ellipsoid ell;
                Datum dt = new Datum();
                Element n = (Element)((Element)nl.item(i)).getElementsByTagName("name").item(0);
                dt.datum = ((Text)n.getFirstChild()).getNodeValue();
                n = (Element)((Element)nl.item(i)).getElementsByTagName("centerX").item(0);
                dt.dX = Double.parseDouble(((Text)n.getFirstChild()).getNodeValue());
                n = (Element)((Element)nl.item(i)).getElementsByTagName("centerY").item(0);
                dt.dY = Double.parseDouble(((Text)n.getFirstChild()).getNodeValue());
                n = (Element)((Element)nl.item(i)).getElementsByTagName("centerZ").item(0);
                dt.dZ = Double.parseDouble(((Text)n.getFirstChild()).getNodeValue());
                n = (Element)((Element)nl.item(i)).getElementsByTagName("rotationX").item(0);
                dt.Rx = Double.parseDouble(((Text)n.getFirstChild()).getNodeValue());
                n = (Element)((Element)nl.item(i)).getElementsByTagName("rotationY").item(0);
                dt.Ry = Double.parseDouble(((Text)n.getFirstChild()).getNodeValue());
                n = (Element)((Element)nl.item(i)).getElementsByTagName("rotationZ").item(0);
                dt.Rz = Double.parseDouble(((Text)n.getFirstChild()).getNodeValue());
                n = (Element)((Element)nl.item(i)).getElementsByTagName("scaling").item(0);
                dt.e = Double.parseDouble(((Text)n.getFirstChild()).getNodeValue()) * 1.0E-6;
                n = (Element)((Element)nl.item(i)).getElementsByTagName("ellipsoid").item(0);
                String elln = ((Text)n.getFirstChild()).getNodeValue();
                n = (Element)((Element)nl.item(i)).getElementsByTagName("rMajor").item(0);
                double maj = Double.parseDouble(((Text)n.getFirstChild()).getNodeValue());
                n = (Element)((Element)nl.item(i)).getElementsByTagName("eccentricitySec").item(0);
                double ecc = Double.parseDouble(((Text)n.getFirstChild()).getNodeValue());
                n = (Element)((Element)nl.item(i)).getElementsByTagName("invFlattening").item(0);
                double invf = Double.parseDouble(((Text)n.getFirstChild()).getNodeValue());
                dt.ell = ell = new Ellipsoid(0, elln, maj, ecc, invf);
                datums.put(dt.datum, dt);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

