/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.utilidades;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.text.Normalizer;
import oruxmapsdesktop.calculadora.DatumAdmin;
import oruxmapsdesktop.calculadora.MapaOruxMaps;
import oruxmapsdesktop.geoloc.ProjectionAdmin;

public class OruxMapsWriter {
    private static int DEFAULT_SIZE = 512;
    private static final DecimalFormat formatter00 = new DecimalFormat("00");

    public static void creaOtrk2(MapaOruxMaps mc, String dir) throws Exception {
        mc.nombreMapa = Normalizer.normalize(mc.nombreMapa, Normalizer.Form.NFC);
        OruxMapsWriter.creaOtrk2Raiz(mc.nombreMapa, 0, dir + File.separator + mc.nombreMapa);
        int factor = 1;
        for (int k = 0; k < mc.capas.length; ++k) {
            if (mc.capas[k]) {
                BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dir + File.separator + mc.nombreMapa + File.separator + mc.nombreMapa + " " + formatter00.format(mc.nivelZoom - k) + File.separator + mc.nombreMapa + " " + formatter00.format(mc.nivelZoom - k) + ".otrk2.xml"), "UTF8"));
                fw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                fw.write("<OruxTracker xmlns=\"http://oruxtracker.com/app/res/calibration\"\n versionCode=\"2.1\">\n");
                fw.write("<MapCalibration layers=\"false\" layerLevel=\"" + (mc.nivelZoom - k) + "\">\n");
                fw.write("<MapName><![CDATA[" + mc.nombreMapa + " " + formatter00.format(mc.nivelZoom - k) + "]]></MapName>\n");
                fw.write("<MapChunks xMax=\"" + ((mc.anchoImagen / factor - 1) / DEFAULT_SIZE + 1) + "\" yMax=\"" + ((mc.altoImagen / factor - 1) / DEFAULT_SIZE + 1) + "\" datum=\"" + DatumAdmin.dameDatums()[mc.datum].datum + ":" + DatumAdmin.dameDatums()[mc.datum].region + "@" + DatumAdmin.WGS84Datum().datum + ":" + DatumAdmin.WGS84Datum().region + "\" projection=\"" + ProjectionAdmin.PROJECTIONS_NAME[mc.proyeccion] + (mc.proyeccionData == null ? "" : "," + mc.proyeccionData) + "\" img_height=\"" + DEFAULT_SIZE + "\" img_width=\"" + DEFAULT_SIZE + "\" file_name=\"" + mc.nombreMapa + " " + formatter00.format(mc.nivelZoom - k) + "\" />\n");
                fw.write("<MapDimensions height=\"" + mc.altoImagen / factor + "\" width=\"" + mc.anchoImagen / factor + "\" />\n");
                fw.write("<MapBounds minLat=\"" + (mc.puntosCalibracionFinales[1].yLat < mc.puntosCalibracionFinales[3].yLat ? mc.puntosCalibracionFinales[1].yLat : mc.puntosCalibracionFinales[3].yLat) + "\" maxLat=\"" + (mc.puntosCalibracionFinales[0].yLat > mc.puntosCalibracionFinales[2].yLat ? mc.puntosCalibracionFinales[0].yLat : mc.puntosCalibracionFinales[2].yLat) + "\" minLon=\"" + (mc.puntosCalibracionFinales[0].xLon < mc.puntosCalibracionFinales[3].xLon ? mc.puntosCalibracionFinales[0].xLon : mc.puntosCalibracionFinales[3].xLon) + "\" maxLon=\"" + (mc.puntosCalibracionFinales[1].xLon > mc.puntosCalibracionFinales[2].xLon ? mc.puntosCalibracionFinales[1].xLon : mc.puntosCalibracionFinales[2].xLon) + "\" />\n");
                fw.write("<CalibrationPoints>\n");
                fw.write("<CalibrationPoint corner=\"TL\" lon=\"" + mc.puntosCalibracionFinales[0].xLon + "\" lat=\"" + mc.puntosCalibracionFinales[0].yLat + "\" />\n");
                fw.write("<CalibrationPoint corner=\"BR\" lon=\"" + mc.puntosCalibracionFinales[1].xLon + "\" lat=\"" + mc.puntosCalibracionFinales[1].yLat + "\" />\n");
                fw.write("<CalibrationPoint corner=\"TR\" lon=\"" + mc.puntosCalibracionFinales[2].xLon + "\" lat=\"" + mc.puntosCalibracionFinales[2].yLat + "\" />\n");
                fw.write("<CalibrationPoint corner=\"BL\" lon=\"" + mc.puntosCalibracionFinales[3].xLon + "\" lat=\"" + mc.puntosCalibracionFinales[3].yLat + "\" />\n");
                fw.write("</CalibrationPoints>\n");
                fw.write("</MapCalibration>\n");
                fw.write("</OruxTracker>\n");
                fw.close();
            }
            factor *= 2;
        }
    }

    public static void creaOtrk2Raiz(String nombre, int tile, String dir) throws Exception {
        String mapName = Normalizer.normalize(nombre, Normalizer.Form.NFC);
        BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dir + File.separator + mapName + ".otrk2.xml"), "UTF8"));
        fw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        fw.write("<OruxTracker xmlns=\"http://oruxtracker.com/app/res/calibration\"\n versionCode=\"2.1\">\n");
        fw.write("<MapCalibration layers=\"true\" layerLevel=\"" + tile + "\">\n");
        fw.write("<MapName><![CDATA[" + mapName + "]]></MapName>\n");
        fw.write("</MapCalibration>\n");
        fw.write("</OruxTracker>\n");
        fw.close();
    }

    public static void creaOtrk3(MapaOruxMaps mc, String dir) throws Exception {
        mc.nombreMapa = Normalizer.normalize(mc.nombreMapa, Normalizer.Form.NFC);
        BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dir + File.separator + mc.nombreMapa + File.separator + mc.nombreMapa + ".otrk2.xml"), "UTF8"));
        fw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        fw.write("<OruxTracker xmlns:orux=\"http://oruxtracker.com/app/res/calibration\"\n versionCode=\"3.0\">\n");
        fw.write("<MapCalibration layers=\"true\" layerLevel=\"0\">\n");
        fw.write("<MapName><![CDATA[" + mc.nombreMapa + "]]></MapName>\n");
        int factor = 1;
        for (int k = 0; k < mc.capas.length; ++k) {
            if (mc.capas[k]) {
                fw.write(OruxMapsWriter.prepareOtrk2File(mc, k, factor));
            }
            factor *= 2;
        }
        fw.write("</MapCalibration>\n");
        fw.write("</OruxTracker>\n");
        fw.flush();
        fw.close();
    }

    protected static String prepareOtrk2File(MapaOruxMaps mc, int z, int factor) {
        StringBuilder fw = new StringBuilder();
        fw.append("<OruxTracker versionCode=\"2.1\">\n");
        fw.append("<MapCalibration layers=\"false\" layerLevel=\"" + (mc.nivelZoom - z) + "\">\n");
        fw.append("<MapName><![CDATA[" + mc.nombreMapa + " " + formatter00.format(mc.nivelZoom - z) + "]]></MapName>\n");
        fw.append("<MapChunks xMax=\"" + ((mc.anchoImagen / factor - 1) / DEFAULT_SIZE + 1) + "\" yMax=\"" + ((mc.altoImagen / factor - 1) / DEFAULT_SIZE + 1) + "\" datum=\"" + DatumAdmin.dameDatums()[mc.datum].datum + ":" + DatumAdmin.dameDatums()[mc.datum].region + "@" + DatumAdmin.WGS84Datum().datum + ":" + DatumAdmin.WGS84Datum().region + "\" projection=\"" + ProjectionAdmin.PROJECTIONS_NAME[mc.proyeccion] + (mc.proyeccionData == null ? "" : "," + mc.proyeccionData) + "\" img_height=\"" + DEFAULT_SIZE + "\" img_width=\"" + DEFAULT_SIZE + "\" file_name=\"" + mc.nombreMapa + " " + formatter00.format(mc.nivelZoom - z) + "\" />\n");
        fw.append("<MapDimensions height=\"" + mc.altoImagen / factor + "\" width=\"" + mc.anchoImagen / factor + "\" />\n");
        fw.append("<MapBounds minLat=\"" + (mc.puntosCalibracionFinales[1].yLat < mc.puntosCalibracionFinales[3].yLat ? mc.puntosCalibracionFinales[1].yLat : mc.puntosCalibracionFinales[3].yLat) + "\" maxLat=\"" + (mc.puntosCalibracionFinales[0].yLat > mc.puntosCalibracionFinales[2].yLat ? mc.puntosCalibracionFinales[0].yLat : mc.puntosCalibracionFinales[2].yLat) + "\" minLon=\"" + (mc.puntosCalibracionFinales[0].xLon < mc.puntosCalibracionFinales[3].xLon ? mc.puntosCalibracionFinales[0].xLon : mc.puntosCalibracionFinales[3].xLon) + "\" maxLon=\"" + (mc.puntosCalibracionFinales[1].xLon > mc.puntosCalibracionFinales[2].xLon ? mc.puntosCalibracionFinales[1].xLon : mc.puntosCalibracionFinales[2].xLon) + "\" />\n");
        fw.append("<CalibrationPoints>\n");
        fw.append("<CalibrationPoint corner=\"TL\" lon=\"" + mc.puntosCalibracionFinales[0].xLon + "\" lat=\"" + mc.puntosCalibracionFinales[0].yLat + "\" />\n");
        fw.append("<CalibrationPoint corner=\"BR\" lon=\"" + mc.puntosCalibracionFinales[1].xLon + "\" lat=\"" + mc.puntosCalibracionFinales[1].yLat + "\" />\n");
        fw.append("<CalibrationPoint corner=\"TR\" lon=\"" + mc.puntosCalibracionFinales[2].xLon + "\" lat=\"" + mc.puntosCalibracionFinales[2].yLat + "\" />\n");
        fw.append("<CalibrationPoint corner=\"BL\" lon=\"" + mc.puntosCalibracionFinales[3].xLon + "\" lat=\"" + mc.puntosCalibracionFinales[3].yLat + "\" />\n");
        fw.append("</CalibrationPoints>\n");
        fw.append("</MapCalibration>\n");
        fw.append("</OruxTracker>\n");
        return fw.toString();
    }
}

