/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.utilidades;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import oruxmapsdesktop.calculadora.DatumAdmin;
import oruxmapsdesktop.calculadora.MapaOruxMaps;
import oruxmapsdesktop.calculadora.PuntoCalibracionMapa;
import oruxmapsdesktop.geoloc.LatLonPointImpl;
import oruxmapsdesktop.geoloc.ProjectionAdmin;
import oruxmapsdesktop.geoloc.ProjectionPointImpl;
import oruxmapsdesktop.geoloc.projection.UtmProjection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OziReader {
    private static boolean DEBUG = true;
    private static final String[] irishL = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};

    public static MapaOruxMaps lee(File f) throws Exception {
        String[] c;
        String sub;
        MapaOruxMaps mc = new MapaOruxMaps();
        BufferedReader input = new BufferedReader(new FileReader(f));
        String line = null;
        line = input.readLine().trim();
        if (!line.contains("OziExplorer Map Data File")) {
            throw new Exception("Is an Ozi .map file?");
        }
        mc.nombreMapa = input.readLine().trim();
        String mapFileName = mc.nombreMapa.replaceAll("<", " ");
        mapFileName = mapFileName.replaceAll(">", " ");
        mapFileName = mapFileName.replaceAll("\"", " ");
        mapFileName = mapFileName.replaceAll("'", " ");
        mapFileName = mapFileName.replaceAll(":", " ");
        mapFileName = mapFileName.replaceAll("\\?", " ");
        mapFileName = mapFileName.replaceAll("/", " ");
        mapFileName = mapFileName.replaceAll("\\|", " ");
        mapFileName = mapFileName.replaceAll("\\*", " ");
        mc.nombreMapa = mapFileName = mapFileName.replaceAll("\\\\", " ");
        if (mc.nombreMapa.length() > 4 && ((sub = mc.nombreMapa.substring(mc.nombreMapa.length() - 4, mc.nombreMapa.length())).equalsIgnoreCase(".jpg") || sub.equalsIgnoreCase(".png") || sub.equalsIgnoreCase(".bmp"))) {
            mc.nombreMapa = mc.nombreMapa.substring(0, mc.nombreMapa.length() - 4);
        }
        mc.dirImg = input.readLine().trim();
        input.readLine();
        line = input.readLine();
        String[] st = line.split(",");
        double shiftLat = 0.0;
        double shiftLon = 0.0;
        if (st[0].toLowerCase().trim().startsWith("auto shift")) {
            st[0] = "WGS 84";
            shiftLat = Double.parseDouble(st[2].trim()) / 3600.0;
            shiftLon = Double.parseDouble(st[3].trim()) / 3600.0;
        }
        mc.datum = DatumAdmin.determinaDatum(st[0], DatumAdmin.ORIGEN_OZI);
        double coef = 1.0;
        String mult = input.readLine();
        if (mult != null && mult.startsWith("MSF") && (c = mult.split(",")).length == 2) {
            try {
                coef = Double.parseDouble(c[1].trim());
                coef = coef > 0.0 ? 1.0 / coef : 1.0;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        input.readLine();
        input.readLine();
        line = input.readLine();
        st = line.split(",");
        String proyeccion = st[1].trim();
        while ((line = input.readLine()) != null) {
            if (line.startsWith("Point")) {
                PuntoCalibracionMapa mcp = new PuntoCalibracionMapa();
                st = line.split(",");
                try {
                    mcp.x = (int)(coef * (double)Integer.parseInt(st[2].trim()));
                    mcp.y = (int)(coef * (double)Integer.parseInt(st[3].trim()));
                    if (st[6].trim().length() > 0) {
                        mcp.yLat = shiftLat + Double.parseDouble(st[6].trim()) + Double.parseDouble(st[7].trim()) / 60.0;
                        mcp.xLon = shiftLon + Double.parseDouble(st[9].trim()) + Double.parseDouble(st[10].trim()) / 60.0;
                        if (st[8].equalsIgnoreCase("N")) {
                            mcp.northing = true;
                        } else {
                            mcp.yLat = -mcp.yLat;
                        }
                        if (!st[11].trim().equalsIgnoreCase("E")) {
                            mcp.xLon = -mcp.xLon;
                        }
                    }
                    if (st[14].trim().length() > 0) {
                        mcp.xEast = Double.parseDouble(st[14].trim());
                        mcp.yNorth = Double.parseDouble(st[15].trim());
                        mcp.grid = st[13].trim();
                        mcp.northing = true;
                        if (st.length > 16 && st[16].trim().equalsIgnoreCase("S")) {
                            mcp.northing = false;
                        }
                    }
                    mc.puntosCalibracionA.add(mcp);
                }
                catch (Exception e) {}
                continue;
            }
            if (line.startsWith("MMPXY")) {
                PuntoCalibracionMapa mcp = new PuntoCalibracionMapa();
                mc.puntosCalibracionB.add(mcp);
                st = line.split(",");
                int x = Integer.parseInt(st[2].trim());
                int y = Integer.parseInt(st[3].trim());
                mcp.x = (int)(coef * (double)x);
                mcp.y = (int)(coef * (double)y);
                continue;
            }
            if (line.startsWith("MMPLL")) {
                st = line.split(",");
                int num = Integer.parseInt(st[1].trim()) - 1;
                if (mc.puntosCalibracionB.size() <= num) continue;
                PuntoCalibracionMapa ptemp = mc.puntosCalibracionB.get(num);
                ptemp.xLon = shiftLon + Double.parseDouble(st[2].trim());
                ptemp.yLat = shiftLat + Double.parseDouble(st[3].trim());
                continue;
            }
            if (line.startsWith("Projection Setup")) {
                mc.proyeccionData = line;
                mc.proyeccion = ProjectionAdmin.determinaProjection(proyeccion, line, 0);
                mc.proyeccionData = ProjectionAdmin.parametriza(mc.proyeccion, mc.proyeccionData, mc.puntosCalibracionA);
                continue;
            }
            if (!line.startsWith("IWH")) continue;
            st = line.split(",");
            mc.altoImagen = (int)(coef * (double)Integer.parseInt(st[3].trim()));
            mc.anchoImagen = (int)(coef * (double)Integer.parseInt(st[2].trim()));
        }
        OziReader.recolocaPuntos(mc.puntosCalibracionA);
        OziReader.recolocaPuntos(mc.puntosCalibracionB);
        if (mc.proyeccion == 6) {
            OziReader.normalizaIrish(mc);
        }
        if (mc.proyeccion == 2) {
            mc.puntosCalUser = mc.puntosCalibracionA;
            OziReader.normalizaUtm(mc);
        }
        return mc;
    }

    public static void recolocaPuntos(ArrayList<PuntoCalibracionMapa> puntos) {
        PuntoCalibracionMapa temp;
        if (puntos == null || puntos.size() < 4) {
            return;
        }
        int upleft = !Double.isNaN(puntos.get((int)0).xEast) || !Double.isNaN(puntos.get((int)0).xLon) ? puntos.get((int)0).x + puntos.get((int)0).y : Integer.MAX_VALUE;
        for (int i = 1; i < puntos.size(); ++i) {
            if (puntos.get((int)i).x + puntos.get((int)i).y >= upleft || Double.isNaN(puntos.get((int)i).xEast) && Double.isNaN(puntos.get((int)i).xLon)) continue;
            upleft = puntos.get((int)i).x + puntos.get((int)i).y;
            temp = puntos.get(0);
            puntos.set(0, puntos.get(i));
            puntos.set(i, temp);
        }
        int downright = !Double.isNaN(puntos.get((int)1).xEast) || !Double.isNaN(puntos.get((int)1).xLon) ? puntos.get((int)1).x + puntos.get((int)1).y : Integer.MIN_VALUE;
        for (int i = 2; i < puntos.size(); ++i) {
            if (puntos.get((int)i).x + puntos.get((int)i).y <= downright || i == 1 || Double.isNaN(puntos.get((int)i).xEast) && Double.isNaN(puntos.get((int)i).xLon)) continue;
            downright = puntos.get((int)i).x + puntos.get((int)i).y;
            temp = puntos.get(1);
            puntos.set(1, puntos.get(i));
            puntos.set(i, temp);
        }
        int upright = !Double.isNaN(puntos.get((int)2).xEast) || !Double.isNaN(puntos.get((int)2).xLon) ? puntos.get((int)2).x - puntos.get((int)2).y : Integer.MIN_VALUE;
        for (int i = 3; i < puntos.size(); ++i) {
            if (puntos.get((int)i).x - puntos.get((int)i).y <= upright || Double.isNaN(puntos.get((int)i).xEast) && Double.isNaN(puntos.get((int)i).xLon)) continue;
            upright = puntos.get((int)i).x - puntos.get((int)i).y;
            temp = puntos.get(2);
            puntos.set(2, puntos.get(i));
            puntos.set(i, temp);
        }
    }

    private static void normalizaIrish(MapaOruxMaps mc) {
        if (!Double.isNaN(mc.puntosCalibracionA.get((int)0).xEast) && mc.puntosCalibracionA.get((int)0).grid.length() == 1) {
            for (int i = 0; i < mc.puntosCalibracionA.size(); ++i) {
                int j;
                String l = mc.puntosCalibracionA.get((int)i).grid.trim().toLowerCase();
                for (j = 0; j < 25 && l.compareToIgnoreCase(irishL[j]) != 0; ++j) {
                    ++j;
                }
                mc.puntosCalibracionA.get((int)i).xEast += (double)(j % 5 * 100000);
                mc.puntosCalibracionA.get((int)i).yNorth += (double)((4 - j / 5) * 100000);
            }
        }
    }

    private static void normalizaUtm(MapaOruxMaps mc) {
        int zona;
        if (mc.datum == 0 && !Double.isNaN(mc.puntosCalibracionA.get((int)0).xEast)) {
            zona = 0;
            try {
                zona = Integer.parseInt(mc.puntosCalibracionA.get((int)0).grid);
            }
            catch (Exception e) {
                mc.puntosCalibracionA = mc.puntosCalibracionB;
                return;
            }
            for (int i = 1; i < mc.puntosCalibracionA.size(); ++i) {
                PuntoCalibracionMapa pt = mc.puntosCalibracionA.get(i);
                int zona2 = Integer.parseInt(pt.grid);
                if (zona2 == zona) continue;
                mc.puntosCalibracionA = mc.puntosCalibracionB;
                return;
            }
        }
        if (!Double.isNaN(mc.puntosCalibracionA.get((int)0).xEast) && mc.datum > 0) {
            zona = 0;
            try {
                zona = Integer.parseInt(mc.puntosCalibracionA.get((int)0).grid);
            }
            catch (Exception e) {
                return;
            }
            UtmProjection pj = (UtmProjection)ProjectionAdmin.getProjection(mc);
            for (int i = 0; i < mc.puntosCalibracionA.size(); ++i) {
                PuntoCalibracionMapa pt = mc.puntosCalibracionA.get(i);
                int zona2 = Integer.parseInt(pt.grid);
                if (zona2 == zona) continue;
                pj.setZone(zona2);
                LatLonPointImpl llp = pj.projToLatLon(pt.xEast, pt.yNorth);
                pj.setZone(zona);
                ProjectionPointImpl pp = pj.latLonToProj(llp.getLatitude(), llp.getLongitude());
                pt.xEast = pp.getX();
                pt.yNorth = pp.getY();
            }
        }
    }
}

