/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.utilidades;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import oruxmapsdesktop.calculadora.MapaOruxMaps;

public class SqliteManager {
    private static final boolean DEBUG = true;
    private static boolean LOADED = false;
    private static final String TABLE_TILES_DDL = "CREATE TABLE IF NOT EXISTS tiles (x int, y int, z int, image blob, PRIMARY KEY (x,y,z))";
    private static final String INDEX_DDL = "CREATE INDEX IF NOT EXISTS IND on tiles (x,y,z)";
    private static final String INSERT_SQL = "INSERT or IGNORE INTO tiles (x,y,z,image) VALUES (?,?,?,?)";
    private static final String TABLE_ANDROID_METADATA_DDL = "CREATE TABLE IF NOT EXISTS android_metadata (locale TEXT)";
    private static final String DATABASE_FILENAME = "OruxMapsImages.db";
    private String databaseFile;
    private Connection conn = null;
    private PreparedStatement prepStmt;
    private int tileCounter;
    private int tilesCount;
    private final int MAX_H = 0x10000000;
    private Runtime r = Runtime.getRuntime();

    public SqliteManager(MapaOruxMaps mapa) {
        this.databaseFile = new File(mapa.dirDest + File.separator + mapa.nombreMapa, DATABASE_FILENAME).getAbsolutePath();
    }

    public void initMapCreation(int tilesCount) throws Exception {
        try {
            this.conn = this.getConnection();
            this.conn.setAutoCommit(false);
            this.initDB(tilesCount);
            this.prepStmt = this.conn.prepareStatement(INSERT_SQL);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    public void finishMapCreation() {
        this.flush();
        try {
            this.conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createTile(int tilex, int tiley, int zoom, byte[] tileData) throws Exception {
        try {
            this.prepStmt.setInt(1, tilex);
            this.prepStmt.setInt(2, tiley);
            this.prepStmt.setInt(3, zoom);
            this.prepStmt.setBytes(4, tileData);
            this.prepStmt.addBatch();
            long heapAvailable = this.r.maxMemory() - this.r.totalMemory() + this.r.freeMemory();
            ++this.tileCounter;
            if (heapAvailable < 0x10000000L || this.tileCounter == this.tilesCount) {
                this.prepStmt.executeBatch();
                this.prepStmt.clearBatch();
                this.conn.commit();
                System.gc();
            }
        }
        catch (SQLException e) {
            throw new Exception("Error adding tiles to Sqlite database!");
        }
    }

    public void flush() {
        try {
            this.prepStmt.executeBatch();
            this.prepStmt.clearBatch();
            this.conn.commit();
            System.gc();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private Connection getConnection() throws SQLException {
        if (!LOADED) {
            SqliteManager.loadDriver();
        }
        String url = "jdbc:sqlite:/" + this.databaseFile;
        this.conn = DriverManager.getConnection(url);
        return this.conn;
    }

    private void initDB(int tilesCount) throws SQLException {
        this.tilesCount = tilesCount;
        this.tileCounter = 0;
        Statement stat = this.conn.createStatement();
        stat.executeUpdate(TABLE_TILES_DDL);
        stat.executeUpdate(INDEX_DDL);
        stat.executeUpdate(TABLE_ANDROID_METADATA_DDL);
        stat.executeUpdate("INSERT INTO android_metadata VALUES ('" + Locale.getDefault().toString() + "')");
        stat.close();
    }

    public static synchronized void loadDriver() throws SQLException {
        if (LOADED) {
            return;
        }
        try {
            Class.forName("org.sqlite.JDBC");
            LOADED = true;
            return;
        }
        catch (Throwable t) {
            throw new SQLException("Problems loading SQLite library!");
        }
    }
}

