/*
 * Decompiled with CFR 0.152.
 */
package oruxmapsdesktop.utilidades;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import oruxmapsdesktop.calculadora.DatumAdmin;
import oruxmapsdesktop.calculadora.MapaOruxMaps;
import oruxmapsdesktop.calculadora.PuntoCalibracionMapa;

public class TfwReader {
    public static MapaOruxMaps lee(File f, int ancho, int alto) throws Exception {
        MapaOruxMaps mc = new MapaOruxMaps();
        BufferedReader input = new BufferedReader(new FileReader(f));
        String line = null;
        int cont = 0;
        double xEast = 0.0;
        double yNorth = 0.0;
        double xPix = 0.0;
        double yPix = 0.0;
        double yRot = 0.0;
        double xRot = 0.0;
        try {
            block10: while ((line = input.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                switch (++cont) {
                    case 1: {
                        xPix = Double.parseDouble(line);
                        continue block10;
                    }
                    case 2: {
                        yRot = Double.parseDouble(line);
                        continue block10;
                    }
                    case 3: {
                        xRot = Double.parseDouble(line);
                        continue block10;
                    }
                    case 4: {
                        yPix = Double.parseDouble(line);
                        continue block10;
                    }
                    case 5: {
                        xEast = Double.parseDouble(line);
                        continue block10;
                    }
                    case 6: {
                        yNorth = Double.parseDouble(line);
                        continue block10;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new Exception();
        }
        if (cont != 6) {
            throw new Exception();
        }
        PuntoCalibracionMapa ptemp = new PuntoCalibracionMapa();
        mc.puntosCalibracionA.add(ptemp);
        PuntoCalibracionMapa ptemp2 = new PuntoCalibracionMapa();
        mc.puntosCalibracionA.add(ptemp2);
        ptemp.xEast = xEast;
        ptemp.yNorth = yNorth;
        ptemp2.x = ancho - 1;
        ptemp2.y = alto - 1;
        ptemp2.xEast = xEast + xPix * (double)(ancho - 1) + xRot * (double)(alto - 1);
        ptemp2.yNorth = yNorth + yPix * (double)(alto - 1) + yRot * (double)(ancho - 1);
        ptemp.northing = true;
        ptemp2.northing = true;
        mc.altoImagen = alto;
        mc.anchoImagen = ancho;
        int cont2 = f.getName().length();
        int i = f.toString().toLowerCase().endsWith("tfwx") ? 5 : 4;
        mc.nombreMapa = f.getName().substring(0, cont2 - i);
        File html = new File(f.getParentFile(), mc.nombreMapa + ".htm");
        if (html != null && html.exists()) {
            TfwReader.leeHtml(html, mc);
        }
        return mc;
    }

    public static boolean leeHtml(File f, MapaOruxMaps mapa) {
        double stdp1 = Double.MAX_VALUE;
        double stdp2 = Double.MAX_VALUE;
        double orlat = Double.MAX_VALUE;
        double orlon = Double.MAX_VALUE;
        double fe = Double.MAX_VALUE;
        double fn = Double.MAX_VALUE;
        try {
            BufferedReader input = new BufferedReader(new FileReader(f));
            String line = null;
            while ((line = input.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                String s = null;
                if (line.contains("Map_Projection_Name")) {
                    s = TfwReader.getText(line);
                    if (!s.toLowerCase().equals("conic")) continue;
                    mapa.proyeccion = 8;
                    continue;
                }
                if (line.contains("Standard_Parallel")) {
                    s = TfwReader.getText(line);
                    if (stdp1 == Double.MAX_VALUE) {
                        stdp1 = Double.parseDouble(s);
                        continue;
                    }
                    stdp2 = Double.parseDouble(s);
                    continue;
                }
                if (line.contains("Longitude_of_Central_Meridian")) {
                    s = TfwReader.getText(line);
                    orlon = Double.parseDouble(s);
                    continue;
                }
                if (line.contains("Latitude_of_Projection_Origin")) {
                    s = TfwReader.getText(line);
                    orlat = Double.parseDouble(s);
                    continue;
                }
                if (line.contains("False_Easting")) {
                    s = TfwReader.getText(line);
                    fe = Double.parseDouble(s);
                    continue;
                }
                if (line.contains("False_Northing")) {
                    s = TfwReader.getText(line);
                    fn = Double.parseDouble(s);
                    continue;
                }
                if (!line.contains("Horizontal_Datum_Name") || !(s = TfwReader.getText(line)).equalsIgnoreCase("1983") && !s.equalsIgnoreCase("D_WGS_1984")) continue;
                mapa.datum = DatumAdmin.WGS84Datum().indice;
            }
            if (mapa.proyeccion > 0 && mapa.datum > 0) {
                mapa.proyeccionData = orlat + "," + orlon + "," + stdp1 + "," + stdp2 + "," + fe + "," + fn;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static String getText(String cadena) {
        String s = null;
        s = cadena.replaceAll("<[/\\w]*>", " ");
        String[] ss = s.split("[\\t\\n ]+");
        return ss[ss.length - 1].trim();
    }
}

